% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-company.R
\name{company_cash_dividends_get}
\alias{company_cash_dividends_get}
\title{Gets company's dividents in cash}
\usage{
company_cash_dividends_get(code, cache_folder = cachedir(), do_cache = TRUE)
}
\arguments{
\item{code}{Represents the company, can be the stock symbol, like \code{PETR4} or
the first four characters \code{PETR}}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}
}
\value{
data.frame with company information
}
\description{
Gets a list of all dividents in cash paid by the company.
\emph{A cash dividend is a payment made by a company out of its earnings to
investors in the form of cash.} (https://www.investopedia.com/)
}
\details{
The \code{code} parameter can be the stock symbol, but the returned data refers
to the company, always.
The returned data.frame has all company's symbols that paid dividends in
cash.
}
\examples{
\dontrun{
company_cash_dividends_get(c("PETR", "VALE", "MGLU"))
}

}
