% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_search.R
\name{bs_search}
\alias{bs_search}
\alias{bs_meta}
\title{Search BASE}
\usage{
bs_search(
  query = NULL,
  target = NULL,
  coll = NULL,
  boost_oa = FALSE,
  hits = NULL,
  offset = NULL,
  fields = NULL,
  sortby = NULL,
  facets = NULL,
  facet_limit = 100,
  facet_sort = NULL,
  filter = NULL,
  raw = FALSE,
  parse = "df",
  retry = bs_retry_options(),
  ...
)

bs_meta(x)
}
\arguments{
\item{query}{(character) query string. For syntax details see Appendix,
section "Query syntax"}

\item{target}{(character) Internal name of a single repository as
delivered in \code{\link[=bs_repositories]{bs_repositories()}}}

\item{coll}{(character) collection code. For existing, pre-defined
collections see Appendix, section "Collection-related queries"}

\item{boost_oa}{(logical) Push open access documents upwards in the
result list. Default: \code{FALSE}}

\item{hits}{(integer) number of results to return. Default: 10. Max: 100}

\item{offset}{(integer) record to start at. Default: 0. Max: 1000}

\item{fields}{(character) Fields to return. This doesn't appear to be
working though. The result records only contain fields listed in the
comma-separated field list. For existing, pre-defined fields see Appendix,
section "Fields"}

\item{sortby}{(character) field to sort by. A sort ordering must include
a single field name (see Appendix, section "Fields", table column
"Sorting"), followed by a whitespace (escaped as + or \%20 in URL strings),
followed by sort direction (asc or desc). Default: sorts by relevance}

\item{facets}{(character) The response contains an extra section
"facet_counts/facet_fields" with fields from the comma-separated facets
list. This section provides a breakdown or summary of the results. From the
user's perspective, faceted search breaks up search results into multiple
categories, typically showing counts for each, and allows the user to
"drill down" or further restrict their search results based on those facets.
Use of faceting does not affect the results section of a search response.
For existing, pre-defined facet fields see Appendix, section "Fields",
table column "Facet".}

\item{facet_limit}{(numeric) Maximum number of constraint counts that
should be returned for the facet fields. Default: 100; min:1; max: 500}

\item{facet_sort}{(character) Ordering of the facet field constraints:
count - sort by count (highest count first);  index - alphabetical sorting.
Default: count}

\item{filter}{(character) a string with the value to be used. html escaping
will be automatically done; embed string in \code{I()} to avoid html escaping.
This parameter gets used by \code{fq} solr parameter on the server}

\item{raw}{(logical) If \code{TRUE} returns raw XML, default: \code{FALSE}}

\item{parse}{(character) One of 'list' or 'df'}

\item{retry}{(list) use \code{\link[=bs_retry_options]{bs_retry_options()}} to make a named list of
retry options to pass on to the HTTP request. default values are passed
for you, but you can change them by setting an option in
\code{bs_retry_options()}}

\item{...}{Facet field based query options (See Facet below) or curl
options passed on to \link[crul:verb-GET]{crul::verb-GET}}

\item{x}{input to \code{bs_meta}}
}
\value{
XML as character string if \code{parse = FALSE} or data.frame
}
\description{
Search BASE
}
\details{
BASE asks that requests are not more frequent than 1 per second,
so we enforce the rate limit internally. if you do a single request not
in a for loop/lapply type situation, this won't be inoked, but will
if doing a for loop/lapply call, and there's no sleep invoked
}
\section{Facet}{

You can optionally pass in search term for specific facet fields.
See example. For existing, pre-defined facet fields see Appendix at
https://www.base-search.net/about/download/base_interface.pdf,
section "Fields", table column "Facet"
}

\examples{
\donttest{
# repository "ftubbiepub" containing the terms
# "lossau" and "summann" (search in the whole document)
res <- bs_search(target = 'ftubbiepub', query = 'lossau summann', hits = 3)
res$docs$dcsubject
res$docs$dccreator
res$docs$dcidentifier
}
}
