% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odata_ptax.R
\name{olinda_get_currency}
\alias{olinda_get_currency}
\title{Get currency values for a given period}
\usage{
olinda_get_currency(
  symbol,
  start_date,
  end_date = NULL,
  as = c("tibble", "xts", "data.frame", "text"),
  parity = FALSE
)
}
\arguments{
\item{symbol}{currency symbol}

\item{start_date}{time interval initial date}

\item{end_date}{time interval last date}

\item{as}{the object's returning type}

\item{parity}{\code{TRUE} returns the parity quotation (default \code{FALSE}
currency quoted in BRL)

The \code{symbol} argument is a three digits character which represents one currency.
The symbols can be obtained with \code{list_currencies}.

The time series date range is defined by \code{start_date} and \code{end_date}.
If \code{end_date} is not passed, it is set equals to \code{start_date}.

The \code{parity} argument defaults to \code{FALSE}, which means that the returned data is quoted in BRL.
If it is \code{TRUE} the returned data is quoted in USD, for type A currencies and for type B currencies it is
quoted as 1 USD in CURRENCY. For example, AUD, which is type B, returns 1 USD in AUD.}
}
\value{
The time series with the bid and ask currency rates regarding the given symbol quoted in BRL.
The default returning is a \code{tibble}-fashioned \code{data.frame} with
the three columns: \code{date}, \code{ask} and \code{bid}.
The \code{as} argument also accepts \code{data.frame} to return old fashioned data frames,
\code{xts} to return a xts object with two variables (bid and ask) and \code{text} which returns
the text content download from BCB site.
}
\description{
Given a currency symbol and a time interval (in dates) this function returns the
bid and ask time series of currency rates.
}
\examples{
\dontrun{
olinda_get_currency("USD", "2017-03-01", "2017-03-10")
}

}
