% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odata-expectativas.R
\name{get_twelve_months_inflation_expectations}
\alias{get_twelve_months_inflation_expectations}
\title{Get inflation's market expectations for the next 12 months}
\usage{
get_twelve_months_inflation_expectations(
  indic = NULL,
  start_date = NULL,
  end_date = NULL,
  ...
)
}
\arguments{
\item{indic}{a character vector with economic indicators names.
They are case sensitive and don't forget the accents.}

\item{start_date}{series initial date.
Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date.
Accepts ISO character formated date and \code{Date}.}

\item{...}{additional parameters to be passed to the API

\code{indic} argument must be one of indicators listed in Details.
Respecting the case, blank spaces and accents.

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order. There is also \code{$skip} to ignore the first rows.}
}
\value{
A \code{data.frame} with the requested data.
}
\description{
Statistics of inflation's market expectations for the next 12 months.
All statistics are computed based on expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.
}
\details{
There are inflation's expectations available for the following indicators:

\itemize{
\item IGP-DI
\item IGP-M
\item INPC
\item IPA-DI
\item IPA-M
\item IPCA
\item IPCA Administrados
\item IPCA Alimentação no domicílio
\item IPCA Bens industrializados
\item IPCA Livres
\item IPCA Serviços
\item IPCA-15
\item IPC-FIPE
}

Check <https://olinda.bcb.gov.br/olinda/servico/Expectativas/versao/v1/documentacao#ExpectativasMercadoInflacao12Meses>
for more details
}
\examples{
\dontrun{
indic <- c("IPCA", "IGP-M")
end_date <- "2018-06-22"
x <- get_twelve_months_inflation_expectations(indic, end_date = end_date, `$top` = 10)

# return all indicators for the specified date range
start_date <- "2021-01-01"
x <- get_twelve_months_inflation_expectations(start_date = start_date, `$top` = 20)
}

}
