% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BchAddresses.R
\name{PubKey2PubHash}
\alias{PubKey2PubHash}
\title{Create public key hash from 512-bit public key}
\usage{
PubKey2PubHash(pubkey, mainnet = TRUE)
}
\arguments{
\item{pubkey}{\code{character}, the public key.}

\item{mainnet}{\code{logical}, whether the key should correspond
to the mainnet or testnet.}
}
\value{
\code{character}, the hash of a public key
}
\description{
This function returns the associated public key hash
from a 512-bit public key by using the \code{hash160()} function.
}
\references{
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BchAdresses: 
\code{\link{BCHADR-class}},
\code{\link{BTCADR-class}},
\code{\link{PubHash2BchAdr}()},
\code{\link{base58CheckDecode}()},
\code{\link{base58CheckEncode}()},
\code{\link{concatHex}()},
\code{\link{decodeHex}()},
\code{\link{hash160}()},
\code{\link{hash256}()},
\code{\link{validBchAdr}()},
\code{\link{validBtcAdr}()}
}
\author{
Bernhard Pfaff
}
\concept{BchAdresses}
