% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_complex_subunits}
\alias{rba_reactome_complex_subunits}
\title{Get a Complex's Subunits}
\usage{
rba_reactome_complex_subunits(complex_id, exclude_structures = FALSE, ...)
}
\arguments{
\item{complex_id}{Reactome stable Identifier of the complex.}

\item{exclude_structures}{(logical) Should the contained complexes and
entity sets be excluded from the results? (default = FALSE)}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
Data frame which each row is a subunit of your provided complex
and the columns are pertinent information of that subunit.
}
\description{
This function will return a list of subunits which are participants of
your provided complex.
}
\details{
Subunits will be returned recursively; Which means that if a subunit was
  itself a complex, subunit of that complex will be also returned in the
  results.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/complex/{id}/subunits"
}

\examples{
\donttest{
rba_reactome_complex_subunits(complex_id = "R-HSA-5674003",
    exclude_structures = FALSE)
}
\donttest{
rba_reactome_complex_subunits(complex_id = "R-HSA-109783",
    exclude_structures = TRUE)
}

}
\references{
\itemize{
  \item Jassal B, Matthews L, Viteri G, Gong C, Lorente P, Fabregat A,
  Sidiropoulos K, Cook J, Gillespie M, Haw R, Loney F, May B, Milacic M,
  Rothfels K, Sevilla C, Shamovsky V, Shorser S, Varusai T, Weiser J, Wu G,
  Stein L, Hermjakob H, D'Eustachio P. The reactome pathway knowledgebase.
  Nucleic Acids Res. 2020 Jan 8;48(D1):D498-D503. doi: 10.1093/nar/gkz1031.
  PubMed PMID: 31691815.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  }
}
\seealso{
Other "Reactome Content Service - Physical Entity Queries": 
\code{\link{rba_reactome_complex_list}()},
\code{\link{rba_reactome_entity_other_forms}()},
\code{\link{rba_reactome_participant_of}()}
}
\concept{"Reactome Content Service - Physical Entity Queries"}
