% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr}
\alias{rba_enrichr}
\title{A One-step Wrapper for Gene-list Enrichment Using Enrichr}
\usage{
rba_enrichr(
  gene_list,
  description = NULL,
  gene_set_library = "all",
  regex_library_name = TRUE,
  organism = "human",
  progress_bar = FALSE,
  ...
)
}
\arguments{
\item{gene_list}{A vector with Entrez gene symbols.}

\item{description}{(optional) A name or description to be associated with your
uploaded gene-set to Enrichr servers.}

\item{gene_set_library}{One of the:
\enumerate{
\item "all" to select all of the available Enrichr gene-set libraries.
\item A gene-set library name existed in the results
retrieved via \code{\link{rba_enrichr_libs}}
\item If regex_library_name = TRUE, A partially-matching name a regex
pattern that correspond to one or more of Enrichr library names.
}}

\item{regex_library_name}{logical: if TRUE (default) the supplied
gene_set_library will be regarded as a regex or partially matching name. if
FALSE, gene_set_library will be considered exact match.}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{progress_bar}{logical: In case of selecting multiple Enrichr
libraries, should a progress bar be displayed?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing data frames of the enrichment results of your
  supplied gene-list against the selected Enrichr libraries.
}
\description{
This function is an easy-to-use wrapper for the multiple function calls
  necessary to enrich a given gene-list using Enrichr. see details section
  for more information.
}
\details{
This function will call other rba_enrichr_*** functions with the following
  order:
  \enumerate{
  \item (If neccessary) Call \code{\link{rba_enrichr_libs}} to obtain a list
    of available libraries in Enrichr.
  \item Call \code{\link{rba_enrichr_add_list}} to upload your gene-list
    and obtain a 'user list ID'.
  \item Call \code{\link{rba_enrichr_enrich}} to enrich the gene-list
    against one or multiple Enrichr libraries
  }
}
\section{Corresponding API Resources}{

 "GET https://maayanlab.cloud/Enrichr/datasetStatistics"
 \cr "POST https://maayanlab.cloud/Enrichr/addList"
 \cr "GET https://maayanlab.cloud/Enrichr/enrich"
}

\examples{
\donttest{
rba_enrichr(gene_list = c("TP53", "TNF", "EGFR"))
}
\donttest{
rba_enrichr(gene_list = c("TP53", "TNF", "EGFR"),
    gene_set_library = "GO_Molecular_Function_2017",
    regex_library_name = FALSE)
}
\donttest{
rba_enrichr(gene_list = c("TP53", "TNF", "EGFR"),
    gene_set_library = "go",
    regex_library_name = TRUE)
}

}
\references{
\itemize{
  \item Chen EY, Tan CM, Kou Y, Duan Q, Wang Z, Meirelles GV, Clark NR,
  Ma'ayan A. Enrichr: interactive and collaborative HTML5 gene list
  enrichment analysis tool. BMC Bioinformatics. 2013;128(14).
  \item Kuleshov MV, Jones MR, Rouillard AD, Fernandez NF, Duan Q, Wang Z,
  Koplev S, Jenkins SL, Jagodnik KM, Lachmann A, McDermott MG, Monteiro CD,
  Gundersen GW, Ma'ayan A. Enrichr: a comprehensive gene set enrichment
  analysis web server 2016 update. Nucleic Acids Research. 2016; gkw377.
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  }
}
\seealso{
Other "Enrichr": 
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()}
}
\concept{"Enrichr"}
