% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{metadata}
\alias{metadata}
\title{Get the sample metadata.}
\usage{
metadata(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
A data frame of the metadata in \code{biom}.
}
\description{
Get the sample metadata.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    
    metadata(biom)[1:4,1:3]

}
\seealso{
Other accessor functions: 
\code{\link{counts}()},
\code{\link{info}()},
\code{\link{nsamples}()},
\code{\link{ntaxa}()},
\code{\link{phylogeny}()},
\code{\link{sample.names}()},
\code{\link{sequences}()},
\code{\link{taxa.names}()},
\code{\link{taxa.ranks}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
