% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\name{taxa.ranks}
\alias{taxa.ranks}
\title{Get the taxa ranks.}
\usage{
taxa.ranks(biom)
}
\arguments{
\item{biom}{A \code{BIOM} object, as returned from \link{read.biom}.}
}
\value{
A character vector of the taxa ranks in \code{biom}.
}
\description{
Get the taxa ranks.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    
    taxa.ranks(biom)

}
\seealso{
Other accessor functions: 
\code{\link{counts}()},
\code{\link{info}()},
\code{\link{metadata}()},
\code{\link{nsamples}()},
\code{\link{ntaxa}()},
\code{\link{phylogeny}()},
\code{\link{sample.names}()},
\code{\link{sequences}()},
\code{\link{taxa.names}()},
\code{\link{taxonomy}()}
}
\concept{accessor functions}
