% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare_stacked.r
\name{rare_stacked}
\alias{rare_stacked}
\title{Visualize the number of observations per sample.}
\usage{
rare_stacked(
  biom,
  rline = TRUE,
  counts = TRUE,
  labels = TRUE,
  y.transform = "log10",
  ...
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{rline}{Where to draw a horizontal line on the plot, intended to show
a particular rarefaction depth. Set to \code{TRUE} to show an
auto-selected rarefaction depth, \code{FALSE} to not show a line, or
an integer for a custom position.
Default: \code{TRUE}.}

\item{counts}{Display the number of samples and reads remaining after
rarefying to \code{rline} reads per sample. Default: \code{TRUE}.}

\item{labels}{Show sample names under each bar. Default: \code{TRUE}.}

\item{y.transform}{Y-axis transformation. Options are \code{"log10"} or
\code{"none"}.  Default: \code{"log10"}.
Use \code{xaxis.transform} or \code{yaxis.transform} to pass custom values
directly to ggplot2's \verb{scale_*} functions.}

\item{...}{Additional parameters to pass along to ggplot2 functions.
Prefix a parameter name with \code{r.} to ensure it gets
passed to (and only to) \link[ggplot2]{geom_hline}. For instance,
\code{r.color = "black"} ensures only the horizontal rarefaction line
has its color set to \code{"black"}.}
}
\value{
A \code{ggplot2} plot. The computed data points and ggplot
command are available as \verb{$data} and \verb{$code},
respectively.
}
\description{
Visualize the number of observations per sample.
}
\examples{
    library(rbiom) 
    
    rare_stacked(hmp50)
    
    rare_stacked(hmp50, rline = 500, r.linewidth = 2, r.linetype = "twodash")
    
    fig <- rare_stacked(hmp50, counts = FALSE)
    fig$code
    
}
\seealso{
Other rarefaction: 
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rarefy}()},
\code{\link{rarefy_cols}()},
\code{\link{sample_sums}()}

Other visualization: 
\code{\link{adiv_boxplot}()},
\code{\link{adiv_corrplot}()},
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{plot_heatmap}()},
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{stats_boxplot}()},
\code{\link{stats_corrplot}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()}
}
\concept{rarefaction}
\concept{visualization}
