% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bison_stats.R
\name{bison_stats}
\alias{bison_stats}
\title{Get statistics about BISON downloads.}
\usage{
bison_stats(what = "stats", ...)
}
\arguments{
\item{what}{(character) One of stats (default), search, downnload, or wms. See Details.}

\item{...}{Further args passed on to httr::GET. See examples in \code{bison}}
}
\value{
A list of data frame's with names of the list the different data sources
}
\description{
Get statistics about BISON downloads.
}
\details{
For the 'what' parameter:
\itemize{
 \item stats - Retrieve all data provider accumulated statistics.
 \item search - Retrieve data provider statistics for BISON searches.
 \item download - Retrieve data provider statistics for data downloads from BISON.
 \item wms - Retrieve data provider statistics for BISON OGC WMS tile requests.
}
}
\examples{
\dontrun{
out <- bison_stats()
out <- bison_stats(what='search')
out <- bison_stats(what='download')
out <- bison_stats(what='wms')
out$Arctos
out$Harvard_University_Herbaria
out$ZooKeys
}
}

