% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{get_visit_distribution_parameters}
\alias{get_visit_distribution_parameters}
\title{Derive visit distribution parameters}
\usage{
get_visit_distribution_parameters(dat, beta, sigma)
}
\arguments{
\item{dat}{Patient level dataset, must be 1 row per visit. Column order must
be in the same order as beta. The number of columns must match the length of beta}

\item{beta}{List of model beta coefficients. There should be 1 element for each sample
e.g. if there were 3 samples and the models each had 4 beta coefficients then this argument
should be of the form  \code{list( c(1,2,3,4) , c(5,6,7,8), c(9,10,11,12))}.
All elements of beta must be the same length and must be the same length and order as \code{dat}.}

\item{sigma}{List of sigma. Must have the same number of entries as \code{beta}.}
}
\description{
Takes patient level data and beta coefficients and expands them
to get a patient specific estimate for the visit distribution parameters
\code{mu} and \code{sigma}. Returns the values in a specific format
which is expected by downstream functions in the imputation process
(namely  \code{list(list(mu = ..., sigma = ...), list(mu = ..., sigma = ...))}).
}
