% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmi.R
\docType{package}
\name{rbmi-package}
\alias{rbmi}
\alias{rbmi-package}
\title{rbmi: Reference Based Multiple Imputation}
\description{
The rbmi package is used to perform reference based multiple imputation. The package
provides implementations for common, patient-specific imputation strategies whilst allowing the user to
select between various standard Bayesian and frequentist approaches.

The package is designed around 4 core functions:
\itemize{
\item \code{\link[=draws]{draws()}} - Fits multiple imputation models
\item \code{\link[=impute]{impute()}} - Imputes multiple datasets
\item \code{\link[=analyse]{analyse()}} - Analyses multiple datasets
\item \code{\link[=pool]{pool()}} - Pools multiple results into a single statistic
}

To learn more about rbmi, please see the quickstart vignette:

\code{vignette(topic= "quickstart", package = "rbmi")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://insightsengineering.github.io/rbmi/}
  \item \url{https://github.com/insightsengineering/rbmi}
  \item Report bugs at \url{https://github.com/insightsengineering/rbmi/issues}
}

}
\author{
\strong{Maintainer}: Craig Gower-Page \email{craig.gower-page@roche.com}

Authors:
\itemize{
  \item Alessandro Noci \email{alessandro.noci@roche.com}
}

Other contributors:
\itemize{
  \item Marcel Wolbers \email{marcel.wolbers@roche.com} [contributor]
  \item Roche [copyright holder, funder]
}

}
\keyword{internal}
