% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorfulness.R
\name{colorfulness}
\alias{colorfulness}
\title{Quantify colorfulness}
\usage{
colorfulness(caim, m = NULL)
}
\arguments{
\item{caim}{\linkS4class{SpatRaster}. The return of a call to \code{\link[=read_caim]{read_caim()}} or
\code{\link[=read_caim_raw]{read_caim_raw()}}.}

\item{m}{\linkS4class{SpatRaster}. A mask. For hemispherical photographs, check
\code{\link[=mask_hs]{mask_hs()}}. Default (\code{NULL}) is the equivalent to enter
\code{!is.na(caim$Red)}.}
}
\value{
A numeric vector of length one.
}
\description{
Quantify the colorfulness of an image
}
\details{
Quantify the colorfulness of an sRGB image using a bidimensional space formed
by the green/red and the blue/yellow axes of the \emph{CIE LAB} space,
symbolized with \emph{A} and \emph{B}, respectively. The colorfulness index
(CI) is defined as

\eqn{CI = \dfrac{A_o}{A_p} \cdot 100},

where \eqn{A_o} and \eqn{A_p} are the observed and potential area of the
\emph{AB} plane. \eqn{A_o} refers to the colors from the image while
\eqn{A_p} to the colors from the whole sRGB cube.
}
\note{
An early version of this function was used in
\insertCite{Martin2020;textual}{rcaiman}.
}
\examples{
caim <- read_caim() \%>\% normalize()
colorfulness(caim)
}
\references{
\insertAllCited{}
}
\seealso{
Other Tool Functions: 
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sky_points}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
