% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_fuzzy_thresholding.R
\name{local_fuzzy_thresholding}
\alias{local_fuzzy_thresholding}
\title{Local fuzzy thresholding}
\usage{
local_fuzzy_thresholding(lightness, m, mem, thr = NULL, fuzziness = NULL)
}
\arguments{
\item{lightness}{\linkS4class{SpatRaster}. A normalized greyscale image (see
\code{\link[=normalize]{normalize()}}).}

\item{m}{\linkS4class{SpatRaster}. A mask. For hemispherical photographs,
check \code{\link[=mask_hs]{mask_hs()}}.}

\item{mem}{\linkS4class{SpatRaster}. It is the scale parameter of the logistic
membership function. Typically it is obtained with \code{\link[=membership_to_color]{membership_to_color()}}.}

\item{thr}{Numeric vector of length one. Location parameter of the logistic
membership function. Use \code{NULL} to estimate it automatically with
\code{\link[=thr_isodata]{thr_isodata()}}.}

\item{fuzziness}{Numeric vector of length one. This number is a constant
value that scales \code{mem}. Use \code{NULL} to estimate it automatically as the
midpoint between the maximum and minimum values of \code{lightness}.}
}
\value{
An object of class \linkS4class{SpatRaster} with same pixel dimensions than
\code{caim}. Depending on \code{mem}, changes could be subtle.
}
\description{
This function was first presented in \insertCite{Diaz2015;textual}{rcaiman}.
It uses a threshold value as the location parameter of a logistic membership
function whose scale parameter depends on a variable, here named \code{mem}. This
dependence can be explained as follows: if the variable is equal to \code{1}, then
the membership function is same as a threshold function because the scale
parameter is \code{0}; lowering the variable increases the scale parameter, thus
blurring the threshold because it decreases the steepness of the curve. Since
the variable is defined pixel by pixel, this should be considered as a
\strong{local} fuzzy thresholding method.
}
\details{
Argument \code{m} can be used to affect the automatic estimation of \code{thr} and
\code{fuzziness}.

If you use this function in your research, please cite
\insertCite{Diaz2015;textual}{rcaiman} in addition to this package
(\verb{citation("rcaiman"}).
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

caim <- normalize(caim)

# ImageJ can be used to digitize points
path <- system.file("external/sky_points.csv",
                    package = "rcaiman")
img_points <- read.csv(path)
img_points <- img_points[c("Y", "X")]
colnames(img_points) <- c("row", "col")
head(img_points)
target_color <- extract_dn(caim, img_points, fun = median)
as(target_color, "HSV")
target_color <- HSV(240, 0.85, 0.5) #to increase saturation

mem <- membership_to_color(caim, target_color)
mem_thr <- local_fuzzy_thresholding(mean(caim), m,  mem$membership_to_grey)
plot(mem_thr)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Pre-processing Functions: 
\code{\link{enhance_caim}()},
\code{\link{gbc}()},
\code{\link{membership_to_color}()},
\code{\link{normalize}()}
}
\concept{Pre-processing Functions}
