/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Vector3d;
import org.jmol.api.JmolAdapter;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IPDBAtom;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.protein.data.PDBPolymer;
import org.openscience.cdk.protein.data.PDBStructure;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class CdkJmolAdapter
extends JmolAdapter {
    public static final String ATOM_SET_INDEX = "org.jmol.adapter.cdk.ATOM_SET_INDEX";

    public CdkJmolAdapter(JmolAdapter.Logger logger) {
        super("CdkJmolAdapter", logger);
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        IChemFile chemFile = null;
        try {
            IChemObjectReader chemObjectReader = null;
            try {
                chemObjectReader = new ReaderFactory().createReader((Reader)bufferedReader);
            }
            catch (IOException ex) {
                return "Jmol: Error determining input format: " + ex;
            }
            if (chemObjectReader == null) {
                return "Jmol: unrecognized input format";
            }
            chemFile = (IChemFile)chemObjectReader.read((IChemObject)new ChemFile());
        }
        catch (CDKException ex) {
            return "Error reading input:" + (Object)((Object)ex);
        }
        if (chemFile == null) {
            return "unknown error reading file";
        }
        AtomTypeFactory factory = AtomTypeFactory.getInstance((String)"pdb_atomtypes.txt", (IChemObjectBuilder)chemFile.getBuilder());
        IAtomContainer atomContainer = ChemFileManipulator.getAllInOneContainer((IChemFile)chemFile);
        Iterator it = atomContainer.atoms();
        while (it.hasNext()) {
            IAtom atom = (IAtom)it.next();
            try {
                if (atom instanceof IPDBAtom) {
                    IPDBAtom pdbAtom = (IPDBAtom)atom;
                    String atName = pdbAtom.getAtomTypeName();
                    if (atName.indexOf(".") != -1) {
                        atName = atName.substring(atName.indexOf(".") + 1);
                    }
                    IAtomType type = factory.getAtomType(atName);
                    AtomTypeManipulator.configure((IAtom)pdbAtom, (IAtomType)type);
                    continue;
                }
                factory.configure(atom);
            }
            catch (CDKException exception) {}
        }
        return chemFile;
    }

    public String getFileTypeName(Object clientFile) {
        if (clientFile instanceof PDBPolymer) {
            return "pdb";
        }
        return "other";
    }

    public String getAtomSetCollectionName(Object clientFile) {
        Object title;
        if (clientFile instanceof IChemObject && (title = ((IChemObject)clientFile).getProperty((Object)"Title")) != null) {
            return title.toString();
        }
        return null;
    }

    public int getAtomSetCount(Object clientFile) {
        if (clientFile instanceof IAtomContainer) {
            return 1;
        }
        if (clientFile instanceof IChemFile) {
            return ChemFileManipulator.getAllChemModels((IChemFile)((IChemFile)clientFile)).size();
        }
        return 0;
    }

    public int getEstimatedAtomCount(Object clientFile) {
        if (clientFile instanceof IAtomContainer) {
            return ((IAtomContainer)clientFile).getAtomCount();
        }
        if (clientFile instanceof IChemFile) {
            return ChemFileManipulator.getAtomCount((IChemFile)((IChemFile)clientFile));
        }
        return 0;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        if (clientFile instanceof ICrystal) {
            ICrystal crystal = (ICrystal)clientFile;
            double[] notional = CrystalGeometryTools.cartesianToNotional((Vector3d)crystal.getA(), (Vector3d)crystal.getB(), (Vector3d)crystal.getC());
            float[] fNotional = new float[6];
            for (int i = 0; i < 6; ++i) {
                fNotional[i] = (float)notional[i];
            }
            return fNotional;
        }
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        Object value = ((IAtom)clientAtom).getProperty((Object)propertyName);
        return value == null ? null : "" + value;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator((IChemFile)clientFile);
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator((IChemFile)clientFile);
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object clientFile) {
        if (clientFile instanceof IChemFile) {
            return new StructureIterator((IChemFile)clientFile);
        }
        return null;
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        int structureCount;
        Iterator structures;
        PDBStructure structure;
        int istructure;

        StructureIterator(IChemFile chemFile) {
            super((JmolAdapter)CdkJmolAdapter.this);
            this.structures = new ArrayList(0).iterator();
            if (chemFile == null) {
                return;
            }
            List models = ChemFileManipulator.getAllChemModels((IChemFile)chemFile);
            if (models.size() == 0) {
                return;
            }
            List containers = ChemModelManipulator.getAllAtomContainers((IChemModel)((IChemModel)models.get(0)));
            if (containers.size() == 0) {
                return;
            }
            if (!(containers.get(0) instanceof PDBPolymer)) {
                return;
            }
            PDBPolymer polymer = (PDBPolymer)containers.get(0);
            Collection pdbStructures = polymer.getStructures();
            if (pdbStructures == null) {
                return;
            }
            this.structures = pdbStructures.iterator();
        }

        public boolean hasNext() {
            if (!this.structures.hasNext()) {
                return false;
            }
            this.structure = (PDBStructure)this.structures.next();
            return true;
        }

        public String getStructureType() {
            return this.structure.getStructureType();
        }

        public char getStartChainID() {
            return this.structure.getStartChainID();
        }

        public int getStartSequenceNumber() {
            return this.structure.getStartSequenceNumber();
        }

        public char getStartInsertionCode() {
            return this.structure.getStartInsertionCode();
        }

        public char getEndChainID() {
            return this.structure.getEndChainID();
        }

        public int getEndSequenceNumber() {
            return this.structure.getEndSequenceNumber();
        }

        public char getEndInsertionCode() {
            return this.structure.getEndInsertionCode();
        }

        public int getModelIndex() {
            return 1;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        IChemFile chemFile;
        int modelCount;
        int imodel;
        int bondCount;
        int ibond;
        int containerCount;
        int icontainer;
        IBond bond;
        List models;
        List containers;

        BondIterator(IChemFile chemFile) {
            super((JmolAdapter)CdkJmolAdapter.this);
            this.chemFile = chemFile;
            this.bondCount = 0;
            this.models = ChemFileManipulator.getAllChemModels((IChemFile)chemFile);
            this.modelCount = this.models.size();
            if (this.modelCount > 0) {
                this.containers = ChemModelManipulator.getAllAtomContainers((IChemModel)((IChemModel)this.models.get(0)));
                if (this.containerCount > 0) {
                    this.bondCount = ((IAtomContainer)this.containers.get(0)).getBondCount();
                }
            }
            this.ibond = 0;
            this.imodel = 0;
            this.icontainer = 0;
        }

        public boolean hasNext() {
            boolean isOK;
            if (this.ibond == this.bondCount) {
                ++this.icontainer;
                if (this.icontainer >= this.containerCount) {
                    ++this.imodel;
                    if (this.imodel >= this.models.size()) {
                        return false;
                    }
                    this.containers = ChemModelManipulator.getAllAtomContainers((IChemModel)((IChemModel)this.models.get(this.imodel)));
                    this.containerCount = this.containers.size();
                    if (this.containerCount == 0) {
                        return false;
                    }
                    this.icontainer = 0;
                }
                this.bondCount = ((IAtomContainer)this.containers.get(this.icontainer)).getBondCount();
                this.ibond = 0;
                return this.hasNext();
            }
            this.bond = ((IAtomContainer)this.containers.get(this.icontainer)).getBond(this.ibond++);
            boolean bl = isOK = this.bond.getAtomCount() == 2 && this.bond.getAtom(0) != null && this.bond.getAtom(1) != null;
            if (!isOK) {
                return this.hasNext();
            }
            return true;
        }

        public Object getAtomUniqueID1() {
            return this.bond.getAtomCount() == 2 ? this.bond.getAtom(0) : null;
        }

        public Object getAtomUniqueID2() {
            return this.bond.getAtomCount() == 2 ? this.bond.getAtom(1) : null;
        }

        public int getEncodedOrder() {
            return (int)this.bond.getOrder();
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        IChemFile chemFile;
        int atomCount;
        int iatom;
        int modelCount;
        int imodel;
        int icontainer;
        List models;
        List containers;
        IAtom atom;

        AtomIterator(IChemFile chemFile) {
            super((JmolAdapter)CdkJmolAdapter.this);
            this.chemFile = chemFile;
            this.models = ChemFileManipulator.getAllChemModels((IChemFile)chemFile);
            this.modelCount = this.models.size();
            if (this.modelCount > 0) {
                this.containers = ChemModelManipulator.getAllAtomContainers((IChemModel)((IChemModel)this.models.iterator().next()));
                if (this.containers.iterator().hasNext()) {
                    this.atomCount = ((IAtomContainer)this.containers.get(0)).getAtomCount();
                }
            }
            this.iatom = 0;
            this.imodel = 0;
            this.icontainer = 0;
        }

        public boolean hasNext() {
            if (this.modelCount == 0) {
                return false;
            }
            if (this.iatom == this.atomCount) {
                ++this.icontainer;
                if (this.icontainer == this.containers.size()) {
                    ++this.imodel;
                    if (this.imodel == this.modelCount) {
                        return false;
                    }
                    this.containers = ChemModelManipulator.getAllAtomContainers((IChemModel)((IChemModel)this.models.get(this.imodel)));
                    if (this.containers.size() == 0) {
                        return false;
                    }
                    this.icontainer = 0;
                }
                try {
                    this.atomCount = ((IAtomContainer)this.containers.get(this.icontainer)).getAtomCount();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                this.iatom = 0;
                return this.hasNext();
            }
            this.atom = ((IAtomContainer)this.containers.get(this.icontainer)).getAtom(this.iatom++);
            return true;
        }

        public int getAtomSerial() {
            return this.iatom;
        }

        public Object getUniqueID() {
            return this.atom;
        }

        public int getElementNumber() {
            int atomicNum = this.atom.getAtomicNumber();
            if (atomicNum == 0) {
                atomicNum = -1;
            }
            return atomicNum;
        }

        public String getElementSymbol() {
            return this.atom.getSymbol();
        }

        public float getX() {
            return this.atom.getPoint3d() == null ? 0.0f : (float)this.atom.getPoint3d().x;
        }

        public float getY() {
            return this.atom.getPoint3d() == null ? 0.0f : (float)this.atom.getPoint3d().y;
        }

        public float getZ() {
            return this.atom.getPoint3d() == null ? 0.0f : (float)this.atom.getPoint3d().z;
        }

        public String getPdbAtomRecord() {
            return (String)this.atom.getProperty((Object)"pdb.record");
        }

        public String getAtomName() {
            if (this.atom instanceof IPDBAtom) {
                IPDBAtom pdbAtom = (IPDBAtom)this.atom;
                return pdbAtom.getName();
            }
            return super.getAtomName();
        }

        public int getAtomSetIndex() {
            return this.imodel;
        }

        public char getChainID() {
            IPDBAtom pdbAtom;
            if (this.atom instanceof IPDBAtom && (pdbAtom = (IPDBAtom)this.atom).getChainID().length() > 0) {
                return pdbAtom.getChainID().charAt(0);
            }
            return super.getChainID();
        }

        public String getGroup3() {
            IPDBAtom pdbAtom;
            if (this.atom instanceof IPDBAtom && (pdbAtom = (IPDBAtom)this.atom).getResName() != null && pdbAtom.getResName().length() > 0) {
                return pdbAtom.getResName();
            }
            return super.getGroup3();
        }

        public int getSequenceNumber() {
            IPDBAtom pdbAtom;
            if (this.atom instanceof IPDBAtom && (pdbAtom = (IPDBAtom)this.atom).getResSeq().length() > 0) {
                return Integer.parseInt(pdbAtom.getResSeq());
            }
            return super.getSequenceNumber();
        }

        public char getInsertionCode() {
            IPDBAtom pdbAtom;
            if (this.atom instanceof IPDBAtom && (pdbAtom = (IPDBAtom)this.atom).getICode().length() > 0) {
                return pdbAtom.getICode().charAt(0);
            }
            return super.getInsertionCode();
        }

        public Object getClientAtomReference() {
            return this.atom;
        }
    }
}

