/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openscience.cdk.applications.jchempaint.JChemPaintMenuBar;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.controller.CDKPopupMenu;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.LoggingTool;

public class JCPAction
extends AbstractAction {
    private static final long serialVersionUID = -4056416630614934238L;
    public static final String actionSuffix = "Action";
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    protected static LoggingTool logger = null;
    private Hashtable actions = null;
    private Hashtable popupActions = null;
    protected String type;
    protected JChemPaintPanel jcpPanel = null;
    private boolean isPopupAction;

    public JCPAction(JChemPaintPanel jcpPanel, String type, boolean isPopupAction) {
        if (logger == null) {
            logger = new LoggingTool((Object)this);
        }
        if (this.actions == null) {
            this.actions = new Hashtable();
        }
        if (this.popupActions == null) {
            this.popupActions = new Hashtable();
        }
        this.type = "";
        this.isPopupAction = isPopupAction;
        this.jcpPanel = jcpPanel;
    }

    public JCPAction(JChemPaintPanel jcpPanel, boolean isPopupAction) {
        this(jcpPanel, "", isPopupAction);
    }

    public JCPAction(JChemPaintPanel jcpPanel) {
        this(jcpPanel, false);
    }

    public JCPAction() {
        this((JChemPaintPanel)null);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setJChemPaintPanel(JChemPaintPanel jcpPanel) {
        this.jcpPanel = jcpPanel;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isPopupAction() {
        return this.isPopupAction;
    }

    public void setIsPopupAction(boolean isPopupAction) {
        this.isPopupAction = isPopupAction;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public IChemObject getSource(ActionEvent event) {
        Object source = event.getSource();
        logger.debug((Object)"event source: ", source);
        if (source instanceof JMenuItem) {
            Container parent = ((JMenuItem)source).getComponent().getParent();
            if (parent instanceof CDKPopupMenu) {
                return ((CDKPopupMenu)parent).getSource();
            }
            if (parent instanceof JPopupMenu) {
                logger.debug((Object)"Submenu... need to recurse into CDKPopupMenu...");
                while (!(parent instanceof CDKPopupMenu)) {
                    logger.debug((Object)"  Parent instanceof ", (Object)parent.getClass().getName());
                    if (parent instanceof JPopupMenu) {
                        parent = ((JPopupMenu)parent).getInvoker().getParent();
                        continue;
                    }
                    if (parent instanceof JChemPaintMenuBar) {
                        logger.warn((Object)" Source is MenuBar. MenuBar items don't know about the source");
                        return null;
                    }
                    logger.error((Object)" Cannot get parent!");
                    return null;
                }
                return ((CDKPopupMenu)parent).getSource();
            }
        }
        return null;
    }

    public JCPAction getAction(JChemPaintPanel jcpPanel, String actionname, boolean isPopupAction) {
        JCPAction dummy = new JCPAction(jcpPanel);
        String type = "";
        String classname = "";
        int index = actionname.indexOf("@");
        if (index >= 0) {
            classname = actionname.substring(0, index);
            type = actionname.substring(index + 1);
        } else {
            classname = actionname;
        }
        logger.debug((Object)"Action class: ", (Object)classname);
        logger.debug((Object)"Action type:  ", (Object)type);
        if (!isPopupAction && this.actions.containsKey(actionname)) {
            logger.debug((Object)"Taking JCPAction from action cache for:", (Object)actionname);
            return (JCPAction)this.actions.get(actionname);
        }
        if (isPopupAction && this.popupActions.containsKey(actionname)) {
            logger.debug((Object)"Taking JCPAction from popup cache for:", (Object)actionname);
            return (JCPAction)this.popupActions.get(actionname);
        }
        logger.debug((Object)"Loading JCPAction class for:", (Object)classname);
        Object o = null;
        try {
            o = dummy.getClass().getClassLoader().loadClass(classname).newInstance();
        }
        catch (Exception exc) {
            logger.error((Object)"Could not find/instantiate class: ", (Object)classname);
            logger.debug((Object)exc);
            return dummy;
        }
        if (o instanceof JCPAction) {
            JCPAction a = o;
            a.setJChemPaintPanel(jcpPanel);
            if (type.length() > 0) {
                a.setType(type);
            }
            if (isPopupAction) {
                this.popupActions.put(actionname, a);
            } else {
                this.actions.put(actionname, a);
            }
            return a;
        }
        logger.error((Object)"Action is not a JCPAction!");
        return dummy;
    }

    public JCPAction getAction(JChemPaintPanel jcpPanel, String actionname) {
        return this.getAction(jcpPanel, actionname, false);
    }
}

