/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.interfaces.IAtomContainer;

public class PrintAction
extends JCPAction
implements Printable {
    private static final long serialVersionUID = 3944389510342678007L;

    public void actionPerformed(ActionEvent event) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        IAtomContainer beforePrinting = this.jcpPanel.getJChemPaintModel().getRendererModel().getSelectedPart();
        this.jcpPanel.getJChemPaintModel().getRendererModel().setSelectedPart((IAtomContainer)new AtomContainer());
        if (pageIndex > 0) {
            this.jcpPanel.getJChemPaintModel().getRendererModel().setSelectedPart(beforePrinting);
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.jcpPanel.getDrawingPanel().setDoubleBuffered(false);
        this.jcpPanel.getDrawingPanel().paint(g2d);
        this.jcpPanel.getDrawingPanel().setDoubleBuffered(true);
        if (beforePrinting != null) {
            this.jcpPanel.getJChemPaintModel().getRendererModel().setSelectedPart(beforePrinting);
        }
        return 0;
    }
}

