/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.tools.LoggingTool;

public class AboutDialog
extends JFrame {
    private static final long serialVersionUID = 8890609574363086221L;
    protected static LoggingTool logger = null;

    public AboutDialog() {
        super("About JChemPaint");
        logger = new LoggingTool((Object)this);
        this.doInit();
    }

    public void doInit() {
        Package self = Package.getPackage("org.openscience.cdk.applications.jchempaint");
        String version = self.getImplementationVersion();
        String s1 = "JChemPaint " + version + "\n";
        s1 = s1 + "An open-source editor for 2D chemical structures.";
        String s2 = "An OpenScience project by Christoph Steinbeck, Egon Willighagen and others.\n";
        s2 = s2 + "See 'http://jchempaint.sourceforge.net' for more information.";
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.white);
        JLabel label1 = new JLabel();
        try {
            JCPPropertyHandler jcpph = JCPPropertyHandler.getInstance();
            URL url = jcpph.getResource("jcplogoImage");
            ImageIcon icon = new ImageIcon(url);
            label1 = new JLabel(icon);
        }
        catch (Exception exception) {
            logger.error((Object)("Cannot add JCP logo: " + exception.getMessage()));
            logger.debug((Object)exception);
        }
        label1.setBackground(Color.white);
        Border lb = BorderFactory.createLineBorder(Color.white, 5);
        JTextArea jtf1 = new JTextArea(s1);
        jtf1.setBorder(lb);
        jtf1.setEditable(false);
        JTextArea jtf2 = new JTextArea(s2);
        jtf2.setEditable(false);
        jtf2.setBorder(lb);
        this.setTitle("About JChemPaint");
        this.getContentPane().add("Center", label1);
        this.getContentPane().add("North", jtf1);
        this.getContentPane().add("South", jtf2);
        this.pack();
        this.setVisible(true);
    }
}

