/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.io;

import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openscience.cdk.applications.jchempaint.io.IJCPFileFilter;
import org.openscience.cdk.applications.jchempaint.io.JCPSaveFileFilter;

public class JCPFileFilter
extends FileFilter
implements IJCPFileFilter {
    public static final String rxn = "rxn";
    public static final String rdf = "rdf";
    public static final String sdf = "sdf";
    public static final String mol = "mol";
    public static final String cml = "cml";
    public static final String xml = "xml";
    public static final String inchi = "txt";
    public static final String smi = "smi";
    protected Vector types = new Vector();

    public JCPFileFilter(String type) {
        this.types.add(type);
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public static void addChoosableFileFilters(JFileChooser chooser) {
        chooser.addChoosableFileFilter(new JCPSaveFileFilter(mol));
        chooser.addChoosableFileFilter(new JCPFileFilter(smi));
        chooser.addChoosableFileFilter(new JCPFileFilter(inchi));
        chooser.addChoosableFileFilter(new JCPFileFilter(sdf));
        chooser.addChoosableFileFilter(new JCPFileFilter(rxn));
        chooser.addChoosableFileFilter(new JCPFileFilter(rdf));
        JCPFileFilter cmlFilter = new JCPFileFilter(cml);
        cmlFilter.addType(xml);
        chooser.addChoosableFileFilter(cmlFilter);
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = JCPFileFilter.getExtension(f);
        if (extension != null) {
            return this.types.contains(extension);
        }
        return false;
    }

    public String getDescription() {
        String type = (String)this.types.elementAt(0);
        if (type.equals(mol)) {
            return "MDL MOL file";
        }
        if (type.equals(sdf)) {
            return "MDL SDF Molfile";
        }
        if (type.equals(rxn)) {
            return "MDL RXN Molfile";
        }
        if (type.equals(rdf)) {
            return "MDL RDF Molfile";
        }
        if (type.equals(inchi)) {
            return "IUPAC Chemical Identifier";
        }
        if (type.equals(smi)) {
            return "SMILES";
        }
        if (type.equals(cml) || type.equals(xml)) {
            return "Chemical Markup Language";
        }
        return null;
    }

    public String getType() {
        return (String)this.types.elementAt(0);
    }

    public void setType(String type) {
        this.types.add(type);
    }
}

