/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class AtomSetCollection
extends Parser {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells"};
    static final int GLOBAL_FRACTCOORD = 0;
    static final int GLOBAL_SYMMETRY = 1;
    static final int GLOBAL_latticeCells = 2;
    static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    static final String[] dictRefUnitcellTags = new String[]{"cif:_cell_length_a", "cif:_cell_length_b", "cif:cell_length_c", "cif:_cell_length_alpha", "cif:_cell_length_beta", "cif:_cell_length_gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    int[] latticeCells;
    String errorMessage;
    float wavelength = Float.NaN;
    boolean coordinatesAreFractional;
    float[] notionalUnitCell = new float[6];
    SpaceGroup spaceGroup;
    UnitCell unitCell;
    boolean doNormalize = true;
    Point3f[] cartesians;
    Hashtable atomSymbolicMap = new Hashtable();

    AtomSetCollection(String fileTypeName) {
        this.fileTypeName = fileTypeName;
        this.atomSetCollectionProperties.put("PATH_KEY", ".PATH");
        this.atomSetCollectionProperties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    AtomSetCollection(AtomSetCollection[] array) {
        this("Array");
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < array.length; ++i) {
            this.appendAtomSetCollection(i, array[i]);
        }
    }

    void setFileTypeName(String type) {
        this.fileTypeName = type;
    }

    protected void appendAtomSetCollection(int collectionIndex, AtomSetCollection collection) {
        int existingAtomsCount = this.atomCount;
        int clonedAtoms = 0;
        for (int atomSetNum = 0; atomSetNum < collection.atomSetCount; ++atomSetNum) {
            this.newAtomSet();
            this.setAtomSetName(collection.getAtomSetName(atomSetNum));
            Properties properties = collection.getAtomSetProperties(atomSetNum);
            if (properties != null) {
                Enumeration<Object> props = properties.keys();
                while (props != null && props.hasMoreElements()) {
                    String key = (String)props.nextElement();
                    this.setAtomSetProperty(key, properties.getProperty(key));
                }
            }
            for (int atomNum = 0; atomNum < collection.atomSetAtomCounts[atomSetNum]; ++atomNum) {
                this.newCloneAtom(collection.atoms[clonedAtoms]);
                ++clonedAtoms;
            }
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = collection.atomSetAuxiliaryInfo[atomSetNum];
            for (int i = 0; i < collection.structureCount; ++i) {
                if (collection.structures[i].modelIndex != atomSetNum && collection.structures[i].modelIndex != -1) continue;
                this.addStructure(collection.structures[i]);
            }
            this.atomSetNames[this.currentAtomSetIndex] = collection.atomSetNames[atomSetNum];
            this.atomSetNumbers[this.currentAtomSetIndex] = (collectionIndex + 1) * 1000 + collection.atomSetNumbers[atomSetNum];
        }
        for (int bondNum = 0; bondNum < collection.bondCount; ++bondNum) {
            Bond bond = collection.bonds[bondNum];
            this.addNewBond(bond.atomIndex1 + existingAtomsCount, bond.atomIndex2 + existingAtomsCount, bond.order);
        }
        int i = globalBooleans.length;
        while (--i >= 0) {
            if ((Boolean)collection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[i]) != Boolean.TRUE) continue;
            this.setGlobalBoolean(i);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.notionalUnitCell = null;
        this.spaceGroup = null;
        this.structures = new Structure[16];
        this.atomSetNumbers = new int[16];
        this.atomSetNames = new String[16];
        this.atomSetAtomCounts = new int[16];
        this.atomSetProperties = new Properties[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.structureCount = 0;
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
    }

    void freeze() {
        this.getAltLocLists();
        this.getInsertionLists();
    }

    void discardPreviousAtoms() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.atomCount = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        i = this.atomSetNumbers.length;
        while (--i >= 0) {
            this.atomSetAtomCounts[i] = 0;
            this.atomSetNumbers[i] = 0;
            this.atomSetNames[i] = null;
        }
    }

    void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) {
        Atom clone = atom.cloneAtom();
        this.addAtom(clone);
        return clone;
    }

    void cloneFirstAtomSet() {
        this.newAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int i = 0; i < firstCount; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    void cloneFirstAtomSetWithBonds(int nBonds) {
        this.cloneFirstAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int bondNum = 0; bondNum < nBonds; ++bondNum) {
            Bond bond = this.bonds[this.bondCount - nBonds];
            this.addNewBond(bond.atomIndex1 + firstCount, bond.atomIndex2 + firstCount, bond.order);
        }
    }

    void cloneLastAtomSet() {
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--count >= 0) {
            this.newCloneAtom(this.atoms[atomIndex]);
            ++atomIndex;
        }
    }

    int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.atomSetCount = 1;
            this.currentAtomSetIndex = 0;
            this.atomSetNumbers[0] = 1;
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n] + 1;
        this.atomSetAtomCounts[n] = n2;
        atom.atomSite = n2;
    }

    void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    Bond addNewBond(int atomIndex1, int atomIndex2) {
        return this.addNewBond(atomIndex1, atomIndex2, 1);
    }

    Bond addNewBond(String atomName1, String atomName2) {
        return this.addNewBond(atomName1, atomName2, 1);
    }

    Bond addNewBond(int atomIndex1, int atomIndex2, int order) {
        if (atomIndex1 < 0 || atomIndex1 >= this.atomCount || atomIndex2 < 0 || atomIndex2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(atomIndex1, atomIndex2, order);
        this.addBond(bond);
        return bond;
    }

    Bond addNewBond(String atomName1, String atomName2, int order) {
        return this.addNewBond(this.getAtomNameIndex(atomName1), this.getAtomNameIndex(atomName2), order);
    }

    Bond addNewBondWithMappedSerialNumbers(int atomSerial1, int atomSerial2, int order) {
        return this.addNewBond(this.getAtomSerialNumberIndex(atomSerial1), this.getAtomSerialNumberIndex(atomSerial2), order);
    }

    void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order <= 0) {
            Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + ":" + bond.order);
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
    }

    void setAtomSetSpaceGroupName(String spaceGroupName) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", spaceGroupName + "");
    }

    void setCoordinatesAreFractional(boolean coordinatesAreFractional) {
        this.coordinatesAreFractional = coordinatesAreFractional;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", new Boolean(coordinatesAreFractional));
        if (coordinatesAreFractional) {
            this.setGlobalBoolean(0);
        }
    }

    void setLatticeCells(int[] latticeCells) {
        this.latticeCells = latticeCells;
        this.doNormalize = latticeCells[0] < 9 && latticeCells[1] < 9 || latticeCells[2] != 0;
    }

    boolean setNotionalUnitCell(float[] info) {
        this.notionalUnitCell = new float[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.notionalUnitCell[i] = info[i];
        }
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.unitCell = new UnitCell(this.notionalUnitCell);
        return true;
    }

    void setGlobalBoolean(int globalIndex) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[globalIndex], Boolean.TRUE);
    }

    boolean addSymmetry(String xyz) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(this.doNormalize);
        }
        return this.spaceGroup.addSymmetry(xyz);
    }

    void setLatticeParameter(int latt) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(this.doNormalize);
        }
        this.spaceGroup.setLattice(latt);
    }

    void applySymmetry() {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], this.latticeCells[2]);
    }

    void applySymmetry(SpaceGroup spaceGroup) {
        this.spaceGroup = spaceGroup;
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], this.latticeCells[2]);
    }

    void applySymmetry(int maxX, int maxY, int maxZ) {
        if (!this.coordinatesAreFractional || this.spaceGroup == null) {
            return;
        }
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        SymmetryOperation[] finalOperations = this.spaceGroup.getFinalOperations(this.atoms, atomIndex, count, this.doNormalize);
        for (int i = 0; i < count; ++i) {
            this.atoms[i + atomIndex].bsSymmetry = new BitSet();
        }
        int operationCount = finalOperations.length;
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        if (maxX > 9 || maxY > 9) {
            minX = maxX / 100 - 5;
            minY = maxX % 100 / 10 - 5;
            minZ = maxX % 10 - 5;
            maxX = maxY / 100 - 4;
            maxZ = maxY % 10 - 4;
            maxY = maxY % 100 / 10 - 4;
        }
        this.cartesians = new Point3f[count * operationCount * (maxX - minX) * (maxY - minY) * (maxZ - minZ)];
        int pt = 0;
        if (this.cartesians.length > 0) {
            pt = this.symmetryAddAtoms(finalOperations, atomIndex, count, 0, 0, 0, pt);
        }
        for (int tx = minX; tx < maxX; ++tx) {
            for (int ty = minY; ty < maxY; ++ty) {
                for (int tz = minZ; tz < maxZ; ++tz) {
                    if (tx == 0 && ty == 0 && tz == 0) continue;
                    pt = this.symmetryAddAtoms(finalOperations, atomIndex, count, tx, ty, tz, pt);
                }
            }
        }
        if (operationCount > 0) {
            String[] symmetryList = new String[operationCount];
            for (int i = 0; i < operationCount; ++i) {
                symmetryList[i] = "" + (this.doNormalize ? finalOperations[i].getXyz() : finalOperations[i].getXyzOriginal());
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", symmetryList);
        }
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(atomIndex));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(count));
        this.setAtomSetAuxiliaryInfo("symmetryCount", new Integer(operationCount));
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.spaceGroup.getLatticeDesignation());
        if (minX != maxX || minY != maxY || minZ != maxZ) {
            this.setAtomSetAuxiliaryInfo("unitCellRange", new int[]{minX, minY, minZ, maxX, maxY, maxZ});
        }
        this.spaceGroup = null;
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setGlobalBoolean(1);
    }

    int symmetryAddAtoms(SymmetryOperation[] finalOperations, int atomIndex, int count, int transX, int transY, int transZ, int pt) {
        boolean isBaseCell = transX == 0 && transY == 0 && transZ == 0;
        int nOperations = finalOperations.length;
        if (isBaseCell) {
            pt = 0;
        }
        while (pt < count) {
            Atom atom = this.atoms[atomIndex + pt];
            this.cartesians[pt] = new Point3f(atom);
            finalOperations[0].transform(this.cartesians[pt]);
            this.unitCell.toCartesian(this.cartesians[pt]);
            atom.bsSymmetry.set(0);
            ++pt;
        }
        for (int iSym = 0; iSym < nOperations; ++iSym) {
            int pt0 = pt;
            if (isBaseCell && finalOperations[iSym].getXyz().equals("x,y,z")) continue;
            int i1 = atomIndex;
            int i2 = i1 + count;
            for (int i = i1; i < i2; ++i) {
                Atom atom = new Atom();
                finalOperations[iSym].newPoint(this.atoms[i], atom, transX, transY, transZ);
                Point3f cartesian = new Point3f(atom);
                this.unitCell.toCartesian(cartesian);
                Atom special = null;
                int j = pt0;
                while (--j >= 0) {
                    if (!((double)cartesian.distance(this.cartesians[j]) < 0.01)) continue;
                    special = this.atoms[atomIndex + j];
                    break;
                }
                if (special == null) {
                    Atom atom1 = this.newCloneAtom(this.atoms[i]);
                    atom1.x = atom.x;
                    atom1.y = atom.y;
                    atom1.z = atom.z;
                    atom1.atomSite = this.atoms[i].atomSite;
                    atom1.bsSymmetry = new BitSet();
                    atom1.bsSymmetry.set(iSym);
                    this.cartesians[pt++] = cartesian;
                    continue;
                }
                special.bsSymmetry.set(iSym);
            }
        }
        return pt;
    }

    void setCollectionName(String collectionName) {
        if (collectionName != null && (collectionName = collectionName.trim()).length() > 0) {
            this.collectionName = collectionName;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            String atomName = this.atoms[index].atomName;
            if (atomName != null) {
                this.atomSymbolicMap.put(atomName, new Integer(index));
            }
        }
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            int atomSerial = this.atoms[index].atomSerial;
            if (atomSerial != Integer.MIN_VALUE) {
                this.atomSymbolicMap.put(new Integer(atomSerial), new Integer(index));
            }
        }
    }

    void mapAtomName(String atomName, int atomIndex) {
        this.atomSymbolicMap.put(atomName, new Integer(atomIndex));
    }

    int getAtomNameIndex(String atomName) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(atomName);
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    int getAtomSerialNumberIndex(int serialNumber) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(new Integer(serialNumber));
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    void setAtomSetCollectionProperty(String key, String value) {
        this.atomSetCollectionProperties.put(key, value);
    }

    String getAtomSetCollectionProperty(String key) {
        return (String)this.atomSetCollectionProperties.get(key);
    }

    void setAtomSetCollectionAuxiliaryInfo(String key, Object value) {
        this.atomSetCollectionAuxiliaryInfo.put(key, value);
    }

    boolean setAtomSetCollectionPartialCharges(String auxKey) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(auxKey)) {
            return false;
        }
        Vector atomData = (Vector)this.atomSetCollectionAuxiliaryInfo.get(auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    void mapPartialCharge(String atomName, float charge) {
        this.atoms[this.getAtomNameIndex((String)atomName)].partialCharge = charge;
    }

    Object getAtomSetCollectionAuxiliaryInfo(String key) {
        return this.atomSetCollectionAuxiliaryInfo.get(key);
    }

    void newAtomSet() {
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
            this.atomSetNames = ArrayUtil.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetProperties = (Properties[])ArrayUtil.doubleLength(this.atomSetProperties);
            this.atomSetAuxiliaryInfo = (Hashtable[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        this.atomSymbolicMap.clear();
    }

    void setAtomSetName(String atomSetName) {
        this.atomSetNames[this.currentAtomSetIndex] = atomSetName;
    }

    void setAtomSetName(String atomSetName, int atomSetIndex) {
        this.atomSetNames[atomSetIndex] = atomSetName;
    }

    void setAtomSetNames(String atomSetName, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(atomSetName, idx);
            --idx;
        }
    }

    void setAtomSetNumber(int atomSetNumber) {
        this.atomSetNumbers[this.currentAtomSetIndex] = atomSetNumber;
    }

    void setAtomSetProperty(String key, String value) {
        this.setAtomSetProperty(key, value, this.currentAtomSetIndex);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value) {
        this.setAtomSetAuxiliaryInfo(key, value, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String auxKey) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(auxKey)) {
            return false;
        }
        Vector atomData = (Vector)this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].get(auxKey);
        int i = atomData.size();
        while (--i >= 0) {
            this.atoms[i].partialCharge = ((Float)atomData.get(i)).floatValue();
        }
        return true;
    }

    void setAtomSetProperty(String key, String value, int atomSetIndex) {
        if (this.atomSetProperties[atomSetIndex] == null) {
            this.atomSetProperties[atomSetIndex] = new Properties();
        }
        this.atomSetProperties[atomSetIndex].put(key, value);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value, int atomSetIndex) {
        if (this.atomSetAuxiliaryInfo[atomSetIndex] == null) {
            this.atomSetAuxiliaryInfo[atomSetIndex] = new Hashtable();
        }
        this.atomSetAuxiliaryInfo[atomSetIndex].put(key, value);
    }

    void setAtomSetProperties(String key, String value, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(key, value, idx);
            --idx;
        }
    }

    void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int index) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)this.atomSetProperties[index].clone();
    }

    int getAtomSetNumber(int atomSetIndex) {
        return this.atomSetNumbers[atomSetIndex];
    }

    String getAtomSetName(int atomSetIndex) {
        return this.atomSetNames[atomSetIndex];
    }

    Properties getAtomSetProperties(int atomSetIndex) {
        return this.atomSetProperties[atomSetIndex];
    }

    Hashtable getAtomSetAuxiliaryInfo(int atomSetIndex) {
        return this.atomSetAuxiliaryInfo[atomSetIndex];
    }

    boolean hasAlternateLocations() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getAltLocLists() {
        int i;
        if (!this.hasAlternateLocations()) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.atomCount; ++i) {
            char id = this.atoms[i].alternateLocationID;
            if (id == '\u0000' || lists[this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = this.atoms[i].atomSetIndex;
            lists[n] = lists[n] + id;
        }
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("altLocs", lists[i], i);
        }
    }

    boolean hasInsertions() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].insertionCode == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getInsertionLists() {
        int i;
        if (!this.hasInsertions()) {
            return;
        }
        String[] lists = new String[this.atomSetCount];
        for (i = 0; i < this.atomSetCount; ++i) {
            lists[i] = "";
        }
        for (i = 0; i < this.atomCount; ++i) {
            char id = this.atoms[i].insertionCode;
            if (id == '\u0000' || lists[this.atoms[i].atomSetIndex].indexOf(id) >= 0) continue;
            int n = this.atoms[i].atomSetIndex;
            lists[n] = lists[n] + id;
        }
        for (i = 0; i < this.atomSetCount; ++i) {
            if (lists[i].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("insertionCodes", lists[i], i);
        }
    }
}

