/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.CifReader;
import org.jmol.adapter.smarter.XmlReader;
import org.xml.sax.XMLReader;

public class XmlCmlReader
extends XmlReader {
    String[] cmlImplementedAttributes = new String[]{"id", "title", "x3", "y3", "z3", "x2", "y2", "elementType", "formalCharge", "atomId", "atomRefs2", "order", "atomRef1", "atomRef2", "dictRef", "spaceGroup"};
    int atomCount;
    Atom[] atomArray = new Atom[100];
    int bondCount;
    Bond[] bondArray = new Bond[100];
    int tokenCount;
    String[] tokens = new String[16];
    String desctitle = null;
    protected final int START = 0;
    protected final int CML = 1;
    protected final int CRYSTAL = 2;
    protected final int CRYSTAL_SCALAR = 3;
    protected final int CRYSTAL_SYMMETRY = 4;
    protected final int CRYSTAL_SYMMETRY_TRANSFORM3 = 5;
    protected final int MOLECULE = 6;
    protected final int MOLECULE_ATOM_ARRAY = 7;
    protected final int MOLECULE_ATOM = 8;
    protected final int MOLECULE_ATOM_SCALAR = 9;
    protected final int MOLECULE_BOND_ARRAY = 10;
    protected final int MOLECULE_BOND = 11;
    protected final int MOLECULE_FORMULA = 12;
    protected int state = 0;
    String scalarDictRef;
    String scalarDictKey;
    String scalarDictValue;
    String scalarTitle;
    int moleculeNesting = 0;
    boolean embeddedCrystal = false;

    XmlCmlReader() {
    }

    XmlCmlReader(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        new CmlHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    XmlCmlReader(XmlReader parent, AtomSetCollection atomSetCollection, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.cmlImplementedAttributes;
        new CmlHandler().walkDOMTree(DOMNode);
    }

    public void processStartElement(String uri, String name, String qName, HashMap atts) {
        switch (this.state) {
            case 0: {
                if (name.equals("molecule")) {
                    this.state = 6;
                    if (this.moleculeNesting == 0) {
                        this.createNewAtomSet(atts);
                    }
                    ++this.moleculeNesting;
                }
                if (!name.equals("crystal")) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (name.equals("scalar")) {
                    this.state = 3;
                    this.setKeepChars(true);
                    this.scalarTitle = (String)atts.get("title");
                    this.scalarDictRef = (String)atts.get("dictRef");
                    if (this.scalarDictRef != null) {
                        int iColon = this.scalarDictRef.indexOf(":");
                        this.scalarDictValue = this.scalarDictRef.substring(iColon + 1);
                        this.scalarDictKey = this.scalarDictRef.substring(0, iColon >= 0 ? iColon : 0);
                    }
                }
                if (!name.equals("symmetry")) break;
                this.state = 4;
                if (!atts.containsKey("spaceGroup")) break;
                String spaceGroup = (String)atts.get("spaceGroup");
                for (int i = 0; i < spaceGroup.length(); ++i) {
                    if (spaceGroup.charAt(i) != '_') continue;
                    spaceGroup = spaceGroup.substring(0, i) + spaceGroup.substring(i-- + 1);
                }
                this.parent.setSpaceGroupName(spaceGroup);
                break;
            }
            case 3: 
            case 4: {
                if (!name.equals("transform3")) break;
                this.state = 5;
                break;
            }
            case 5: 
            case 6: {
                if (name.equals("crystal")) {
                    this.state = 2;
                    this.embeddedCrystal = true;
                }
                if (name.equals("molecule")) {
                    this.state = 6;
                    ++this.moleculeNesting;
                }
                if (name.equals("bondArray")) {
                    int i;
                    this.state = 10;
                    this.bondCount = 0;
                    if (atts.containsKey("order")) {
                        this.breakOutBondTokens((String)atts.get("order"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.bondArray[i].order = this.parseBondToken(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("atomRef1")) {
                        this.breakOutBondTokens((String)atts.get("atomRef1"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.bondArray[i].atomIndex1 = this.atomSetCollection.getAtomNameIndex(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("atomRef2")) {
                        this.breakOutBondTokens((String)atts.get("atomRef2"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.bondArray[i].atomIndex2 = this.atomSetCollection.getAtomNameIndex(this.tokens[i]);
                        }
                    }
                }
                if (name.equals("atomArray")) {
                    int i;
                    this.state = 7;
                    this.atomCount = 0;
                    boolean coords3D = false;
                    if (atts.containsKey("atomID")) {
                        this.breakOutAtomTokens((String)atts.get("atomID"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].atomName = this.tokens[i];
                        }
                    }
                    if (atts.containsKey("x3")) {
                        coords3D = true;
                        this.breakOutAtomTokens((String)atts.get("x3"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].x = this.parseFloat(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("y3")) {
                        this.breakOutAtomTokens((String)atts.get("y3"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].y = this.parseFloat(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("z3")) {
                        this.breakOutAtomTokens((String)atts.get("z3"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].z = this.parseFloat(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("x2")) {
                        this.breakOutAtomTokens((String)atts.get("x2"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].x = this.parseFloat(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("y2")) {
                        this.breakOutAtomTokens((String)atts.get("y2"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].y = this.parseFloat(this.tokens[i]);
                        }
                    }
                    if (atts.containsKey("elementType")) {
                        this.breakOutAtomTokens((String)atts.get("elementType"));
                        i = this.tokenCount;
                        while (--i >= 0) {
                            this.atomArray[i].elementSymbol = this.tokens[i];
                        }
                    }
                    i = this.atomCount;
                    while (--i >= 0) {
                        Atom atom = this.atomArray[i];
                        if (!coords3D) {
                            atom.z = 0.0f;
                        }
                        this.parent.setAtomCoord(atom);
                    }
                }
                if (!name.equals("formula")) break;
                this.state = 12;
                break;
            }
            case 10: {
                if (!name.equals("bond")) break;
                this.state = 11;
                int order = -1;
                if (atts.containsKey("atomRefs2")) {
                    this.breakOutTokens((String)atts.get("atomRefs2"));
                }
                if (atts.containsKey("order")) {
                    order = this.parseBondToken((String)atts.get("order"));
                }
                if (this.tokenCount != 2 || order <= 0) break;
                this.atomSetCollection.addNewBond(this.tokens[0], this.tokens[1], order);
                break;
            }
            case 7: {
                if (!name.equals("atom")) break;
                this.state = 8;
                this.atom = new Atom();
                boolean coords3D = false;
                boolean coordsFractional = false;
                this.parent.setFractionalCoordinates(false);
                this.atom.atomName = atts.containsKey("label") ? (String)atts.get("label") : (String)atts.get("id");
                if (atts.containsKey("xFract") && this.parent.iHaveUnitCell) {
                    coordsFractional = true;
                    coords3D = true;
                    this.parent.setFractionalCoordinates(true);
                    this.atom.x = this.parseFloat((String)atts.get("xFract"));
                    this.atom.y = this.parseFloat((String)atts.get("yFract"));
                    this.atom.z = this.parseFloat((String)atts.get("zFract"));
                }
                if (atts.containsKey("x3") && !coordsFractional) {
                    coords3D = true;
                    this.atom.x = this.parseFloat((String)atts.get("x3"));
                    this.atom.y = this.parseFloat((String)atts.get("y3"));
                    this.atom.z = this.parseFloat((String)atts.get("z3"));
                }
                if (atts.containsKey("x2") && !coords3D) {
                    this.atom.x = this.parseFloat((String)atts.get("x2"));
                    this.atom.y = this.parseFloat((String)atts.get("y2"));
                    this.atom.z = 0.0f;
                }
                this.parent.setAtomCoord(this.atom);
                if (atts.containsKey("elementType")) {
                    this.atom.elementSymbol = (String)atts.get("elementType");
                }
                if (!atts.containsKey("formalCharge")) break;
                this.atom.formalCharge = this.parseInt((String)atts.get("formalCharge"));
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                if (!name.equals("scalar")) break;
                this.state = 9;
                this.setKeepChars(true);
                this.scalarTitle = (String)atts.get("title");
                this.scalarDictRef = (String)atts.get("dictRef");
                if (this.scalarDictRef == null) break;
                int iColon = this.scalarDictRef.indexOf(":");
                this.scalarDictValue = this.scalarDictRef.substring(iColon + 1);
                this.scalarDictKey = this.scalarDictRef.substring(0, iColon >= 0 ? iColon : 0);
                break;
            }
            case 9: {
                break;
            }
        }
    }

    public void processEndElement(String uri, String name, String qName) {
        switch (this.state) {
            case 2: {
                if (!name.equals("crystal")) break;
                if (this.embeddedCrystal) {
                    this.state = 6;
                    this.embeddedCrystal = false;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (name.equals("scalar")) {
                    int i;
                    this.state = 2;
                    if (this.scalarTitle != null) {
                        i = 6;
                        while (--i >= 0 && !this.scalarTitle.equals(AtomSetCollection.notionalUnitcellTags[i])) {
                        }
                        if (i >= 0) {
                            this.parent.setUnitCellItem(i, this.parseFloat(this.chars));
                        }
                    }
                    if (this.scalarDictRef != null) {
                        i = 6;
                        while (--i >= 0 && !this.scalarDictValue.equals(CifReader.cellParamNames[i])) {
                        }
                        if (i >= 0) {
                            this.parent.setUnitCellItem(i, this.parseFloat(this.chars));
                        }
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 4: {
                if (!name.equals("symmetry")) break;
                this.state = 2;
                break;
            }
            case 5: {
                if (!name.equals("transform3")) break;
                this.state = 4;
                break;
            }
            case 6: {
                if (!name.equals("molecule")) break;
                if (--this.moleculeNesting == 0) {
                    this.parent.applySymmetry();
                    this.state = 0;
                    break;
                }
                this.state = 6;
                break;
            }
            case 10: {
                if (!name.equals("bondArray")) break;
                this.state = 6;
                for (int i = 0; i < this.bondCount; ++i) {
                    this.atomSetCollection.addBond(this.bondArray[i]);
                }
                break;
            }
            case 7: {
                if (!name.equals("atomArray")) break;
                this.state = 6;
                for (int i = 0; i < this.atomCount; ++i) {
                    Atom atom = this.atomArray[i];
                    if (atom.elementSymbol == null || Float.isNaN(atom.z)) continue;
                    this.atomSetCollection.addAtomWithMappedName(atom);
                }
                break;
            }
            case 11: {
                if (!name.equals("bond")) break;
                this.state = 10;
                break;
            }
            case 8: {
                if (!name.equals("atom")) break;
                this.state = 7;
                if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                    this.atomSetCollection.addAtomWithMappedName(this.atom);
                }
                this.atom = null;
                break;
            }
            case 9: {
                if (name.equals("scalar")) {
                    this.state = 8;
                    if ("jmol:charge".equals(this.scalarDictRef)) {
                        this.atom.partialCharge = this.parseFloat(this.chars);
                    }
                }
                this.setKeepChars(false);
                this.scalarTitle = null;
                this.scalarDictRef = null;
                break;
            }
            case 12: {
                this.state = 6;
            }
        }
    }

    int parseBondToken(String str) {
        float floatOrder = this.parseFloat(str);
        if (Float.isNaN(floatOrder) && str.length() >= 1) {
            str = str.toUpperCase();
            switch (str.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 4;
                }
            }
            return this.parseInt(str);
        }
        if ((double)floatOrder == 1.5) {
            return 4;
        }
        if (floatOrder == 2.0f) {
            return 2;
        }
        if (floatOrder == 3.0f) {
            return 3;
        }
        return 1;
    }

    void breakOutTokens(String str) {
        StringTokenizer st = new StringTokenizer(str);
        this.tokenCount = st.countTokens();
        if (this.tokenCount > this.tokens.length) {
            this.tokens = new String[this.tokenCount];
        }
        for (int i = 0; i < this.tokenCount; ++i) {
            try {
                this.tokens[i] = st.nextToken();
                continue;
            }
            catch (NoSuchElementException nsee) {
                this.tokens[i] = null;
            }
        }
    }

    void breakOutAtomTokens(String str) {
        this.breakOutTokens(str);
        this.checkAtomArrayLength(this.tokenCount);
    }

    void checkAtomArrayLength(int newAtomCount) {
        if (this.atomCount == 0) {
            if (newAtomCount > this.atomArray.length) {
                this.atomArray = new Atom[newAtomCount];
            }
            int i = newAtomCount;
            while (--i >= 0) {
                this.atomArray[i] = new Atom();
            }
            this.atomCount = newAtomCount;
        } else if (newAtomCount != this.atomCount) {
            throw new IndexOutOfBoundsException("bad atom attribute length");
        }
    }

    void breakOutBondTokens(String str) {
        this.breakOutTokens(str);
        this.checkBondArrayLength(this.tokenCount);
    }

    void checkBondArrayLength(int newBondCount) {
        if (this.bondCount == 0) {
            if (newBondCount > this.bondArray.length) {
                this.bondArray = new Bond[newBondCount];
            }
            int i = newBondCount;
            while (--i >= 0) {
                this.bondArray[i] = new Bond();
            }
            this.bondCount = newBondCount;
        } else if (newBondCount != this.bondCount) {
            throw new IndexOutOfBoundsException("bad bond attribute length");
        }
    }

    private void createNewAtomSet(HashMap atts) {
        this.atomSetCollection.newAtomSet();
        String collectionName = null;
        if (atts.containsKey("title")) {
            collectionName = (String)atts.get("title");
        } else if (this.desctitle != null) {
            collectionName = this.desctitle;
        } else if (atts.containsKey("id")) {
            collectionName = (String)atts.get("id");
        }
        if (collectionName != null) {
            this.atomSetCollection.setAtomSetName(collectionName);
        }
    }

    class CmlHandler
    extends XmlReader.JmolXmlHandler {
        CmlHandler() {
            super(XmlCmlReader.this);
        }

        CmlHandler(XMLReader xmlReader) {
            super(XmlCmlReader.this);
            this.setHandler(xmlReader, this);
        }
    }
}

