/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

final class Line3D {
    Graphics3D g3d;
    BitSet lineBits;
    float slope;
    boolean lineTypeX;
    int lineDirection;
    int nBits;
    int nCached = 0;
    int nFound = 0;
    Hashtable lineCache = new Hashtable();
    Float slopeKey;
    static final int VISIBILITY_UNCLIPPED = 0;
    static final int VISIBILITY_CLIPPED = 1;
    static final int VISIBILITY_OFFSCREEN = 2;
    int x1t;
    int y1t;
    int z1t;
    int x2t;
    int y2t;
    int z2t;
    int cc1;
    int cc2;
    static final int zLT = 32;
    static final int zGT = 16;
    static final int xLT = 8;
    static final int xGT = 4;
    static final int yLT = 2;
    static final int yGT = 1;

    Line3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void setLineBits(float dx, float dy) {
        this.slope = dx != 0.0f ? dy / dx : (dy >= 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        this.lineTypeX = this.slope <= 1.0f && this.slope >= -1.0f;
        int n = this.lineDirection = this.slope < 0.0f ? -1 : 1;
        if (this.getCachedLine()) {
            return;
        }
        this.nBits = this.lineTypeX ? this.g3d.width : this.g3d.height;
        this.lineBits = new BitSet(this.nBits);
        if ((dy = Math.abs(dy)) > (dx = Math.abs(dx))) {
            float t = dx;
            dx = dy;
            dy = t;
        }
        int twoDError = 0;
        float twoDx = dx + dx;
        float twoDy = dy + dy;
        for (int i = 0; i < this.nBits; ++i) {
            if (!((float)(twoDError = (int)((float)twoDError + twoDy)) > dx)) continue;
            this.lineBits.set(i);
            twoDError = (int)((float)twoDError - twoDx);
        }
        this.lineCache.put(this.slopeKey, this.lineBits);
        ++this.nCached;
    }

    boolean getCachedLine() {
        this.slopeKey = new Float(this.slope);
        if (!this.lineCache.containsKey(this.slopeKey)) {
            return false;
        }
        this.lineBits = (BitSet)this.lineCache.get(this.slopeKey);
        ++this.nFound;
        if (this.nFound == 1000000) {
            System.out.println("nCached/nFound lines: " + this.nCached + " " + this.nFound);
        }
        return true;
    }

    void drawHLine(int argb, boolean tScreened, int x, int y, int z, int w) {
        int width = this.g3d.width;
        if (w < 0) {
            x += w;
            w = -w;
        }
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (x + w >= width) {
            w = width - 1 - x;
        }
        int offset = x + width * y;
        if (!tScreened) {
            for (int i = 0; i <= w; ++i) {
                if (z < zbuf[offset]) {
                    zbuf[offset] = z;
                    pbuf[offset] = argb;
                }
                ++offset;
            }
            return;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        for (int i = 0; i <= w; ++i) {
            if ((flipflop = !flipflop) && z < zbuf[offset]) {
                zbuf[offset] = z;
                pbuf[offset] = argb;
            }
            ++offset;
        }
    }

    void drawVLine(int argb, boolean tScreened, int x, int y, int z, int h) {
        int width = this.g3d.width;
        int height = this.g3d.height;
        if (h < 0) {
            y += h;
            h = -h;
        }
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (y + h >= height) {
            h = height - 1 - y;
        }
        int offset = x + width * y;
        if (!tScreened) {
            for (int i = 0; i <= h; ++i) {
                if (z < zbuf[offset]) {
                    zbuf[offset] = z;
                    pbuf[offset] = argb;
                }
                offset += width;
            }
            return;
        }
        boolean flipflop = ((x ^ y) & 1) != 0;
        for (int i = 0; i <= h; ++i) {
            if ((flipflop = !flipflop) && z < zbuf[offset]) {
                zbuf[offset] = z;
                pbuf[offset] = argb;
            }
            offset += width;
        }
    }

    int getTrimmedLine() {
        this.cc1 = this.clipCode(this.x1t, this.y1t, this.z1t);
        this.cc2 = this.clipCode(this.x2t, this.y2t, this.z2t);
        if ((this.cc1 | this.cc2) == 0) {
            return 0;
        }
        int xLast = this.g3d.xLast;
        int yLast = this.g3d.yLast;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        do {
            if ((this.cc1 & this.cc2) != 0) {
                return 2;
            }
            float dx = this.x2t - this.x1t;
            float dy = this.y2t - this.y1t;
            float dz = this.z2t - this.z1t;
            if (this.cc1 != 0) {
                if ((this.cc1 & 8) != 0) {
                    this.y1t = (int)((float)this.y1t + (float)(-this.x1t) * dy / dx);
                    this.z1t = (int)((float)this.z1t + (float)(-this.x1t) * dz / dx);
                    this.x1t = 0;
                } else if ((this.cc1 & 4) != 0) {
                    this.y1t = (int)((float)this.y1t + (float)(xLast - this.x1t) * dy / dx);
                    this.z1t = (int)((float)this.z1t + (float)(xLast - this.x1t) * dz / dx);
                    this.x1t = xLast;
                } else if ((this.cc1 & 2) != 0) {
                    this.x1t = (int)((float)this.x1t + (float)(-this.y1t) * dx / dy);
                    this.z1t = (int)((float)this.z1t + (float)(-this.y1t) * dz / dy);
                    this.y1t = 0;
                } else if ((this.cc1 & 1) != 0) {
                    this.x1t = (int)((float)this.x1t + (float)(yLast - this.y1t) * dx / dy);
                    this.z1t = (int)((float)this.z1t + (float)(yLast - this.y1t) * dz / dy);
                    this.y1t = yLast;
                } else if ((this.cc1 & 0x20) != 0) {
                    this.x1t = (int)((float)this.x1t + (float)(slab - this.z1t) * dx / dz);
                    this.y1t = (int)((float)this.y1t + (float)(slab - this.z1t) * dy / dz);
                    this.z1t = slab;
                } else {
                    this.x1t = (int)((float)this.x1t + (float)(depth - this.z1t) * dx / dz);
                    this.y1t = (int)((float)this.y1t + (float)(depth - this.z1t) * dy / dz);
                    this.z1t = depth;
                }
                this.cc1 = this.clipCode(this.x1t, this.y1t, this.z1t);
                continue;
            }
            if ((this.cc2 & 8) != 0) {
                this.y2t = (int)((float)this.y2t + (float)(-this.x2t) * dy / dx);
                this.z2t = (int)((float)this.z2t + (float)(-this.x2t) * dz / dx);
                this.x2t = 0;
            } else if ((this.cc2 & 4) != 0) {
                this.y2t = (int)((float)this.y2t + (float)(xLast - this.x2t) * dy / dx);
                this.z2t = (int)((float)this.z2t + (float)(xLast - this.x2t) * dz / dx);
                this.x2t = xLast;
            } else if ((this.cc2 & 2) != 0) {
                this.x2t = (int)((float)this.x2t + (float)(-this.y2t) * dx / dy);
                this.z2t = (int)((float)this.z2t + (float)(-this.y2t) * dz / dy);
                this.y2t = 0;
            } else if ((this.cc2 & 1) != 0) {
                this.x2t = (int)((float)this.x2t + (float)(yLast - this.y2t) * dx / dy);
                this.z2t = (int)((float)this.z2t + (float)(yLast - this.y2t) * dz / dy);
                this.y2t = yLast;
            } else if ((this.cc2 & 0x20) != 0) {
                this.x2t = (int)((float)this.x2t + (float)(slab - this.z2t) * dx / dz);
                this.y2t = (int)((float)this.y2t + (float)(slab - this.z2t) * dy / dz);
                this.z2t = slab;
            } else {
                this.x2t = (int)((float)this.x2t + (float)(depth - this.z2t) * dx / dz);
                this.y2t = (int)((float)this.y2t + (float)(depth - this.z2t) * dy / dz);
                this.z2t = depth;
            }
            this.cc2 = this.clipCode(this.x2t, this.y2t, this.z2t);
        } while ((this.cc1 | this.cc2) != 0);
        return 1;
    }

    final int clipCode(int x, int y, int z) {
        int code = 0;
        if (x < 0) {
            code |= 8;
        } else if (x >= this.g3d.width) {
            code |= 4;
        }
        if (y < 0) {
            code |= 2;
        } else if (y >= this.g3d.height) {
            code |= 1;
        }
        if (z < this.g3d.slab) {
            code |= 0x20;
        } else if (z > this.g3d.depth) {
            code |= 0x10;
        }
        return code;
    }

    void plotLine(int argbA, boolean tScreenedA, int argbB, boolean tScreenedB, int xA, int yA, int zA, int xB, int yB, int zB, boolean notClipped) {
        this.x1t = xA;
        this.x2t = xB;
        this.y1t = yA;
        this.y2t = yB;
        this.z1t = zA;
        this.z2t = zB;
        switch (notClipped ? 0 : this.getTrimmedLine()) {
            case 0: 
            case 1: {
                this.plotLineClipped(argbA, tScreenedA, argbB, tScreenedB, xA, yA, zA, xB - xA, yB - yA, zB - zA, notClipped, 0, 0);
            }
        }
    }

    void plotLineDelta(int argbA, boolean tScreenedA, int argbB, boolean tScreenedB, int xA, int yA, int zA, int dxBA, int dyBA, int dzBA, boolean notClipped) {
        this.x1t = xA;
        this.x2t = xA + dxBA;
        this.y1t = yA;
        this.y2t = yA + dyBA;
        this.z1t = zA;
        this.z2t = zA + dzBA;
        switch (notClipped ? 0 : this.getTrimmedLine()) {
            case 0: 
            case 1: {
                this.plotLineClipped(argbA, tScreenedA, argbB, tScreenedB, xA, yA, zA, dxBA, dyBA, dzBA, notClipped, 0, 0);
            }
        }
    }

    void plotLineDelta(int[] shades1, boolean tScreened1, int[] shades2, boolean tScreened2, int intensity, int xA, int yA, int zA, int dxBA, int dyBA, int dzBA, boolean notClipped) {
        this.x1t = xA;
        this.x2t = xA + dxBA;
        this.y1t = yA;
        this.y2t = yA + dyBA;
        this.z1t = zA;
        this.z2t = zA + dzBA;
        switch (notClipped ? 0 : this.getTrimmedLine()) {
            case 0: 
            case 1: {
                this.plotLineClipped(shades1, tScreened1, shades2, tScreened2, intensity, xA, yA, zA, dxBA, dyBA, dzBA, notClipped, 0, 0);
            }
        }
    }

    void plotLineDeltaBits(int[] shades1, boolean tScreened1, int[] shades2, boolean tScreened2, int intensity, int xA, int yA, int zA, int dxBA, int dyBA, int dzBA, boolean notClipped) {
        this.x1t = xA;
        this.x2t = xA + dxBA;
        this.y1t = yA;
        this.y2t = yA + dyBA;
        this.z1t = zA;
        this.z2t = zA + dzBA;
        switch (notClipped ? 0 : this.getTrimmedLine()) {
            case 0: 
            case 1: {
                this.plotLineClippedBits(shades1, tScreened1, shades2, tScreened2, intensity, xA, yA, zA, dxBA, dyBA, dzBA, notClipped, 0, 0);
            }
        }
    }

    void plotDashedLine(int argbA, boolean tScreenedA, int argbB, boolean tScreenedB, int run, int rise, int xA, int yA, int zA, int xB, int yB, int zB, boolean notClipped) {
        this.x1t = xA;
        this.x2t = xB;
        this.y1t = yA;
        this.y2t = yB;
        this.z1t = zA;
        this.z2t = zB;
        switch (notClipped ? 0 : this.getTrimmedLine()) {
            case 0: 
            case 1: {
                this.plotLineClipped(argbA, tScreenedA, argbB, tScreenedB, xA, yA, zA, xB - xA, yB - yA, zB - zA, notClipped, run, rise);
            }
        }
    }

    private void plotLineClipped(int argb1, boolean tScreened1, int argb2, boolean tScreened2, int x, int y, int z, int dx, int dy, int dz, boolean notClipped, int run, int rise) {
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        if (run == 0) {
            rise = Integer.MAX_VALUE;
            run = 1;
        }
        int offset = y * width + x;
        int offsetMax = pbuf.length;
        boolean flipflop = ((x ^ y) & 1) != 0;
        boolean tScreened = tScreened1;
        int argb = argb1;
        if ((!tScreened || (flipflop = !flipflop)) && notClipped && offset >= 0 && offset < offsetMax && z < zbuf[offset]) {
            zbuf[offset] = z;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        int x2 = x + dx;
        int y2 = y + dy;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z << 10;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n1 = Math.abs(x2 - this.x2t) + 1;
            int n2 = Math.abs(x2 - this.x1t) - 1;
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                    boolean bl = flipflop = !flipflop;
                }
                if ((!tScreened || (flipflop = !flipflop)) && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    zbuf[offset] = zCurrent;
                    pbuf[offset] = argb;
                }
                runIndex = (runIndex + 1) % run;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n1 = Math.abs(y2 - this.y2t) + 1;
            int n2 = Math.abs(y2 - this.y1t) - 1;
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid) {
                    tScreened = tScreened2;
                    argb = argb2;
                }
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                    boolean bl = flipflop = !flipflop;
                }
                if ((!tScreened || (flipflop = !flipflop)) && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    zbuf[offset] = zCurrent;
                    pbuf[offset] = argb;
                }
                runIndex = (runIndex + 1) % run;
            }
        }
    }

    private void plotLineClipped(int[] shades1, boolean tScreened1, int[] shades2, boolean tScreened2, int intensity, int x, int y, int z, int dx, int dy, int dz, boolean notClipped, int run, int rise) {
        boolean flipflop;
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        if (run == 0) {
            rise = Integer.MAX_VALUE;
            run = 1;
        }
        int offset = y * width + x;
        int offsetMax = pbuf.length;
        int intensityUp = intensity < 63 ? intensity + 1 : intensity;
        int intensityDn = intensity > 0 ? intensity - 1 : intensity;
        int argb1 = shades1[intensity];
        int argb1Up = shades1[intensityUp];
        int argb1Dn = shades1[intensityDn];
        int argb2 = shades2[intensity];
        int argb2Up = shades2[intensityUp];
        int argb2Dn = shades2[intensityDn];
        boolean tScreened = tScreened1;
        boolean bl = flipflop = ((x ^ y) & 1) != 0;
        if ((!tScreened || (flipflop = !flipflop)) && notClipped && offset >= 0 && offset < offsetMax && z < zbuf[offset]) {
            zbuf[offset] = z;
            pbuf[offset] = argb1;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int xIncrement = 1;
        int yOffsetIncrement = width;
        int x2 = x + dx;
        int y2 = y + dy;
        if (dx < 0) {
            dx = -dx;
            xIncrement = -1;
        }
        if (dy < 0) {
            dy = -dy;
            yOffsetIncrement = -width;
        }
        int twoDx = dx + dx;
        int twoDy = dy + dy;
        int zCurrentScaled = z << 10;
        int argb = argb1;
        int argbUp = argb1Up;
        int argbDn = argb1Dn;
        if (dy <= dx) {
            int roundingFactor = dx - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dx;
            int twoDxAccumulatedYError = 0;
            int n1 = Math.abs(x2 - this.x2t);
            int n2 = Math.abs(x2 - this.x1t);
            int n = dx - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    argbUp = argb2Up;
                    argbDn = argb2Dn;
                    tScreened = tScreened2;
                    if (tScreened && !tScreened1) {
                        int xT = offset % width;
                        int yT = offset / width;
                        flipflop = ((xT ^ yT) & 1) == 0;
                    }
                }
                offset += xIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDxAccumulatedYError += twoDy) > dx) {
                    offset += yOffsetIncrement;
                    twoDxAccumulatedYError -= twoDx;
                    boolean bl2 = flipflop = !flipflop;
                }
                if ((!tScreened || (flipflop = !flipflop)) && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    zbuf[offset] = zCurrent;
                    int rand8 = Shade3D.nextRandom8Bit();
                    pbuf[offset] = rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb);
                }
                runIndex = (runIndex + 1) % run;
            }
        } else {
            int roundingFactor = dy - 1;
            if (dz < 0) {
                roundingFactor = -roundingFactor;
            }
            int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
            int twoDyAccumulatedXError = 0;
            int n1 = Math.abs(y2 - this.y2t);
            int n2 = Math.abs(y2 - this.y1t);
            int n = dy - 1;
            int nMid = n / 2;
            while (--n >= n1) {
                int zCurrent;
                if (n == nMid) {
                    argb = argb2;
                    argbUp = argb2Up;
                    argbDn = argb2Dn;
                    tScreened = tScreened2;
                    if (tScreened && !tScreened1) {
                        int xT = offset % width;
                        int yT = offset / width;
                        flipflop = ((xT ^ yT) & 1) == 0;
                    }
                }
                offset += yOffsetIncrement;
                zCurrentScaled += zIncrementScaled;
                if ((twoDyAccumulatedXError += twoDx) > dy) {
                    offset += xIncrement;
                    twoDyAccumulatedXError -= twoDy;
                    boolean bl3 = flipflop = !flipflop;
                }
                if ((!tScreened || (flipflop = !flipflop)) && n < n2 && offset >= 0 && offset < offsetMax && runIndex < rise && (zCurrent = zCurrentScaled >> 10) < zbuf[offset]) {
                    zbuf[offset] = zCurrent;
                    int rand8 = Shade3D.nextRandom8Bit();
                    pbuf[offset] = rand8 < 85 ? argbDn : (rand8 > 170 ? argbUp : argb);
                }
                runIndex = (runIndex + 1) % run;
            }
        }
    }

    private void plotLineClippedBits(int[] shades1, boolean tScreened1, int[] shades2, boolean tScreened2, int intensity, int x, int y, int z, int dx, int dy, int dz, boolean notClipped, int run, int rise) {
        float zIncrement;
        int yIncrement;
        int xIncrement;
        int iIncrement;
        int iMid;
        int i2;
        int i1;
        int i0;
        int[] pbuf = this.g3d.pbuf;
        int[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int runIndex = 0;
        if (run == 0) {
            rise = Integer.MAX_VALUE;
            run = 1;
        }
        int intensityUp = intensity < 63 ? intensity + 1 : intensity;
        int intensityDn = intensity > 0 ? intensity - 1 : intensity;
        int argb1 = shades1[intensity];
        int argb1Up = shades1[intensityUp];
        int argb1Dn = shades1[intensityDn];
        int argb2 = shades2[intensity];
        int argb2Up = shades2[intensityUp];
        int argb2Dn = shades2[intensityDn];
        boolean tScreened = tScreened1;
        boolean flipflop = ((x ^ y) & 1) != 0;
        int offset = y * width + x;
        int offsetMax = pbuf.length;
        if (this.lineTypeX) {
            i0 = x;
            i1 = this.x1t;
            i2 = this.x2t;
            iMid = x + dx / 2;
            xIncrement = iIncrement = dx >= 0 ? 1 : -1;
            yIncrement = dy >= 0 ? width : -width;
            zIncrement = (float)dz / (float)Math.abs(dx);
        } else {
            i0 = y;
            i1 = this.y1t;
            i2 = this.y2t;
            iMid = y + dy / 2;
            iIncrement = dy >= 0 ? 1 : -1;
            xIncrement = dy >= 0 ? width : -width;
            yIncrement = dx >= 0 ? 1 : -1;
            zIncrement = (float)dz / (float)Math.abs(dy);
        }
        float zFloat = z;
        int argb = argb1;
        int argbUp = argb1Up;
        int argbDn = argb1Dn;
        boolean isInWindow = false;
        int i = i0;
        int iBits = i0;
        while (true) {
            if (i == i1) {
                isInWindow = true;
            }
            if (i == iMid) {
                argb = argb2;
                argbUp = argb2Up;
                argbDn = argb2Dn;
                tScreened = tScreened2;
                if (tScreened && !tScreened1) {
                    int xT = offset % width;
                    int yT = offset / width;
                    boolean bl = flipflop = ((xT ^ yT) & 1) == 0;
                }
            }
            if (isInWindow && (!tScreened || (flipflop = !flipflop)) && offset >= 0 && offset < offsetMax && runIndex < rise && zFloat < (float)zbuf[offset]) {
                zbuf[offset] = (int)zFloat;
                int rand8 = Shade3D.nextRandom8Bit();
                int n = rand8 < 85 ? argbDn : (pbuf[offset] = rand8 > 170 ? argbUp : argb);
            }
            if (i == i2) break;
            runIndex = (runIndex + 1) % run;
            offset += xIncrement;
            while (iBits < 0) {
                iBits += this.nBits;
            }
            if (this.lineBits.get(iBits % this.nBits)) {
                offset += yIncrement;
            }
            zFloat += zIncrement;
            i += iIncrement;
            iBits += iIncrement;
        }
    }
}

