/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopupAwt;
import org.jmol.popup.JmolPopupSwing;
import org.jmol.popup.PopupResourceBundle;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class JmolPopup {
    private static final boolean forceAwt = false;
    private static final boolean dumpList = false;
    JmolViewer viewer;
    Component jmolComponent;
    MenuItemListener mil;
    CheckboxMenuItemListener cmil;
    Hashtable htMenus = new Hashtable();
    Object frankPopup;
    int aboutComputedMenuBaseCount;
    String nullModelSetName;
    String hiddenModelSetName;
    Hashtable modelSetInfo;
    Hashtable modelInfo;
    Vector PDBOnly = new Vector();
    Vector UnitcellOnly = new Vector();
    Vector FramesOnly = new Vector();
    Vector VibrationOnly = new Vector();
    Vector SymmetryOnly = new Vector();
    Vector AppletOnly = new Vector();
    Vector ChargesOnly = new Vector();
    boolean isPDB;
    boolean isSymmetry;
    boolean isUnitCell;
    boolean isMultiFrame;
    boolean isMultiConfiguration;
    boolean isVibration;
    boolean isApplet;
    boolean haveCharges;
    boolean haveAltLocs;
    String altlocs;
    int modelIndex;
    int modelCount;
    static final int MAX_ITEMS = 25;
    static final int UPDATE_ALL = 0;
    static final int UPDATE_CONFIG = 1;
    static final int UPDATE_SHOW = 2;
    int updateMode;
    String group3List;
    int[] group3Counts;
    Object CONFIGURATIONComputedMenu;
    Object FRAMESbyModelComputedMenu;
    String configurationSelected = "";
    Hashtable colorMenus = new Hashtable();
    Hashtable htCheckbox = new Hashtable();
    String currentMenuItemId = null;
    int thisx;
    int thisy;
    Object[][] frankList = new Object[10][];
    int nFrankList = 0;
    String currentFrankId = null;

    JmolPopup(JmolViewer viewer) {
        this.viewer = viewer;
        this.jmolComponent = viewer.getAwtComponent();
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
    }

    public static JmolPopup newJmolPopup(JmolViewer viewer) {
        if (!viewer.isJvm12orGreater()) {
            return new JmolPopupAwt(viewer);
        }
        return new JmolPopupSwing(viewer);
    }

    void build(Object popupMenu) {
        this.addMenuItems("", "popupMenu", popupMenu, new PopupResourceBundle());
    }

    public void updateComputedMenus() {
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet());
        this.updateHeteroComputedMenu(this.viewer.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Hashtable)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateFRAMESbyModelComputedMenu();
        this.updateMode = 1;
        this.updateCONFIGURATIONComputedMenu();
        this.updateSYMMETRYComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
    }

    private void getViewerData() {
        this.isApplet = this.viewer.isApplet();
        this.modelIndex = this.viewer.getDisplayModelIndex();
        this.modelCount = this.viewer.getModelCount();
        this.modelSetInfo = this.viewer.getModelSetAuxiliaryInfo();
        this.modelInfo = this.viewer.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable();
        }
        this.isPDB = this.checkBoolean(this.modelSetInfo, "isPDB");
        this.isSymmetry = this.checkBoolean(this.modelSetInfo, "someModelsHaveSymmetry");
        this.isUnitCell = this.checkBoolean(this.modelSetInfo, "someModelsHaveUnitcells");
        this.isMultiFrame = this.modelCount > 1;
        this.altlocs = this.viewer.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.viewer.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.viewer.havePartialCharges();
    }

    private void updateForShow() {
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
    }

    boolean checkBoolean(Hashtable info, String key) {
        if (info == null || !info.containsKey(key)) {
            return false;
        }
        return (Boolean)info.get(key);
    }

    void updateSelectMenu() {
        Object menu = this.htMenus.get("selectMenu");
        if (menu == null) {
            return;
        }
        this.setLabel(menu, GT._("Select ({0})", this.viewer.getSelectionCount(), true));
    }

    void updateElementsComputedMenu(BitSet elementsPresentBitSet) {
        int i;
        Object menu = this.htMenus.get("elementsComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        if (elementsPresentBitSet == null) {
            return;
        }
        for (i = 0; i < JmolConstants.elementNumberMax; ++i) {
            if (!elementsPresentBitSet.get(i)) continue;
            String elementName = JmolConstants.elementNameFromNumber(i);
            String elementSymbol = JmolConstants.elementSymbolFromNumber(i);
            String entryName = elementSymbol + " - " + elementName;
            this.addMenuItem(menu, entryName, elementName, null);
        }
        for (i = 4; i < JmolConstants.altElementMax; ++i) {
            int n = JmolConstants.elementNumberMax + i;
            if (!elementsPresentBitSet.get(n)) continue;
            n = JmolConstants.altElementNumberFromIndex(i);
            String elementName = JmolConstants.elementNameFromNumber(n);
            String elementSymbol = JmolConstants.elementSymbolFromNumber(n);
            String entryName = elementSymbol + " - " + elementName;
            this.addMenuItem(menu, entryName, elementName, null);
        }
        this.enableMenu(menu, true);
    }

    void updateHeteroComputedMenu(Hashtable htHetero) {
        Object menu = this.htMenus.get("PDBheteroComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        if (htHetero == null) {
            return;
        }
        Enumeration e = htHetero.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            String heteroCode = (String)e.nextElement();
            String heteroName = (String)htHetero.get(heteroCode);
            if (heteroName.length() > 20) {
                heteroName = heteroName.substring(0, 20) + "...";
            }
            String entryName = heteroCode + " - " + heteroName;
            this.addMenuItem(menu, entryName, "[" + heteroCode + "]", null);
            ++n;
        }
        this.enableMenu(menu, n > 0);
    }

    void updateSurfMoComputedMenu(Hashtable moData) {
        int nOrb;
        Object menu = this.htMenus.get("surfMoComputedMenu");
        if (menu == null) {
            return;
        }
        this.enableMenu(menu, false);
        this.removeAll(menu);
        if (moData == null) {
            return;
        }
        Vector mos = (Vector)moData.get("mos");
        int n = nOrb = mos == null ? 0 : mos.size();
        if (nOrb == 0) {
            return;
        }
        this.enableMenu(menu, true);
        Object subMenu = menu;
        int nmod = nOrb % 25;
        if (nmod == 0) {
            nmod = 25;
        }
        int pt = nOrb > 25 ? 0 : Integer.MIN_VALUE;
        int i = nOrb;
        while (--i >= 0) {
            if (pt >= 0 && pt++ % nmod == 0) {
                if (pt == nmod + 1) {
                    nmod = 25;
                }
                String id = "mo" + pt + "Menu";
                subMenu = this.newMenu(Math.max(i + 2 - nmod, 1) + "..." + (i + 1), this.getId(menu) + "." + id);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String entryName = "#" + (i + 1) + " " + ((Hashtable)mos.get(i)).get("energy");
            String script = "mo " + (i + 1);
            this.addMenuItem(subMenu, entryName, script, null);
        }
    }

    void updatePDBComputedMenus() {
        Object menu = this.htMenus.get("PDBaaResiduesComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        Object menu1 = this.htMenus.get("PDBnucleicResiduesComputedMenu");
        this.removeAll(menu1);
        this.enableMenu(menu1, false);
        Object menu2 = this.htMenus.get("PDBcarboResiduesComputedMenu");
        this.removeAll(menu2);
        this.enableMenu(menu2, false);
        if (!this.isPDB) {
            return;
        }
        int n = this.modelIndex < 0 ? this.modelCount : this.modelIndex;
        String[] lists = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = lists == null ? null : lists[n];
        int[] nArray = this.group3Counts = lists == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int nItems = 0;
        for (int i = 1; i <= 23; ++i) {
            nItems += this.updateGroup3List(menu, JmolConstants.predefinedGroup3Names[i]);
        }
        this.enableMenu(menu, (nItems += this.augmentGroup3List(menu, "p>", true)) > 0);
        this.enableMenu(this.htMenus.get("PDBproteinMenu"), nItems > 0);
        nItems = this.augmentGroup3List(menu1, "n>", false);
        this.enableMenu(menu1, nItems > 0);
        this.enableMenu(this.htMenus.get("PDBnucleicMenu"), nItems > 0);
        nItems = this.augmentGroup3List(menu2, "c>", false);
        this.enableMenu(menu2, nItems > 0);
        this.enableMenu(this.htMenus.get("PDBcarboMenu"), nItems > 0);
    }

    int updateGroup3List(Object menu, String name) {
        int nItems = 0;
        int n = this.group3Counts[this.group3List.indexOf(name) / 6];
        if (n > 0) {
            name = name + "  (" + n + ")";
            ++nItems;
        }
        Object item = this.addMenuItem(menu, name, null, this.getId(menu) + "." + name);
        if (n == 0) {
            this.enableMenuItem(item, false);
        }
        return nItems;
    }

    int augmentGroup3List(Object menu, String type, boolean addSeparator) {
        int pt = 138;
        int nItems = 0;
        while ((pt = this.group3List.indexOf(type, pt)) >= 0) {
            if (nItems++ == 0 && addSeparator) {
                this.addMenuSeparator(menu);
            }
            int n = this.group3Counts[pt / 6];
            String name = this.group3List.substring(pt + 2, pt + 5) + "  (" + n + ")";
            this.addMenuItem(menu, name, null, this.getId(menu) + "." + name);
            ++pt;
        }
        return nItems;
    }

    void updateSYMMETRYComputedMenu() {
        Object menu = this.htMenus.get("SYMMETRYComputedMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.enableMenu(menu, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] list = (String[])this.modelInfo.get("symmetryOperations");
        if (list == null) {
            return;
        }
        boolean haveUnitCellRange = this.modelInfo.get("unitCellRange") != null;
        Object subMenu = menu;
        int nmod = 25;
        int pt = list.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < list.length; ++i) {
            if (pt >= 0 && pt++ % nmod == 0) {
                String id = "symop" + pt + "Menu";
                subMenu = this.newMenu(i + 1 + "..." + Math.min(i + 25, list.length), this.getId(menu) + "." + id);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String entryName = "symop=" + (i + 1) + " # " + list[i];
            this.enableMenuItem(this.addMenuItem(subMenu, entryName, "symop=" + (i + 1), null), haveUnitCellRange);
        }
        this.enableMenu(menu, true);
    }

    void updateFRAMESbyModelComputedMenu() {
        Object menu = this.FRAMESbyModelComputedMenu = this.htMenus.get("FRAMESbyModelComputedMenu");
        this.enableMenu(menu, this.modelCount > 1);
        this.setLabel(menu, this.modelIndex < 0 ? GT._("All {0} models", this.modelCount, true) : this.getModelLabel());
        this.removeAll(menu);
        if (this.modelCount < 2) {
            return;
        }
        this.addCheckboxMenuItem(menu, GT._("all", true), "frame 0 #", null, this.modelIndex < 0);
        Object subMenu = menu;
        int nmod = 25;
        int pt = this.modelCount > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            if (pt >= 0 && pt++ % nmod == 0) {
                String id = "model" + pt + "Menu";
                subMenu = this.newMenu(i + 1 + "..." + Math.min(i + 25, this.modelCount), this.getId(menu) + "." + id);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String script = "" + this.viewer.getModelNumber(i);
            String entryName = this.viewer.getModelName(i);
            if (!entryName.equals(script)) {
                entryName = script + ": " + entryName;
            }
            if (entryName.length() > 30) {
                entryName = entryName.substring(0, 20) + "...";
            }
            this.addCheckboxMenuItem(subMenu, entryName, "model " + script + " #", null, this.modelIndex == i);
        }
    }

    void updateCONFIGURATIONComputedMenu() {
        this.CONFIGURATIONComputedMenu = this.htMenus.get("CONFIGURATIONComputedMenu");
        this.enableMenu(this.CONFIGURATIONComputedMenu, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int nAltLocs = this.altlocs.length();
        this.setLabel(this.CONFIGURATIONComputedMenu, GT._("Configurations ({0})", nAltLocs, true));
        this.removeAll(this.CONFIGURATIONComputedMenu);
        String script = "hide none #CONFIG";
        this.addCheckboxMenuItem(this.CONFIGURATIONComputedMenu, GT._("all", true), script, null, this.updateMode == 1 && this.configurationSelected.equals(script));
        for (int i = 0; i < nAltLocs; ++i) {
            script = "configuration " + (i + 1) + "; hide not selected #CONFIG";
            String entryName = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.addCheckboxMenuItem(this.CONFIGURATIONComputedMenu, entryName, script, null, this.updateMode == 1 && this.configurationSelected.equals(script));
        }
    }

    void updateModelSetComputedMenu() {
        Object menu = this.htMenus.get("modelSetMenu");
        if (menu == null) {
            return;
        }
        this.removeAll(menu);
        this.renameMenu(menu, this.nullModelSetName);
        this.enableMenu(menu, false);
        String modelSetName = this.viewer.getModelSetName();
        if (modelSetName == null) {
            return;
        }
        if (modelSetName.length() > 25) {
            modelSetName = modelSetName.substring(0, 20) + "...";
        }
        this.renameMenu(menu, this.viewer.getBooleanProperty("hideNameInPopup") ? this.hiddenModelSetName : modelSetName);
        this.enableMenu(menu, true);
        this.updateFRAMESbyModelComputedMenu();
        this.addMenuSeparator(menu);
        this.addMenuItem(menu, GT._("atoms: {0}", this.viewer.getAtomCountInModel(this.modelIndex), true));
        this.addMenuItem(menu, GT._("bonds: {0}", this.viewer.getBondCountInModel(this.modelIndex), true));
        if (this.isPDB) {
            this.addMenuSeparator(menu);
            this.addMenuItem(menu, GT._("groups: {0}", this.viewer.getGroupCountInModel(this.modelIndex), true));
            this.addMenuItem(menu, GT._("chains: {0}", this.viewer.getChainCountInModel(this.modelIndex), true));
            this.addMenuItem(menu, GT._("polymers: {0}", this.viewer.getPolymerCountInModel(this.modelIndex), true));
        }
        if (this.isApplet && this.viewer.showModelSetDownload() && !this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.addMenuSeparator(menu);
            this.addMenuItem(menu, GT._("View {0}", this.viewer.getModelSetFileName(), true), "show url", null);
        }
    }

    void updateFileTypeDependentMenus() {
        int i;
        for (i = 0; i < this.PDBOnly.size(); ++i) {
            this.enableMenu(this.PDBOnly.get(i), this.isPDB);
        }
        for (i = 0; i < this.UnitcellOnly.size(); ++i) {
            this.enableMenu(this.UnitcellOnly.get(i), this.isUnitCell);
        }
        for (i = 0; i < this.FramesOnly.size(); ++i) {
            this.enableMenu(this.FramesOnly.get(i), this.isMultiFrame);
        }
        for (i = 0; i < this.VibrationOnly.size(); ++i) {
            this.enableMenu(this.VibrationOnly.get(i), this.isVibration);
        }
        for (i = 0; i < this.SymmetryOnly.size(); ++i) {
            this.enableMenu(this.SymmetryOnly.get(i), this.isSymmetry && this.isUnitCell);
        }
        for (i = 0; i < this.AppletOnly.size(); ++i) {
            this.enableMenu(this.AppletOnly.get(i), this.isApplet);
        }
        for (i = 0; i < this.ChargesOnly.size(); ++i) {
            this.enableMenu(this.ChargesOnly.get(i), this.haveCharges);
        }
    }

    String getModelLabel() {
        return GT._("model {0}", this.modelIndex + 1 + "/" + this.modelCount, true);
    }

    private void updateAboutSubmenu() {
        Object menu = this.htMenus.get("aboutComputedMenu");
        if (menu == null) {
            return;
        }
        int i = this.getMenuItemCount(menu);
        while (--i >= this.aboutComputedMenuBaseCount) {
            this.removeMenuItem(menu, i);
        }
        this.addMenuSeparator(menu);
        this.addMenuItem(menu, "Jmol 10.9.83");
        this.addMenuItem(menu, JmolConstants.date);
        this.addMenuItem(menu, this.viewer.getOperatingSystemName());
        this.addMenuItem(menu, this.viewer.getJavaVendor());
        this.addMenuItem(menu, this.viewer.getJavaVersion());
        this.addMenuSeparator(menu);
        this.addMenuItem(menu, GT._("Java memory usage", true));
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long mbTotal = this.convertToMegabytes(runtime.totalMemory());
        long mbFree = this.convertToMegabytes(runtime.freeMemory());
        long mbMax = this.convertToMegabytes(this.maxMemoryForNewerJvm());
        this.addMenuItem(menu, GT._("{0} MB total", new Object[]{new Long(mbTotal)}, true));
        this.addMenuItem(menu, GT._("{0} MB free", new Object[]{new Long(mbFree)}, true));
        if (mbMax > 0L) {
            this.addMenuItem(menu, GT._("{0} MB maximum", new Object[]{new Long(mbMax)}, true));
        } else {
            this.addMenuItem(menu, GT._("unknown maximum", true));
        }
        int availableProcessors = this.availableProcessorsForNewerJvm();
        if (availableProcessors > 0) {
            this.addMenuItem(menu, availableProcessors == 1 ? GT._("1 processor", true) : GT._("{0} processors", availableProcessors, true));
        } else {
            this.addMenuItem(menu, GT._("unknown processor count", true));
        }
    }

    private long convertToMegabytes(long num) {
        if (num <= 0x7FFFFFFFFFF7FFFFL) {
            num += 524288L;
        }
        return num / 0x100000L;
    }

    private void addMenuItems(String parentId, String key, Object menu, PopupResourceBundle popupResourceBundle) {
        String id = parentId + "." + key;
        String value = popupResourceBundle.getStructure(key);
        Logger.debug(id + " --- " + value);
        if (value == null) {
            this.addMenuItem(menu, "#" + key, "", "");
            return;
        }
        boolean isColorScheme = false;
        String colorSet = "";
        String colorCode = "";
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            Object newMenu = null;
            String script = "";
            String item = st.nextToken();
            if (item.equals("@")) {
                isColorScheme = true;
                continue;
            }
            if (isColorScheme) {
                colorCode = colorCode + item;
                if (colorSet.length() > 0) {
                    colorSet = colorSet + " -";
                }
                if (item.equals("INHERIT")) {
                    colorSet = colorSet + " none";
                } else if (item.equals("COLOR")) {
                    colorSet = colorSet + " black white red orange yellow green cyan blue indigo violet";
                } else if (item.equals("SCHEME")) {
                    colorSet = colorSet + " SchemeMenu";
                } else if (item.equals("TRANSLUCENCY")) {
                    colorSet = colorSet + " opaque translucent";
                } else if (item.equals("AXESCOLOR")) {
                    colorSet = colorSet + " gray salmon maroon olive slateblue gold orchid";
                }
                if (st.hasMoreTokens()) continue;
                popupResourceBundle.addStructure(key, colorSet);
                this.addMenuItems(parentId, key, menu, popupResourceBundle);
                return;
            }
            String word = popupResourceBundle.getWord(item);
            if (item.indexOf("Menu") >= 0) {
                Object subMenu = this.newMenu(word, id + "." + item);
                this.addMenuSubMenu(menu, subMenu);
                this.htMenus.put(item, subMenu);
                if (item.indexOf("Computed") < 0) {
                    this.addMenuItems(id, item, subMenu, popupResourceBundle);
                }
                if ("aboutComputedMenu".equals(item)) {
                    this.aboutComputedMenuBaseCount = this.getMenuItemCount(subMenu);
                } else if ("modelSetMenu".equals(item)) {
                    this.nullModelSetName = word;
                    this.hiddenModelSetName = popupResourceBundle.getWord("hiddenModelSetName");
                    this.enableMenu(subMenu, false);
                }
                newMenu = subMenu;
            } else if ("-".equals(item)) {
                this.addMenuSeparator(menu);
            } else if (item.endsWith("Checkbox")) {
                String basename = item.substring(0, item.length() - 8);
                newMenu = this.addCheckboxMenuItem(menu, word, basename, id + "." + item);
                script = "set " + basename + " [true|false]";
            } else {
                script = popupResourceBundle.getStructure(item);
                if (script == null) {
                    script = item;
                }
                newMenu = this.addMenuItem(menu, word, script, id + "." + item);
            }
            if (item.indexOf("PDB") >= 0) {
                this.PDBOnly.add(newMenu);
                continue;
            }
            if (item.indexOf("Url") >= 0) {
                this.AppletOnly.add(newMenu);
                continue;
            }
            if (item.indexOf("CHARGE") >= 0) {
                this.ChargesOnly.add(newMenu);
                continue;
            }
            if (item.indexOf("nitCell") >= 0) {
                this.UnitcellOnly.add(newMenu);
                continue;
            }
            if (item.indexOf("FRAMES") >= 0) {
                this.FramesOnly.add(newMenu);
                continue;
            }
            if (item.indexOf("VIBRATION") >= 0) {
                this.VibrationOnly.add(newMenu);
                continue;
            }
            if (item.indexOf("SYMMETRY") < 0) continue;
            this.SymmetryOnly.add(newMenu);
        }
    }

    void rememberCheckbox(String key, Object checkboxMenuItem) {
        this.htCheckbox.put(key, checkboxMenuItem);
    }

    void setCheckBoxValue(String what, boolean TF) {
        String basename = what;
        String extension = "";
        int pt = what.indexOf(";");
        if (pt >= 0) {
            basename = what.substring(0, pt);
            extension = what.substring(pt);
            for (int i = 0; i < extension.length(); ++i) {
                if (extension.charAt(i) != '_') continue;
                extension = extension.substring(0, i) + " " + extension.substring(i + 1);
            }
        }
        if (what.indexOf("#") > 0) {
            this.viewer.evalStringQuiet(what);
        } else if (this.viewer.getBooleanProperty(basename) != TF) {
            this.viewer.evalStringQuiet("set " + basename + (TF ? " TRUE" : " FALSE" + extension));
        }
        if (what.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = what;
            this.updateModelSetComputedMenu();
        }
    }

    String fixScript(String id, String script) {
        if (script == "" || id.endsWith("Checkbox")) {
            return script;
        }
        if (id.indexOf("Url") >= 0) {
            return "show url \"" + script + "\"";
        }
        if (id.indexOf(".setSpin") >= 0) {
            int pt = id.lastIndexOf(".setSpin");
            return pt < 0 ? script : "set spin " + id.substring(pt + 8, id.indexOf("Menu", pt)) + " " + script;
        }
        if (id.indexOf("._") >= 0) {
            int pt = id.lastIndexOf("._");
            return pt < 0 ? script : id.substring(pt + 2, id.indexOf("Menu", pt)) + " " + script;
        }
        if (id.indexOf(".set") >= 0) {
            int pt = id.lastIndexOf(".set");
            return pt < 0 ? script : "set " + id.substring(pt + 4, id.indexOf("Menu", pt)) + " " + script;
        }
        if (id.indexOf(".select") >= 0) {
            int pt = script.indexOf("  ");
            if (pt >= 0) {
                script = script.substring(0, pt);
            }
            return script.indexOf("set") == 0 ? script : "select " + script;
        }
        if (id.indexOf(".color") >= 0) {
            int pt = id.lastIndexOf(".color");
            return pt < 0 ? script : "color " + id.substring(pt + 6, id.indexOf("Menu", pt)) + " " + script;
        }
        return script;
    }

    Object addMenuItem(Object menuItem, String entry) {
        return this.addMenuItem(menuItem, entry, "", null);
    }

    Object addCheckboxMenuItem(Object menu, String entry, String basename, String id) {
        Object item = this.addCheckboxMenuItem(menu, entry, basename, id, false);
        this.rememberCheckbox(basename, item);
        return item;
    }

    public void show(int x, int y) {
        this.thisx = x;
        this.thisy = y;
        String id = this.currentMenuItemId;
        this.updateForShow();
        Enumeration keys = this.htCheckbox.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object item = this.htCheckbox.get(key);
            String basename = key.indexOf(";") >= 0 ? key.substring(0, key.indexOf(";")) : key;
            boolean b = this.viewer.getBooleanProperty(basename);
            this.setCheckBoxState(item, b);
        }
        if (x < 0) {
            this.setFrankMenu(id);
            this.thisx = -x - 50;
            if (this.nFrankList > 1) {
                this.thisy = y - this.nFrankList * this.getMenuItemHeight();
                this.showFrankMenu(this.thisx, this.thisy);
                return;
            }
        }
        this.restorePopupMenu();
        this.showPopupMenu(this.thisx, this.thisy);
    }

    void setFrankMenu(String id) {
        int iNew;
        if (this.currentFrankId != null && this.currentFrankId == id && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.createFrankPopup();
        }
        this.resetFrankMenu();
        if (id == null) {
            return;
        }
        this.currentFrankId = id;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        this.addMenuItem(this.frankPopup, GT._("Main Menu"), "MAIN", "");
        int i = id.indexOf(".", 2) + 1;
        while ((iNew = id.indexOf(".", i)) >= 0) {
            String strMenu = id.substring(i, iNew);
            Object menu = this.htMenus.get(strMenu);
            this.frankList[this.nFrankList++] = new Object[]{this.getParent(menu), menu, new Integer(this.getPosition(menu))};
            this.addMenuSubMenu(this.frankPopup, menu);
            i = iNew + 1;
        }
    }

    void restorePopupMenu() {
        if (this.nFrankList < 2) {
            return;
        }
        int i = this.nFrankList;
        while (--i > 0) {
            this.insertMenuSubMenu(this.frankList[i][0], this.frankList[i][1], (Integer)this.frankList[i][2]);
        }
        this.nFrankList = 1;
    }

    abstract void resetFrankMenu();

    abstract Object getParent(Object var1);

    abstract void insertMenuSubMenu(Object var1, Object var2, int var3);

    abstract int getPosition(Object var1);

    abstract void showPopupMenu(int var1, int var2);

    abstract void showFrankMenu(int var1, int var2);

    abstract void setCheckBoxState(Object var1, boolean var2);

    abstract void addMenuSeparator(Object var1);

    abstract Object addMenuItem(Object var1, String var2, String var3, String var4);

    abstract void setLabel(Object var1, String var2);

    abstract void updateMenuItem(Object var1, String var2, String var3);

    abstract Object addCheckboxMenuItem(Object var1, String var2, String var3, String var4, boolean var5);

    abstract void addMenuSubMenu(Object var1, Object var2);

    abstract Object newMenu(String var1, String var2);

    abstract void enableMenu(Object var1, boolean var2);

    abstract void enableMenuItem(Object var1, boolean var2);

    abstract void renameMenu(Object var1, String var2);

    abstract void removeAll(Object var1);

    abstract int getMenuItemCount(Object var1);

    abstract void removeMenuItem(Object var1, int var2);

    abstract String getId(Object var1);

    abstract void setCheckBoxValue(Object var1);

    abstract void createFrankPopup();

    abstract int getMenuItemHeight();

    long maxMemoryForNewerJvm() {
        return 0L;
    }

    int availableProcessorsForNewerJvm() {
        return 0;
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            JmolPopup.this.restorePopupMenu();
            JmolPopup.this.setCheckBoxValue(e.getSource());
            String id = JmolPopup.this.getId(e.getSource());
            if (id != null) {
                JmolPopup.this.currentMenuItemId = id;
            }
        }
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JmolPopup.this.restorePopupMenu();
            String script = e.getActionCommand();
            if (script == null || script.length() == 0) {
                return;
            }
            if (script.equals("MAIN")) {
                JmolPopup.this.show(JmolPopup.this.thisx, JmolPopup.this.thisy);
                return;
            }
            String id = JmolPopup.this.getId(e.getSource());
            if (id != null) {
                script = JmolPopup.this.fixScript(id, script);
                JmolPopup.this.currentMenuItemId = id;
            }
            JmolPopup.this.viewer.evalStringQuiet(script);
        }
    }
}

