/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;

public class SmilesMolecule {
    private SmilesAtom[] atoms = new SmilesAtom[16];
    private int atomsCount = 0;
    private SmilesBond[] bonds = new SmilesBond[16];
    private int bondsCount = 0;
    private static final int INITIAL_ATOMS = 16;
    private static final int INITIAL_BONDS = 16;

    public SmilesAtom createAtom() {
        SmilesAtom atom;
        if (this.atomsCount >= this.atoms.length) {
            SmilesAtom[] tmp = new SmilesAtom[this.atoms.length * 2];
            System.arraycopy(this.atoms, 0, tmp, 0, this.atoms.length);
            this.atoms = tmp;
        }
        this.atoms[this.atomsCount] = atom = new SmilesAtom(this.atomsCount);
        ++this.atomsCount;
        return atom;
    }

    public int getAtomsCount() {
        return this.atomsCount;
    }

    public SmilesAtom getAtom(int number) {
        if (number >= 0 && number < this.atomsCount) {
            return this.atoms[number];
        }
        return null;
    }

    public SmilesBond createBond(SmilesAtom atom1, SmilesAtom atom2, int bondType) {
        SmilesBond bond;
        if (this.bondsCount >= this.bonds.length) {
            SmilesBond[] tmp = new SmilesBond[this.bonds.length * 2];
            System.arraycopy(this.bonds, 0, tmp, 0, this.bonds.length);
            this.bonds = tmp;
        }
        this.bonds[this.bondsCount] = bond = new SmilesBond(atom1, atom2, bondType);
        ++this.bondsCount;
        if (atom1 != null) {
            atom1.addBond(bond);
        }
        if (atom2 != null) {
            atom2.addBond(bond);
        }
        return bond;
    }

    public int getBondsCount() {
        return this.bondsCount;
    }

    public SmilesBond getBond(int number) {
        if (number >= 0 && number < this.bondsCount) {
            return this.bonds[number];
        }
        return null;
    }
}

