/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.api.JmolAdapter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.JmolPanel;

public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active = null;
    JFileChooser chooser = null;
    private JmolPanel display = null;

    public FilePreview(JFileChooser fileChooser, JmolAdapter modelAdapter) {
        this.chooser = fileChooser;
        Box box = Box.createVerticalBox();
        this.active = new JCheckBox(GT._("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FilePreview.this.active.isSelected()) {
                    FilePreview.this.updatePreview(FilePreview.this.chooser.getSelectedFile());
                } else {
                    FilePreview.this.updatePreview(null);
                }
            }
        });
        box.add(this.active);
        this.display = new JmolPanel(modelAdapter);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        this.add(box);
        fileChooser.setAccessory(this);
        fileChooser.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(prop = evt.getPropertyName())) {
            this.updatePreview((File)evt.getNewValue());
        }
    }

    void updatePreview(File file) {
        if (file != null) {
            this.display.getViewer().evalStringQuiet("load \"" + file.getAbsolutePath() + "\"");
            this.display.repaint();
        } else {
            this.display.getViewer().evalStringQuiet("zap");
        }
    }
}

