/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import Acme.JPM.Encoders.PpmEncoder;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Base64;
import org.jmol.util.JpegEncoder;
import org.openscience.jmol.app.ImageSelection;
import org.openscience.jmol.app.PngEncoder;
import org.openscience.jmol.app.StatusBar;

class ImageCreator {
    JmolViewer viewer;
    StatusBar status;

    ImageCreator(JmolViewer viewer, StatusBar status) {
        this.viewer = viewer;
        this.status = status;
    }

    void clipImage() {
        Image eImage = this.viewer.getScreenImage();
        ImageSelection.setClipboard(eImage);
        this.viewer.releaseScreenImage();
    }

    void createImage(String fileName, String type, int quality) {
        block12: {
            try {
                if (type.equalsIgnoreCase("CLIP")) {
                    this.clipImage();
                } else {
                    Image eImage = this.viewer.getScreenImage();
                    FileOutputStream os = new FileOutputStream(fileName);
                    if (type.equalsIgnoreCase("JPEG") || type.equalsIgnoreCase("JPG")) {
                        JpegEncoder jc = new JpegEncoder(eImage, quality, os);
                        jc.Compress();
                    } else if (type.equalsIgnoreCase("PPM")) {
                        PpmEncoder pc = new PpmEncoder(eImage, (OutputStream)os);
                        pc.encode();
                    } else if (type.equalsIgnoreCase("PNG")) {
                        PngEncoder png = new PngEncoder(eImage);
                        byte[] pngbytes = png.pngEncode();
                        os.write(pngbytes);
                    } else if (type.equalsIgnoreCase("JPG64")) {
                        ByteArrayOutputStream osb = new ByteArrayOutputStream();
                        JpegEncoder jc = new JpegEncoder(eImage, quality, osb);
                        jc.Compress();
                        osb.flush();
                        osb.close();
                        StringBuffer jpg = Base64.getBase64(osb.toByteArray());
                        os.write(Base64.toBytes(jpg));
                    }
                    os.flush();
                    os.close();
                    this.viewer.releaseScreenImage();
                }
            }
            catch (IOException exc) {
                this.viewer.releaseScreenImage();
                if (exc == null) break block12;
                if (this.status != null) {
                    this.status.setStatus(1, GT._("IO Exception:"));
                    this.status.setStatus(2, exc.toString());
                }
                System.out.println(exc.toString());
            }
        }
    }
}

