package com.ozten.font;

import junit.framework.*;

import java.awt.Font;
import javax.swing.*;

public class JFontChooserTest extends TestCase {
  private JFontChooser jfcDefault, jfcFont;


  public JFontChooserTest(String name){
    super(name);
  }

  public static void main(String[] args){
    junit.textui.TestRunner.run(suite());
  }

  public static Test suite(){
    return new TestSuite(JFontChooserTest.class);
  }

  protected void setUp(){
    jfcDefault = new JFontChooser();
    jfcFont    = new JFontChooser(JFontChooser.getAvailableFont());
  }

  public void testDefaultConstructor(){
    JFrame jf = new JFrame("DefaultConstructor");
    jf.getContentPane().add(jfcDefault);
    jf.setSize(jfcDefault.getPreferredSize());
    jf.setVisible(true);
    try{
      Thread.sleep(1000 * 5);
    } catch (Exception e){
      e.printStackTrace();
    }
    jf.dispose();
    jf.setVisible(false);
    assertNotNull(jfcDefault.getPreviewText().getFont());
  }

  public void testAvailableFont(){
    assertNotNull(JFontChooser.getAvailableFont());
  }

  public void testFontConstructor(){
    JFrame jf = new JFrame("FontConstructor");
    jf.getContentPane().add(jfcFont);
    jf.setSize(jfcDefault.getPreferredSize());
    jf.setVisible(true);
    try{
      Thread.sleep(1000 * 5);
    } catch (Exception e){
      e.printStackTrace();
    }
    jf.dispose();
    jf.setVisible(false);
    assertNotNull(jfcDefault.getPreviewText().getFont());
  }

}