/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Ring;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.ConjugatedPiSystemsDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.RDFProtonDescriptor_GSRTest")
public class RDFProtonDescriptor_GSR
implements IAtomicDescriptor {
    private boolean checkAromaticity = false;
    private IAtomContainer acold = null;
    private IRingSet varRingSet = null;
    private IAtomContainerSet varAtomContainerSet = null;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RDFProtonDescriptor_GSR.class);
    private final int gsr_desc_length = 7;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#rdfProtonCalculatedValues", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("RDFProtonDescriptor only expects one parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        String[] descriptorNames = new String[7];
        for (int i = 0; i < 7; ++i) {
            descriptorNames[i] = "gSr_" + (i + 1);
        }
        return descriptorNames;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult result = new DoubleArrayResult(7);
        for (int i = 0; i < 7; ++i) {
            result.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer varAtomContainerSet) {
        return this.calculate(atom, varAtomContainerSet, null);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer, IRingSet precalculatedringset) {
        IAtomContainer varAtomContainer;
        try {
            varAtomContainer = (IAtomContainer)atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        int atomPosition = atomContainer.getAtomNumber(atom);
        IAtom clonedAtom = varAtomContainer.getAtom(atomPosition);
        DoubleArrayResult rdfProtonCalculatedValues = new DoubleArrayResult(7);
        if (!atom.getSymbol().equals("H")) {
            return this.getDummyDescriptorValue(new CDKException("Invalid atom specified"));
        }
        Molecule mol = new Molecule(varAtomContainer);
        if (varAtomContainer != this.acold) {
            this.acold = varAtomContainer;
            this.varAtomContainerSet = ConjugatedPiSystemsDetector.detect(mol);
            if (precalculatedringset == null) {
                try {
                    this.varRingSet = new AllRingsFinder().findAllRings(varAtomContainer);
                }
                catch (CDKException e) {
                    return this.getDummyDescriptorValue(e);
                }
            } else {
                this.varRingSet = precalculatedringset;
            }
            try {
                GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
                peoe.assignGasteigerMarsiliSigmaPartialCharges(mol, true);
            }
            catch (Exception ex1) {
                return this.getDummyDescriptorValue(ex1);
            }
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(varAtomContainer);
                CDKHueckelAromaticityDetector.detectAromaticity(varAtomContainer);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        for (IBond bond : varAtomContainer.bonds()) {
            IRingSet ringsWithThisBond = this.varRingSet.getRings(bond);
            if (ringsWithThisBond.getAtomContainerCount() <= 0) continue;
            bond.setFlag(1, true);
        }
        for (int w = 0; w < varAtomContainer.getAtomCount(); ++w) {
            IRingSet ringsWithThisAtom = this.varRingSet.getRings(varAtomContainer.getAtom(w));
            if (ringsWithThisAtom.getAtomContainerCount() <= 0) continue;
            varAtomContainer.getAtom(w).setFlag(1, true);
        }
        IAtomContainer detected = this.varAtomContainerSet.getAtomContainer(0);
        List<IAtom> neighboors = mol.getConnectedAtomsList(clonedAtom);
        IAtom neighbour0 = neighboors.get(0);
        List<IAtom> atomsInSecondSphere = mol.getConnectedAtomsList(neighbour0);
        ArrayList<Integer> singles = new ArrayList<Integer>();
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        ArrayList<Integer> atoms = new ArrayList<Integer>();
        ArrayList<Integer> bondsInCycloex = new ArrayList<Integer>();
        for (IAtom curAtomSecond : atomsInSecondSphere) {
            IBond secondBond = mol.getBond(neighbour0, curAtomSecond);
            if (mol.getAtomNumber(curAtomSecond) == atomPosition || !this.getIfBondIsNotRotatable(mol, secondBond, detected)) continue;
            int sphere = 2;
            IBond.Order bondOrder = secondBond.getOrder();
            int bondNumber = mol.getBondNumber(secondBond);
            boolean theBondIsInA6MemberedRing = false;
            this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomSecond), atoms, sphere, theBondIsInA6MemberedRing);
            List<IAtom> atomsInThirdSphere = mol.getConnectedAtomsList(curAtomSecond);
            if (atomsInThirdSphere.size() <= 0) continue;
            for (IAtom curAtomThird : atomsInThirdSphere) {
                IBond thirdBond = mol.getBond(curAtomThird, curAtomSecond);
                if (mol.getAtomNumber(curAtomThird) == atomPosition || !this.getIfBondIsNotRotatable(mol, thirdBond, detected)) continue;
                sphere = 3;
                bondOrder = thirdBond.getOrder();
                bondNumber = mol.getBondNumber(thirdBond);
                theBondIsInA6MemberedRing = false;
                if (!thirdBond.getFlag(5) && !curAtomThird.equals(neighbour0)) {
                    IRingSet rsAtom = this.varRingSet.getRings(thirdBond);
                    for (int f = 0; f < rsAtom.getAtomContainerCount(); ++f) {
                        Ring ring = (Ring)rsAtom.getAtomContainer(f);
                        if (ring.getRingSize() <= 4 || !ring.contains(thirdBond)) continue;
                        theBondIsInA6MemberedRing = true;
                    }
                }
                this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomThird), atoms, sphere, theBondIsInA6MemberedRing);
                theBondIsInA6MemberedRing = false;
                List<IAtom> atomsInFourthSphere = mol.getConnectedAtomsList(curAtomThird);
                if (atomsInFourthSphere.size() <= 0) continue;
                for (IAtom curAtomFourth : atomsInFourthSphere) {
                    IBond fourthBond = mol.getBond(curAtomThird, curAtomFourth);
                    if (mol.getAtomNumber(curAtomFourth) == atomPosition || !this.getIfBondIsNotRotatable(mol, fourthBond, detected)) continue;
                    sphere = 4;
                    bondOrder = fourthBond.getOrder();
                    bondNumber = mol.getBondNumber(fourthBond);
                    theBondIsInA6MemberedRing = false;
                    this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomFourth), atoms, sphere, theBondIsInA6MemberedRing);
                    List<IAtom> atomsInFifthSphere = mol.getConnectedAtomsList(curAtomFourth);
                    if (atomsInFifthSphere.size() <= 0) continue;
                    for (IAtom curAtomFifth : atomsInFifthSphere) {
                        IBond fifthBond = mol.getBond(curAtomFifth, curAtomFourth);
                        if (mol.getAtomNumber(curAtomFifth) == atomPosition || !this.getIfBondIsNotRotatable(mol, fifthBond, detected)) continue;
                        sphere = 5;
                        bondOrder = fifthBond.getOrder();
                        bondNumber = mol.getBondNumber(fifthBond);
                        theBondIsInA6MemberedRing = false;
                        this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomFifth), atoms, sphere, theBondIsInA6MemberedRing);
                        List<IAtom> atomsInSixthSphere = mol.getConnectedAtomsList(curAtomFifth);
                        if (atomsInSixthSphere.size() <= 0) continue;
                        for (IAtom curAtomSixth : atomsInSixthSphere) {
                            IBond sixthBond = mol.getBond(curAtomFifth, curAtomSixth);
                            if (mol.getAtomNumber(curAtomSixth) == atomPosition || !this.getIfBondIsNotRotatable(mol, sixthBond, detected)) continue;
                            sphere = 6;
                            bondOrder = sixthBond.getOrder();
                            bondNumber = mol.getBondNumber(sixthBond);
                            theBondIsInA6MemberedRing = false;
                            this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomSixth), atoms, sphere, theBondIsInA6MemberedRing);
                            List<IAtom> atomsInSeventhSphere = mol.getConnectedAtomsList(curAtomSixth);
                            if (atomsInSeventhSphere.size() <= 0) continue;
                            for (IAtom curAtomSeventh : atomsInSeventhSphere) {
                                IBond seventhBond = mol.getBond(curAtomSeventh, curAtomSixth);
                                if (mol.getAtomNumber(curAtomSeventh) == atomPosition || !this.getIfBondIsNotRotatable(mol, seventhBond, detected)) continue;
                                sphere = 7;
                                bondOrder = seventhBond.getOrder();
                                bondNumber = mol.getBondNumber(seventhBond);
                                theBondIsInA6MemberedRing = false;
                                this.checkAndStore(bondNumber, bondOrder, singles, doubles, bondsInCycloex, mol.getAtomNumber(curAtomSeventh), atoms, sphere, theBondIsInA6MemberedRing);
                            }
                        }
                    }
                }
            }
        }
        double smooth = -20.0;
        Vector3d a_a = new Vector3d();
        Vector3d a_b = new Vector3d();
        Vector3d b_a = new Vector3d();
        Vector3d b_b = new Vector3d();
        Point3d middlePoint = new Point3d();
        double angle = 0.0;
        if (singles.size() > 0) {
            double distance = 0.0;
            int position = 0;
            IBond theSingleBond = null;
            double limitInf = 0.0;
            double limitSup = 1.5707963267948966;
            double step = (limitSup - limitInf) / 7.0;
            smooth = -1.15;
            int counter = 0;
            for (double ghs = 0.0; ghs < limitSup; ghs += step) {
                double sum = 0.0;
                for (int sing = 0; sing < singles.size(); ++sing) {
                    angle = 0.0;
                    double partial = 0.0;
                    Integer thisSingleBond = singles.get(sing);
                    position = thisSingleBond;
                    theSingleBond = mol.getBond(position);
                    middlePoint = theSingleBond.get3DCenter();
                    IAtom singleBondAtom0 = theSingleBond.getAtom(0);
                    IAtom singleBondAtom1 = theSingleBond.getAtom(1);
                    double dist0 = this.calculateDistanceBetweenTwoAtoms(singleBondAtom0, atom);
                    double dist1 = this.calculateDistanceBetweenTwoAtoms(singleBondAtom1, atom);
                    a_a.set(middlePoint.x, middlePoint.y, middlePoint.z);
                    if (dist1 > dist0) {
                        a_b.set(singleBondAtom0.getPoint3d().x, singleBondAtom0.getPoint3d().y, singleBondAtom0.getPoint3d().z);
                    } else {
                        a_b.set(singleBondAtom1.getPoint3d().x, singleBondAtom1.getPoint3d().y, singleBondAtom1.getPoint3d().z);
                    }
                    b_a.set(middlePoint.x, middlePoint.y, middlePoint.z);
                    b_b.set(atom.getPoint3d().x, atom.getPoint3d().y, atom.getPoint3d().z);
                    double[] values = this.calculateDistanceBetweenAtomAndBond(atom, theSingleBond);
                    angle = this.calculateAngleBetweenTwoLines(a_a, a_b, b_a, b_b);
                    partial = 1.0 / Math.pow(values[0], 2.0) * Math.exp(smooth * Math.pow(ghs - angle, 2.0));
                    sum += partial;
                }
                rdfProtonCalculatedValues.add(sum);
                logger.debug("RDF gSr prob.: " + sum + " at distance " + ghs);
                ++counter;
            }
        } else {
            return this.getDummyDescriptorValue(new CDKException("Some error occurred. Please report"));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), rdfProtonCalculatedValues, this.getDescriptorNames());
    }

    private boolean getIfBondIsNotRotatable(Molecule mol, IBond bond, IAtomContainer detected) {
        boolean isBondNotRotatable = false;
        int counter = 0;
        IAtom atom0 = bond.getAtom(0);
        IAtom atom1 = bond.getAtom(1);
        if (detected != null && detected.contains(bond)) {
            ++counter;
        }
        if (atom0.getFlag(1)) {
            counter = atom1.getFlag(1) ? ++counter : (atom1.getSymbol().equals("H") ? ++counter : (counter += 0));
        }
        if (atom0.getSymbol().equals("N") && atom1.getSymbol().equals("C") && this.getIfACarbonIsDoubleBondedToAnOxygen(mol, atom1)) {
            ++counter;
        }
        if (atom0.getSymbol().equals("C") && atom1.getSymbol().equals("N") && this.getIfACarbonIsDoubleBondedToAnOxygen(mol, atom0)) {
            ++counter;
        }
        if (counter > 0) {
            isBondNotRotatable = true;
        }
        return isBondNotRotatable;
    }

    private boolean getIfACarbonIsDoubleBondedToAnOxygen(Molecule mol, IAtom carbonAtom) {
        boolean isDoubleBondedToOxygen = false;
        List<IAtom> neighToCarbon = mol.getConnectedAtomsList(carbonAtom);
        int counter = 0;
        for (int nei = 0; nei < neighToCarbon.size(); ++nei) {
            IBond tmpBond;
            IAtom neighbour = neighToCarbon.get(nei);
            if (!neighbour.getSymbol().equals("O") || (tmpBond = mol.getBond(neighbour, carbonAtom)).getOrder() != IBond.Order.DOUBLE) continue;
            ++counter;
        }
        if (counter > 0) {
            isDoubleBondedToOxygen = true;
        }
        return isDoubleBondedToOxygen;
    }

    private double calculateAngleBetweenTwoLines(Vector3d a, Vector3d b, Vector3d c, Vector3d d) {
        Vector3d firstLine = new Vector3d();
        firstLine.sub(a, b);
        Vector3d secondLine = new Vector3d();
        secondLine.sub(c, d);
        Vector3d firstVec = new Vector3d(firstLine);
        Vector3d secondVec = new Vector3d(secondLine);
        return firstVec.angle(secondVec);
    }

    private void checkAndStore(int bondToStore, IBond.Order bondOrder, ArrayList<Integer> singleVec, ArrayList<Integer> doubleVec, ArrayList<Integer> cycloexVec, int a1, ArrayList<Integer> atomVec, int sphere, boolean isBondInCycloex) {
        if (!atomVec.contains(a1) && sphere < 6) {
            atomVec.add(a1);
        }
        if (!cycloexVec.contains(bondToStore) && isBondInCycloex) {
            cycloexVec.add(bondToStore);
        }
        if (bondOrder == IBond.Order.DOUBLE && !doubleVec.contains(bondToStore)) {
            doubleVec.add(bondToStore);
        }
        if (bondOrder == IBond.Order.SINGLE && !singleVec.contains(bondToStore)) {
            singleVec.add(bondToStore);
        }
    }

    private double calculateDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        double distance = firstPoint.distance(secondPoint);
        return distance;
    }

    private int getNearestBondtoAGivenAtom(Molecule mol, IAtom atom, IBond bond) {
        int nearestBond = 0;
        double distance = 0.0;
        IAtom atom0 = bond.getAtom(0);
        List<IBond> bondsAtLeft = mol.getConnectedBondsList(atom0);
        for (int i = 0; i < bondsAtLeft.size(); ++i) {
            IBond curBond = bondsAtLeft.get(i);
            double[] values = this.calculateDistanceBetweenAtomAndBond(atom, curBond);
            int partial = mol.getBondNumber(curBond);
            if (i == 0) {
                nearestBond = mol.getBondNumber(curBond);
                distance = values[0];
                continue;
            }
            if (!(values[0] < distance)) continue;
            nearestBond = partial;
        }
        return nearestBond;
    }

    private double[] calculateDistanceBetweenAtomAndBond(IAtom proton, IBond theBond) {
        Point3d middlePoint = theBond.get3DCenter();
        Point3d protonPoint = proton.getPoint3d();
        double[] values = new double[]{middlePoint.distance(protonPoint), middlePoint.x, middlePoint.y, middlePoint.z};
        return values;
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if (name.equals("checkAromaticity")) {
            return Boolean.TRUE;
        }
        return null;
    }
}

