
package org.omegahat.Interfaces.NativeInterface;

import org.omegahat.Environment.Parser.Parse.List;
import org.omegahat.Environment.Parser.Parse.ConstructorExpression;


/**
    An abstract class that implements the basic functionality for
    converting a foreign reference (i.e. an object exported from R or S)
    to an appropriate Java object.
    This contains information identifying the R/S object and the target
    Java class. If the class does not exist (or is not likely to) the
    object can be initialized with the names of classes and interfaces
    which a dynamically generated class should extend and implement, respectively 
    The foreign reference is then converted to an instance of this class
    so that it can be used appropriately. This new instance implements its methods 
    via calls back to the foreign system and methods for the specified remote object.

    This is used as a transfer agent between the foreign system and Omegahat/Java.
    The foreign system creates an object of this class via C routines and then passes
    this object to the Omegahat system as an argument in a method call.
  */
public class MetaForeignReference
                implements  org.omegahat.Environment.Language.Evaluable
{
protected String name;

/**
   Name of the class which we will use as the class
   of the Java object used to represent the remote reference.
   This is either implicitly determined if a new class is generated
   or explicitly provided by the foreign caller when the user wants
   to control the 
  */
protected String targetClass;

public MetaForeignReference(String id) {
 setName(id);  
}

/**
  Assumes the class identified by 
  <code>targetType</code> already exists,
  or can be generated by extending a known
  base class. This is an unusual circumstance.
*/
public MetaForeignReference(String id, String targetType) {
 this(id);
 setTargetClass(targetType);
}

/**
 Eagerly generate a new class named <code>targetType</code> that implements the methods of the specified interfaces
 in <code>baseTypes</code>.
   @param id identifier of the object in the foreign system.
   @param targetType name of the new Java class to generate based on the base interfaces
         specified in <code>baseTypes</code>.
   @param baseTypes names of interfaces and classes which a dynamically generated
              class should implement. 
   @evaluator the context in which to dynamically create the new class (i.e. its dynamic class loader) and resolve
           class names.
 */
public MetaForeignReference(String id, String targetType, String[] baseTypes, org.omegahat.Environment.Interpreter.Evaluator evaluator) 
    throws ClassNotFoundException
{
 this(id, targetType);
 defineClass(targetType, baseTypes, evaluator);
}

public MetaForeignReference(String id, String className, String[] baseTypes) 
           throws ClassNotFoundException
{
  this(id, className);
  Class c = defineClass(getTargetClass(), baseTypes, org.omegahat.Environment.System.Globals.evaluator());
}

public Class defineClass(String targetType, String[] baseTypes, org.omegahat.Environment.Interpreter.Evaluator context) 
           throws ClassNotFoundException
{

 try {
   return(context.findClass(targetType));
 } catch(ClassNotFoundException ex) {

 }

 org.omegahat.Environment.Interpreter.BasicEvaluator evaluator = (org.omegahat.Environment.Interpreter.BasicEvaluator) context;
/*

 java.util.Vector  classes = new java.util.Vector(baseTypes.length);
 for(int i = 0; i < baseTypes.length; i++) {
   classes.add(evaluator.findClass(baseTypes[i]));
 }
*/

try {
 return(evaluator.dynamicClassLoader().defineClass(new ForeignReferenceClassGenerator(baseTypes, targetType)));
}  catch(Exception ex) {
ex.printStackTrace();
    throw new ClassNotFoundException("");
  }

// return();
}





public Object eval(org.omegahat.Environment.Interpreter.Evaluator evaluator)
         throws Throwable
{
  Object[] args = new Object[2];
    args[0] = getName();
    args[1] = evaluator;

  ConstructorExpression con = new org.omegahat.Environment.Parser.Parse.ConstructorExpression(getTargetClass(), args);

  Object obj =  con.eval(evaluator);

// System.err.println("MetaForeignReference:: -> " + obj.getClass());

return(obj);
}

public Object eval(Object[] args, org.omegahat.Environment.Interpreter.Evaluator evaluator)
       throws Throwable
{
 return(eval(evaluator));
}

/**
   Accessor for {@link #name name} field
 */
public String getName()
{
   return(name);
}


/**
   Accessor for {@link #name name} field
 */
public String setName(String value)
{
  name = value;
   return(getName());
}


/**
   Accessor for {@link #targetClass targetClass} field
 */
public String getTargetClass()
{
   return(targetClass);
}

/**
   Accessor for setting {@link #targetClass targetClass} field
 */

public String setTargetClass(String value)
{
   targetClass = value;
  return(targetClass);
}





}

/*
Copyright (c) 1998 1999, The Omega Project for Statistical Computing.
     All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are
     met:

       Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.

       Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.

       Neither name of the Omega Project for Statistical Computing nor the 
       names of its contributors may be used to endorse or promote products 
       derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY
     EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
     MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
     SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
     SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
     PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
     INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
     STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
     THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

*/

