/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements.path;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.path.Close;
import org.openscience.cdk.renderer.elements.path.CubicTo;
import org.openscience.cdk.renderer.elements.path.LineTo;
import org.openscience.cdk.renderer.elements.path.MoveTo;
import org.openscience.cdk.renderer.elements.path.PathElement;
import org.openscience.cdk.renderer.elements.path.QuadTo;

public class PathBuilder {
    List<PathElement> elements = new ArrayList<PathElement>();
    Color color = Color.BLACK;

    private <T extends PathElement> void add(T element) {
        this.elements.add(element);
    }

    public PathBuilder moveTo(Point2d point) {
        this.add(new MoveTo(point));
        return this;
    }

    public PathBuilder lineTo(Point2d point) {
        this.add(new LineTo(point));
        return this;
    }

    public PathBuilder quadTo(Point2d p1, Point2d p2) {
        this.add(new QuadTo(p1, p2));
        return this;
    }

    public PathBuilder cubicTo(Point2d p1, Point2d p2, Point2d p3) {
        this.add(new CubicTo(p1, p2, p3));
        return this;
    }

    public void close() {
        this.add(new Close());
    }

    public PathBuilder color(Color color) {
        this.color = color;
        return this;
    }

    public GeneralPath createPath() {
        return new GeneralPath(this.elements, this.color);
    }
}

