/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class MoveAtomEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -2277790465507859547L;
    private IAtomContainer undoRedoContainer;
    private Vector2d offset;
    private String type;

    public MoveAtomEdit(IAtomContainer undoRedoContainer, Vector2d offset, String type) {
        this.undoRedoContainer = undoRedoContainer;
        this.offset = offset;
        this.type = type;
    }

    @Override
    public void redo() {
        for (int i = 0; i < this.undoRedoContainer.getAtomCount(); ++i) {
            IAtom atom = this.undoRedoContainer.getAtom(i);
            atom.getPoint2d().x += this.offset.x;
            atom.getPoint2d().y += this.offset.y;
        }
    }

    @Override
    public void undo() {
        for (int i = 0; i < this.undoRedoContainer.getAtomCount(); ++i) {
            IAtom atom = this.undoRedoContainer.getAtom(i);
            atom.getPoint2d().x -= this.offset.x;
            atom.getPoint2d().y -= this.offset.y;
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

