/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.periodictable;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.ElementPTReader;
import org.openscience.cdk.tools.periodictable.PeriodicTableElement;

@TestClass(value="org.openscience.cdk.tools.periodictable.ElementPTFactoryTest")
class ElementPTFactory {
    private static ElementPTFactory efac = null;
    private List<PeriodicTableElement> elements = null;
    private boolean debug = false;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElementPTFactory.class);

    private ElementPTFactory() throws IOException {
        logger.info("Creating new ElementPTFactory");
        InputStream ins = null;
        String errorMessage = "There was a problem getting org.openscience.cdk.config.chemicalElements.xml as a stream";
        try {
            String configFile = "org/openscience/cdk/config/data/chemicalElements.xml";
            if (this.debug) {
                logger.debug("Getting stream for ", configFile);
            }
            ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        }
        catch (Exception exception) {
            logger.error(errorMessage);
            logger.debug(exception);
            throw new IOException(errorMessage);
        }
        if (ins == null) {
            logger.error(errorMessage);
            throw new IOException(errorMessage);
        }
        ElementPTReader reader = new ElementPTReader(new InputStreamReader(ins));
        this.elements = reader.readElements();
        if (this.debug) {
            logger.debug("Found #elements in file: ", this.elements.size());
        }
    }

    @TestMethod(value="testGetInstance")
    public static ElementPTFactory getInstance() throws IOException {
        if (efac == null) {
            efac = new ElementPTFactory();
        }
        return efac;
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.elements.size();
    }

    @TestMethod(value="testGetElements")
    public List<PeriodicTableElement> getElements() {
        return this.elements;
    }

    @TestMethod(value="testGetElement_String")
    public PeriodicTableElement getElement(String symbol) {
        for (PeriodicTableElement element : this.elements) {
            if (!element.getSymbol().equals(symbol)) continue;
            try {
                return (PeriodicTableElement)element.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone PeriodicTableElement: ", e.getMessage());
                logger.debug(e);
            }
        }
        return null;
    }

    @TestMethod(value="testConfigure_PeriodicTableElement")
    public PeriodicTableElement configure(PeriodicTableElement element) throws CDKException {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        element.setSymbol(elementInt.getSymbol());
        element.setAtomicNumber(elementInt.getAtomicNumber());
        element.setName(elementInt.getName());
        element.setChemicalSerie(elementInt.getChemicalSerie());
        element.setPeriod(elementInt.getPeriod());
        if (elementInt.getGroup() != null) {
            element.setGroup(elementInt.getGroup());
        }
        element.setPhase(elementInt.getPhase());
        element.setCASid(elementInt.getCASid());
        element.setPaulingEneg(elementInt.getPaulingEneg());
        return element;
    }

    @TestMethod(value="testGetAtomicNumber_PeriodicTableElement")
    public double getAtomicNumber(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getAtomicNumber().intValue();
    }

    @TestMethod(value="testGetName_PeriodicTableElement")
    public String getName(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getName();
    }

    @TestMethod(value="testGetChemicalSerie_PeriodicTableElement")
    public String getChemicalSerie(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getChemicalSerie();
    }

    @TestMethod(value="testGetPeriod_PeriodicTableElement")
    public int getPeriod(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getPeriod();
    }

    @TestMethod(value="testGetGroup_PeriodicTableElement")
    public int getGroup(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getGroup();
    }

    @TestMethod(value="testGetPhase_PeriodicTableElement")
    public String getPhase(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getPhase();
    }

    @TestMethod(value="testGetCASid_PeriodicTableElement")
    public String getCASid(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getCASid();
    }

    @TestMethod(value="testGetVdwRadius_PeriodicTableElement")
    public double getVdwRadius(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getVdwRadius();
    }

    @TestMethod(value="testGetCovalentRadius_PeriodicTableElement")
    public double getCovalentRadius(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getCovalentRadius();
    }

    @TestMethod(value="testGetPaulingEneg_PeriodicTableElement")
    public double getPaulingEneg(PeriodicTableElement element) {
        PeriodicTableElement elementInt = this.getElement(element.getSymbol());
        return elementInt.getPaulingEneg();
    }
}

