/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.AppendAtom;
import org.openscience.cdk.controller.edit.SetBondOrder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.selection.AbstractSelection;
import org.openscience.cdk.renderer.selection.SingleSelection;

public class AddBondModule
extends ControllerModuleAdapter {
    public AddBondModule(IChemModelRelay relay) {
        super(relay);
    }

    @Override
    public void mouseClickedDown(Point2d worldCoordinate) {
        IAtom closestAtom = this.chemModelRelay.getClosestAtom(worldCoordinate);
        IBond closestBond = this.chemModelRelay.getClosestBond(worldCoordinate);
        IChemObject singleSelection = this.getHighlighted(worldCoordinate, new IChemObject[]{closestAtom, closestBond});
        if (singleSelection == null) {
            this.chemModelRelay.execute(AppendAtom.addNewBond(worldCoordinate));
            this.setSelection(AbstractSelection.EMPTY_SELECTION);
        } else if (singleSelection instanceof IAtom) {
            String atomType = this.chemModelRelay.getControlModel().getDrawElement();
            this.chemModelRelay.execute(AppendAtom.appendAtom(atomType, (IAtom)singleSelection));
        } else if (singleSelection instanceof IBond) {
            this.chemModelRelay.execute(SetBondOrder.cycleBondValence((IBond)singleSelection));
            this.setSelection(new SingleSelection<IChemObject>(singleSelection));
        }
        this.chemModelRelay.updateView();
    }

    @Override
    public String getDrawModeString() {
        return "Draw Bond";
    }
}

