/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.SetSymbol;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.selection.AbstractSelection;

public class CycleSymbolModule
extends ControllerModuleAdapter {
    public CycleSymbolModule(IChemModelRelay chemModelRelay) {
        super(chemModelRelay);
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        IChemObject singleSelected = this.getHighlighted(worldCoord, new IChemObject[]{this.chemModelRelay.getClosestAtom(worldCoord)});
        if (!(singleSelected instanceof IAtom)) {
            this.setSelection(AbstractSelection.EMPTY_SELECTION);
            return;
        }
        IAtom closestAtom = (IAtom)singleSelected;
        String symbol = closestAtom.getSymbol();
        String[] elements = this.chemModelRelay.getControlModel().getCommonElements();
        SetSymbol edit = null;
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].equals(symbol)) continue;
            if (i < elements.length - 1) {
                edit = SetSymbol.setSymbol(closestAtom, elements[i + 1]);
                break;
            }
            edit = SetSymbol.setSymbol(closestAtom, elements[0]);
            break;
        }
        if (edit != null) {
            this.chemModelRelay.execute(edit);
        } else {
            this.chemModelRelay.execute(SetSymbol.setSymbol(closestAtom, "C"));
        }
    }

    @Override
    public String getDrawModeString() {
        return "Cycle Symbol";
    }
}

