/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.vecmath.Point2d;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.TextGroupElement;
import org.openscience.cdk.renderer.generators.AtomNumberGenerator;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class ExtendedAtomGenerator
extends BasicAtomGenerator {
    private IGeneratorParameter<Boolean> showImplicitHydrogens = new ShowImplicitHydrogens();
    private ShowAtomTypeNames showAtomTypeNames = new ShowAtomTypeNames();

    @Override
    public IRenderingElement generate(IAtomContainer ac, IAtom atom, RendererModel model) {
        boolean drawNumbers = (Boolean)model.getParameter(AtomNumberGenerator.WillDrawAtomNumbers.class).getValue();
        if (!this.hasCoordinates(atom) || this.invisibleHydrogen(atom, model) || this.invisibleCarbon(atom, ac, model) && !drawNumbers) {
            return null;
        }
        if (((Boolean)model.getParameter(BasicAtomGenerator.CompactAtom.class).getValue()).booleanValue()) {
            return this.generateCompactElement(atom, model);
        }
        String text = atom instanceof IPseudoAtom ? ((IPseudoAtom)atom).getLabel() : (this.invisibleCarbon(atom, ac, model) && drawNumbers ? String.valueOf(ac.getAtomNumber(atom) + 1) : atom.getSymbol());
        Point2d p = atom.getPoint2d();
        Color c = this.getAtomColor(atom);
        TextGroupElement textGroup = new TextGroupElement(p.x, p.y, text, c);
        this.decorate(textGroup, ac, atom, model);
        return textGroup;
    }

    public boolean hideAtomSymbol(IAtom atom, RendererModel model) {
        return atom.getSymbol().equals("C") && (Boolean)model.getParameter(BasicAtomGenerator.KekuleStructure.class).getValue() == false;
    }

    public void decorate(TextGroupElement textGroup, IAtomContainer ac, IAtom atom, RendererModel model) {
        Integer massNumber;
        int nH;
        Stack<TextGroupElement.Position> unused = this.getUnusedPositions(ac, atom);
        boolean drawNumbers = (Boolean)model.getParameter(AtomNumberGenerator.WillDrawAtomNumbers.class).getValue();
        if (!this.invisibleCarbon(atom, ac, model) && drawNumbers) {
            TextGroupElement.Position position = this.getNextPosition(unused);
            String number = String.valueOf(ac.getAtomNumber(atom) + 1);
            textGroup.addChild(number, position);
        }
        if (this.showImplicitHydrogens.getValue().booleanValue() && atom.getImplicitHydrogenCount() != null && (nH = atom.getImplicitHydrogenCount().intValue()) > 0) {
            TextGroupElement.Position position = this.getNextPosition(unused);
            if (nH == 1) {
                textGroup.addChild("H", position);
            } else {
                textGroup.addChild("H", String.valueOf(nH), position);
            }
        }
        if ((massNumber = atom.getMassNumber()) != null) {
            try {
                IsotopeFactory factory = IsotopeFactory.getInstance((IChemObjectBuilder)ac.getBuilder());
                int majorMass = factory.getMajorIsotope(atom.getSymbol()).getMassNumber();
                if (massNumber != majorMass) {
                    TextGroupElement.Position position = this.getNextPosition(unused);
                    textGroup.addChild(String.valueOf(massNumber), position);
                }
            }
            catch (IOException io) {
                // empty catch block
            }
        }
    }

    private TextGroupElement.Position getNextPosition(Stack<TextGroupElement.Position> unused) {
        if (unused.size() > 0) {
            return unused.pop();
        }
        return TextGroupElement.Position.N;
    }

    public Stack<TextGroupElement.Position> getUnusedPositions(IAtomContainer ac, IAtom atom) {
        Stack<TextGroupElement.Position> unused = new Stack<TextGroupElement.Position>();
        for (TextGroupElement.Position p : TextGroupElement.Position.values()) {
            unused.add(p);
        }
        for (IAtom connectedAtom : ac.getConnectedAtomsList(atom)) {
            TextGroupElement.Position used = this.getPosition(atom, connectedAtom);
            if (!unused.contains((Object)used)) continue;
            unused.remove((Object)used);
        }
        return unused;
    }

    public TextGroupElement.Position getPosition(IAtom atom, IAtom connectedAtom) {
        Point2d pA = atom.getPoint2d();
        Point2d pB = connectedAtom.getPoint2d();
        double dx = pB.x - pA.x;
        double dy = pB.y - pA.y;
        double DELTA = 0.2;
        if (dx < -0.2) {
            if (dy < -0.2) {
                return TextGroupElement.Position.NW;
            }
            if (dy > -0.2 && dy < 0.2) {
                return TextGroupElement.Position.W;
            }
            return TextGroupElement.Position.SW;
        }
        if (dx > -0.2 && dx < 0.2) {
            if (dy < -0.2) {
                return TextGroupElement.Position.N;
            }
            if (dy > -0.2 && dy < 0.2) {
                return TextGroupElement.Position.N;
            }
            return TextGroupElement.Position.S;
        }
        if (dy < -0.2) {
            return TextGroupElement.Position.NE;
        }
        if (dy > -0.2 && dy < 0.2) {
            return TextGroupElement.Position.E;
        }
        return TextGroupElement.Position.SE;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        ArrayList parameters = new ArrayList();
        parameters.add(this.showImplicitHydrogens);
        parameters.add(this.showAtomTypeNames);
        parameters.addAll(super.getParameters());
        return parameters;
    }

    public static class ShowAtomTypeNames
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ShowImplicitHydrogens
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }
}

