/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.event.ChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

public class ChemObject
implements Serializable,
IChemObject,
Cloneable {
    private static final long serialVersionUID = 2798134548764323328L;
    private List<IChemObjectListener> chemObjectListeners;
    private Map<Object, Object> properties;
    private boolean[] flags;
    private String identifier;
    private boolean doNotification = true;

    public ChemObject() {
        this.flags = new boolean[13];
        this.chemObjectListeners = null;
        this.properties = null;
        this.identifier = null;
    }

    public ChemObject(IChemObject chemObject) {
        boolean[] oldflags = chemObject.getFlags();
        this.flags = new boolean[oldflags.length];
        System.arraycopy(oldflags, 0, this.flags, 0, this.flags.length);
        this.identifier = chemObject.getID();
    }

    private List<IChemObjectListener> lazyChemObjectListeners() {
        if (this.chemObjectListeners == null) {
            this.chemObjectListeners = new ArrayList<IChemObjectListener>();
        }
        return this.chemObjectListeners;
    }

    @Override
    public void addListener(IChemObjectListener col) {
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (!listeners.contains(col)) {
            listeners.add(col);
        }
    }

    @Override
    public int getListenerCount() {
        if (this.chemObjectListeners == null) {
            return 0;
        }
        return this.lazyChemObjectListeners().size();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        if (this.chemObjectListeners == null) {
            return;
        }
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (listeners.contains(col)) {
            listeners.remove(col);
        }
    }

    @Override
    public void notifyChanged() {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(new ChemObjectChangeEvent(this));
            }
        }
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        return this.properties;
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
        this.notifyChanged();
    }

    @Override
    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        if (this.lazyProperties().remove(description) != null) {
            this.notifyChanged();
        }
    }

    @Override
    public Object getProperty(Object description) {
        if (this.properties != null) {
            return this.lazyProperties().get(description);
        }
        return null;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChemObject clone = (ChemObject)super.clone();
        clone.flags = new boolean[13];
        System.arraycopy(this.flags, 0, clone.flags, 0, this.flags.length);
        if (this.properties != null) {
            HashMap<Object, Object> clonedHashtable = new HashMap<Object, Object>();
            for (Object key : this.properties.keySet()) {
                Object value = this.properties.get(key);
                clonedHashtable.put(key, value);
            }
            clone.properties = clonedHashtable;
        }
        clone.chemObjectListeners = null;
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof IChemObject)) {
            return false;
        }
        ChemObject chemObj = (ChemObject)object;
        return this.identifier == chemObj.identifier;
    }

    @Override
    public String getID() {
        return this.identifier;
    }

    @Override
    public void setID(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.flags[flag_type] = flag_value;
        this.notifyChanged();
    }

    @Override
    public boolean getFlag(int flag_type) {
        return this.flags[flag_type];
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        for (Object key : properties.keySet()) {
            this.lazyProperties().put(key, properties.get(key));
        }
        this.notifyChanged();
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.flags = flagsNew;
    }

    @Override
    public boolean[] getFlags() {
        return this.flags;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return copy;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }

    @Override
    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    @Override
    public boolean getNotification() {
        return this.doNotification;
    }
}

