/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IAtomTypeConfigurator;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

@TestClass(value="org.openscience.cdk.config.TXTBasedAtomTypeConfiguratorTest")
public class TXTBasedAtomTypeConfigurator
implements IAtomTypeConfigurator {
    private String configFile = "org/openscience/cdk/config/data/jmol_atomtypes.txt";
    private InputStream ins = null;

    @Override
    @TestMethod(value="testSetInputStream_InputStream")
    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    @Override
    @TestMethod(value="testReadAtomTypes_IChemObjectBuilder")
    public List<IAtomType> readAtomTypes(IChemObjectBuilder builder) throws IOException {
        String string;
        ArrayList<IAtomType> atomTypes = new ArrayList<IAtomType>();
        if (this.ins == null) {
            this.ins = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFile);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.ins), 1024);
        while ((string = reader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            StringTokenizer tokenizer = new StringTokenizer(string, "\t ,;");
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 9) {
                int colorB;
                int colorG;
                int colorR;
                int atomicNumber;
                double covalent;
                double mass;
                String name = tokenizer.nextToken();
                String rootType = tokenizer.nextToken();
                String san = tokenizer.nextToken();
                String sam = tokenizer.nextToken();
                tokenizer.nextToken();
                String scovalent = tokenizer.nextToken();
                String sColorR = tokenizer.nextToken();
                String sColorG = tokenizer.nextToken();
                String sColorB = tokenizer.nextToken();
                try {
                    mass = new Double(sam);
                    covalent = new Double(scovalent);
                    atomicNumber = Integer.parseInt(san);
                    colorR = Integer.parseInt(sColorR);
                    colorG = Integer.parseInt(sColorG);
                    colorB = Integer.parseInt(sColorB);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("AtomTypeTable.ReadAtypes: Malformed Number");
                }
                IAtomType atomType = builder.newInstance(IAtomType.class, name, rootType);
                atomType.setAtomicNumber(atomicNumber);
                atomType.setExactMass(mass);
                atomType.setCovalentRadius(covalent);
                Color color = new Color(colorR, colorG, colorB);
                atomType.setProperty("org.openscience.cdk.renderer.color", color);
                atomTypes.add(atomType);
                continue;
            }
            throw new IOException("AtomTypeTable.ReadAtypes: Wrong Number of fields");
        }
        this.ins.close();
        return atomTypes;
    }
}

