/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemASNFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.PCCompoundASNReaderTest")
public class PCCompoundASNReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(PCCompoundASNReader.class);
    IMolecule molecule = null;
    Map atomIDs = null;

    public PCCompoundASNReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public PCCompoundASNReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public PCCompoundASNReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return PubChemASNFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public IChemObject read(IChemObject object) throws CDKException {
        if (object instanceof IChemFile) {
            try {
                return this.readChemFile((IChemFile)object);
            }
            catch (IOException e) {
                throw new CDKException("An IO Exception occured while reading the file.", e);
            }
            catch (CDKException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CDKException("An error occured.", e);
            }
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    private IChemFile readChemFile(IChemFile file) throws Exception {
        IChemSequence chemSequence = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet moleculeSet = file.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        this.molecule = file.getBuilder().newInstance(IMolecule.class, new Object[0]);
        this.atomIDs = new HashMap();
        String line = this.input.readLine();
        while (this.input.ready() && line != null) {
            if (line.indexOf("{") != -1) {
                this.processBlock(line);
            } else {
                logger.warn("Skipping non-block: " + line);
            }
            line = this.input.readLine();
        }
        moleculeSet.addAtomContainer(this.molecule);
        chemModel.setMoleculeSet(moleculeSet);
        chemSequence.addChemModel(chemModel);
        file.addChemSequence(chemSequence);
        return file;
    }

    private void processBlock(String line) throws Exception {
        String command = this.getCommand(line);
        if (command.equals("atoms")) {
            logger.debug("ASN atoms found");
            this.processAtomBlock();
        } else if (command.equals("bonds")) {
            logger.debug("ASN bonds found");
            this.processBondBlock();
        } else if (command.equals("props")) {
            logger.debug("ASN props found");
            this.processPropsBlock();
        } else if (command.equals("PC-Compound ::=")) {
            logger.debug("ASN PC-Compound found");
        } else {
            logger.warn("Skipping block: " + command);
            this.skipBlock();
        }
    }

    private void processPropsBlock() throws Exception {
        String line = this.input.readLine();
        while (this.input.ready() && line != null) {
            if (line.indexOf("{") != -1) {
                this.processPropsBlockBlock();
            } else {
                if (line.indexOf("}") != -1) {
                    return;
                }
                logger.warn("Skipping non-block: " + line);
            }
            line = this.input.readLine();
        }
    }

    private void processPropsBlockBlock() throws Exception {
        String line = this.input.readLine();
        URN urn = null;
        while (this.input.ready() && line != null) {
            if (line.indexOf("urn") != -1) {
                urn = this.extractURN();
            } else if (line.indexOf("value") != -1) {
                logger.debug("Found a prop value line: " + line);
                if (line.indexOf(" sval") != -1) {
                    String value;
                    logger.debug("Label: " + urn.label);
                    logger.debug("Name: " + urn.name);
                    if ("InChI".equals(urn.label)) {
                        value = this.getQuotedValue(line.substring(line.indexOf("value sval") + 10));
                        this.molecule.setProperty("cdk:InChI", value);
                    } else if ("SMILES".equals(urn.label) && "Canonical".equals(urn.name)) {
                        value = this.getQuotedValue(line.substring(line.indexOf("value sval") + 10));
                        this.molecule.setProperty("cdk:SMILES", value);
                    }
                }
            } else {
                if (line.indexOf("}") != -1) {
                    return;
                }
                logger.warn("Skipping non-block: " + line);
            }
            line = this.input.readLine();
        }
    }

    private URN extractURN() throws Exception {
        URN urn = new URN();
        String line = this.input.readLine();
        while (this.input.ready() && line != null) {
            if (line.indexOf("name") != -1) {
                urn.name = this.getQuotedValue(line.substring(line.indexOf("name") + 4));
            } else if (line.indexOf("label") != -1) {
                urn.label = this.getQuotedValue(line.substring(line.indexOf("label") + 4));
            } else {
                if (line.indexOf("}") != -1 && line.indexOf("\"") == -1) {
                    return urn;
                }
                logger.warn("Ignoring URN statement: " + line);
            }
            line = this.input.readLine();
        }
        return urn;
    }

    private void processAtomBlock() throws Exception {
        String line = this.input.readLine();
        while (this.input.ready() && line != null) {
            if (line.indexOf("{") != -1) {
                this.processAtomBlockBlock(line);
            } else {
                if (line.indexOf("}") != -1) {
                    return;
                }
                logger.warn("Skipping non-block: " + line);
            }
            line = this.input.readLine();
        }
    }

    private void processBondBlock() throws Exception {
        String line = this.input.readLine();
        while (this.input.ready() && line != null) {
            if (line.indexOf("{") != -1) {
                this.processBondBlockBlock(line);
            } else {
                if (line.indexOf("}") != -1) {
                    return;
                }
                logger.warn("Skipping non-block: " + line);
            }
            line = this.input.readLine();
        }
    }

    private IAtom getAtom(int i) {
        if (this.molecule.getAtomCount() <= i) {
            this.molecule.addAtom(this.molecule.getBuilder().newInstance(IAtom.class, new Object[0]));
        }
        return this.molecule.getAtom(i);
    }

    private IBond getBond(int i) {
        if (this.molecule.getBondCount() <= i) {
            this.molecule.addBond(this.molecule.getBuilder().newInstance(IBond.class, new Object[0]));
        }
        return this.molecule.getBond(i);
    }

    private void processAtomBlockBlock(String line) throws Exception {
        String command = this.getCommand(line);
        if (command.equals("aid")) {
            logger.debug("ASN atoms aid found");
            this.processAtomAIDs();
        } else if (command.equals("element")) {
            logger.debug("ASN atoms element found");
            this.processAtomElements();
        } else {
            logger.warn("Skipping atom block block: " + command);
            this.skipBlock();
        }
    }

    private void processBondBlockBlock(String line) throws Exception {
        String command = this.getCommand(line);
        if (command.equals("aid1")) {
            logger.debug("ASN bonds aid1 found");
            this.processBondAtomIDs(0);
        } else if (command.equals("aid2")) {
            logger.debug("ASN bonds aid2 found");
            this.processBondAtomIDs(1);
        } else {
            logger.warn("Skipping atom block block: " + command);
            this.skipBlock();
        }
    }

    private void processAtomAIDs() throws Exception {
        String line = this.input.readLine();
        int atomIndex = 0;
        while (this.input.ready() && line != null) {
            if (line.indexOf("}") != -1) {
                return;
            }
            IAtom atom = this.getAtom(atomIndex);
            String id = this.getValue(line);
            atom.setID(id);
            this.atomIDs.put(id, atom);
            ++atomIndex;
            line = this.input.readLine();
        }
    }

    private void processBondAtomIDs(int pos) throws Exception {
        String line = this.input.readLine();
        int bondIndex = 0;
        while (this.input.ready() && line != null) {
            if (line.indexOf("}") != -1) {
                return;
            }
            IBond bond = this.getBond(bondIndex);
            String id = this.getValue(line);
            IAtom atom = (IAtom)this.atomIDs.get(id);
            if (atom == null) {
                throw new CDKException("File is corrupt: atom ID does not exist " + id);
            }
            bond.setAtom(atom, pos);
            ++bondIndex;
            line = this.input.readLine();
        }
    }

    private void processAtomElements() throws Exception {
        String line = this.input.readLine();
        int atomIndex = 0;
        while (this.input.ready() && line != null) {
            if (line.indexOf("}") != -1) {
                return;
            }
            IAtom atom = this.getAtom(atomIndex);
            atom.setSymbol(this.toSymbol(this.getValue(line)));
            ++atomIndex;
            line = this.input.readLine();
        }
    }

    private String toSymbol(String value) {
        if (value.length() == 1) {
            return value.toUpperCase();
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private void skipBlock() throws IOException {
        String line = this.input.readLine();
        int openBrackets = 0;
        while (line != null) {
            if (line.indexOf(123) != -1) {
                ++openBrackets;
            }
            if (line.indexOf(125) != -1) {
                if (openBrackets == 0) {
                    return;
                }
                --openBrackets;
            }
            line = this.input.readLine();
        }
    }

    private String getCommand(String line) {
        StringBuffer buffer = new StringBuffer();
        boolean foundBracket = false;
        for (int i = 0; i < line.length() && !foundBracket; ++i) {
            char currentChar = line.charAt(i);
            if (currentChar == '{') {
                foundBracket = true;
                continue;
            }
            buffer.append(currentChar);
        }
        return foundBracket ? buffer.toString().trim() : null;
    }

    private String getValue(String line) {
        StringBuffer buffer = new StringBuffer();
        boolean foundComma = false;
        boolean preWS = true;
        for (int i = 0; i < line.length() && !foundComma; ++i) {
            char currentChar = line.charAt(i);
            if (Character.isWhitespace(currentChar)) {
                if (preWS) continue;
                buffer.append(currentChar);
                continue;
            }
            if (currentChar == ',') {
                foundComma = true;
                continue;
            }
            buffer.append(currentChar);
            preWS = false;
        }
        return buffer.toString();
    }

    private String getQuotedValue(String line) throws Exception {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        boolean startQuoteFound = false;
        while (line != null) {
            while (i < line.length()) {
                char currentChar = line.charAt(i);
                if (currentChar == '\"') {
                    if (startQuoteFound) {
                        return buffer.toString();
                    }
                    startQuoteFound = true;
                } else if (startQuoteFound) {
                    buffer.append(currentChar);
                }
                ++i;
            }
            line = this.input.readLine();
            i = 0;
        }
        return null;
    }

    class URN {
        String name = null;
        String label = null;

        URN() {
        }
    }
}

