/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class SystemTool {
    private static final Logger LOG = Logger.getLogger(SystemTool.class);
    private static final String ARCHITECTURE_DEFS = "META-INF/jnati/architecture.defs";
    private static final String PLATFORM_DEFS = "META-INF/jnati/platform.defs";
    private static String platform;
    private static String architecture;
    private static boolean init;

    private static void init() {
        if (!init) {
            String osname = System.getProperty("os.name", "");
            String osarch = System.getProperty("os.arch", "");
            LOG.info("Detecting platform/architecture");
            LOG.debug("Itentifying platform (os.name=" + osname + ")");
            try {
                platform = SystemTool.searchDefinitionFiles(osname, PLATFORM_DEFS);
            }
            catch (IOException e) {
                throw new RuntimeException("Error detecting platform", e);
            }
            LOG.info("Platform: " + platform);
            LOG.debug("Itentifying architecture (os.arch=" + osarch + ")");
            try {
                architecture = SystemTool.searchDefinitionFiles(osarch, ARCHITECTURE_DEFS);
            }
            catch (IOException e) {
                throw new RuntimeException("Error detecting architecture", e);
            }
            LOG.info("Architecture: " + architecture);
            init = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String searchDefinitionFiles(String name, String filepath) throws IOException {
        Enumeration<URL> e = SystemTool.class.getClassLoader().getResources(filepath);
        if (!e.hasMoreElements()) {
            throw new IOException("Definition file missing: " + filepath);
        }
        for (URL u : Collections.list(e)) {
            LOG.debug("Reading definitions file: " + u);
            BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
            try {
                int n = 0;
                String l = in.readLine();
                while (l != null) {
                    ++n;
                    if ((l = l.trim()).length() != 0 && !l.startsWith("#")) {
                        String[] s = l.split("\\s+");
                        if (s.length != 2) {
                            LOG.warn("Ignoring bad line (" + n + "): " + l);
                        } else {
                            LOG.trace("Testing pattern: " + s[1] + " (" + s[0] + ")");
                            Pattern p = Pattern.compile(s[1], 2);
                            if (p.matcher(name).matches()) {
                                String string = s[0];
                                return string;
                            }
                        }
                    }
                    l = in.readLine();
                }
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    public static String getPlatform() throws IOException {
        SystemTool.init();
        return platform;
    }

    public static String getArchitecture() {
        SystemTool.init();
        return architecture;
    }

    public static void main(String[] args) throws Exception {
        int arg = 0;
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            ConsoleAppender a = new ConsoleAppender();
            a.setWriter(new OutputStreamWriter(System.err));
            a.setLayout(new SimpleLayout());
            LOG.addAppender(a);
        }
        if (args.length > 0 && "-v".equals(args[0])) {
            LOG.setLevel(Level.DEBUG);
            ++arg;
        } else if (args.length > 0 && "-vv".equals(args[0])) {
            LOG.setLevel(Level.TRACE);
            ++arg;
        } else {
            LOG.setLevel(Level.WARN);
        }
        if (args.length > arg) {
            String c = args[args.length - 1];
            if ("os".equals(c)) {
                System.out.println(SystemTool.getPlatform());
            } else if ("arch".equals(c)) {
                System.out.println(SystemTool.getArchitecture());
            } else {
                System.out.println("Unknown command: " + c);
            }
        } else {
            String osarch = SystemTool.getPlatform() + "-" + SystemTool.getArchitecture();
            System.out.println(osarch);
        }
    }

    static {
        init = false;
    }
}

