/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.ISingleElectron;

@TestClass(value="org.openscience.cdk.atomtype.CDKAtomTypeMatcherTest")
public class CDKAtomTypeMatcher
implements IAtomTypeMatcher {
    public static final int REQUIRE_NOTHING = 1;
    public static final int REQUIRE_EXPLICIT_HYDROGENS = 2;
    private AtomTypeFactory factory;
    private int mode;
    private static Map<Integer, Map<IChemObjectBuilder, CDKAtomTypeMatcher>> factories = new Hashtable<Integer, Map<IChemObjectBuilder, CDKAtomTypeMatcher>>(1);

    private CDKAtomTypeMatcher(IChemObjectBuilder builder, int mode) {
        this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/dict/data/cdk-atom-types.owl", builder);
        this.mode = mode;
    }

    @TestMethod(value="testGetInstance_IChemObjectBuilder")
    public static CDKAtomTypeMatcher getInstance(IChemObjectBuilder builder) {
        return CDKAtomTypeMatcher.getInstance(builder, 1);
    }

    @TestMethod(value="testGetInstance_IChemObjectBuilder_int")
    public static CDKAtomTypeMatcher getInstance(IChemObjectBuilder builder, int mode) {
        if (!factories.containsKey(mode)) {
            factories.put(mode, new Hashtable(1));
        }
        if (!factories.get(mode).containsKey(builder)) {
            factories.get(mode).put(builder, new CDKAtomTypeMatcher(builder, mode));
        }
        return factories.get(mode).get(builder);
    }

    @Override
    @TestMethod(value="testFindMatchingAtomType_IAtomContainer")
    public IAtomType[] findMatchingAtomType(IAtomContainer atomContainer) throws CDKException {
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            types[typeCounter] = this.findMatchingAtomType(atomContainer, atom);
            ++typeCounter;
        }
        return types;
    }

    @Override
    @TestMethod(value="testFindMatchingAtomType_IAtomContainer_IAtom")
    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type = null;
        if (atom instanceof IPseudoAtom) {
            return this.factory.getAtomType("X");
        }
        if ("C".equals(atom.getSymbol())) {
            type = this.perceiveCarbons(atomContainer, atom);
        } else if ("Li".equals(atom.getSymbol())) {
            type = this.perceiveLithium(atomContainer, atom);
        } else if ("O".equals(atom.getSymbol())) {
            type = this.perceiveOxygens(atomContainer, atom);
        } else if ("N".equals(atom.getSymbol())) {
            type = this.perceiveNitrogens(atomContainer, atom);
        } else if ("H".equals(atom.getSymbol())) {
            type = this.perceiveHydrogens(atomContainer, atom);
        } else if ("S".equals(atom.getSymbol())) {
            type = this.perceiveSulphurs(atomContainer, atom);
        } else if ("P".equals(atom.getSymbol())) {
            type = this.perceivePhosphors(atomContainer, atom);
        } else if ("Si".equals(atom.getSymbol())) {
            type = this.perceiveSilicon(atomContainer, atom);
        } else if ("B".equals(atom.getSymbol())) {
            type = this.perceiveBorons(atomContainer, atom);
        } else if ("Be".equals(atom.getSymbol())) {
            type = this.perceiveBeryllium(atomContainer, atom);
        } else if ("Se".equals(atom.getSymbol())) {
            type = this.perceiveSelenium(atomContainer, atom);
        } else if ("Te".equals(atom.getSymbol())) {
            type = this.perceiveTellurium(atomContainer, atom);
        } else if ("Ga".equals(atom.getSymbol())) {
            type = this.perceiveGallium(atomContainer, atom);
        } else if ("Ge".equals(atom.getSymbol())) {
            type = this.perceiveGermanium(atomContainer, atom);
        } else if ("K".equals(atom.getSymbol())) {
            type = this.perceivePotassium(atomContainer, atom);
        } else if ("Mn".equals(atom.getSymbol())) {
            type = this.perceiveManganese(atomContainer, atom);
        } else if ("Na".equals(atom.getSymbol())) {
            type = this.perceiveSodium(atomContainer, atom);
        } else if ("As".equals(atom.getSymbol())) {
            type = this.perceiveArsenic(atomContainer, atom);
        } else {
            if (type == null) {
                type = this.perceiveHalogens(atomContainer, atom);
            }
            if (type == null) {
                type = this.perceiveCommonSalts(atomContainer, atom);
            }
            if (type == null) {
                type = this.perceiveOrganometallicCenters(atomContainer, atom);
            }
            if (type == null) {
                type = this.perceiveNobelGases(atomContainer, atom);
            }
        }
        return type;
    }

    private IAtomType perceiveGallium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedAtomsCount(atom) <= 3) {
            IAtomType type2 = this.getAtomType("Ga");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ga.3plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveGermanium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedAtomsCount(atom) <= 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ge"))) {
            return type;
        }
        if (atom.getFormalCharge() == 0 && atomContainer.getConnectedAtomsCount(atom) == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ge.3"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveSelenium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedAtomsCount(atom) <= 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Se.3"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveTellurium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (!this.isCharged(atom) && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedAtomsCount(atom) <= 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Te.3"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveBorons(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (atom.getFormalCharge() == -1 && maxBondOrder == IBond.Order.SINGLE && atomContainer.getConnectedAtomsCount(atom) <= 4) {
            IAtomType type2 = this.getAtomType("B.minus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atomContainer.getConnectedAtomsCount(atom) <= 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("B"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveBeryllium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (atom.getFormalCharge() == -2 && atomContainer.getMaximumBondOrder(atom) == IBond.Order.SINGLE && atomContainer.getConnectedAtomsCount(atom) <= 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Be.2minus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveCarbonRadicals(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atomContainer.getConnectedBondsCount(atom) == 0) {
            IAtomType type = this.getAtomType("C.radical.planar");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) <= 3) {
            IAtomType type;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == IBond.Order.SINGLE) {
                IAtomType type2 = this.getAtomType("C.radical.planar");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (maxBondOrder == IBond.Order.DOUBLE) {
                IAtomType type3 = this.getAtomType("C.radical.sp2");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (maxBondOrder == IBond.Order.TRIPLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.radical.sp1"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveCarbons(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return this.perceiveCarbonRadicals(atomContainer, atom);
        }
        if (this.hasHybridization(atom) && !this.isCharged(atom)) {
            IAtomType type;
            if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                IAtomType type2 = this.getAtomType("C.sp2");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP3) {
                IAtomType type3 = this.getAtomType("C.sp3");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.sp"))) {
                return type;
            }
        } else if (atom.getFlag(5)) {
            IAtomType type = this.getAtomType("C.sp2");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else {
            if (this.isCharged(atom)) {
                if (atom.getFormalCharge() == 1) {
                    if (atomContainer.getConnectedBondsCount(atom) == 0) {
                        IAtomType type = this.getAtomType("C.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    } else {
                        IAtomType type;
                        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                        if (maxBondOrder == CDKConstants.BONDORDER_TRIPLE) {
                            IAtomType type4 = this.getAtomType("C.plus.sp1");
                            if (this.isAcceptable(atom, atomContainer, type4)) {
                                return type4;
                            }
                        } else if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                            IAtomType type5 = this.getAtomType("C.plus.sp2");
                            if (this.isAcceptable(atom, atomContainer, type5)) {
                                return type5;
                            }
                        } else if (maxBondOrder == CDKConstants.BONDORDER_SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.plus.planar"))) {
                            return type;
                        }
                    }
                } else if (atom.getFormalCharge() == -1) {
                    IAtomType type;
                    IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                    if (maxBondOrder == CDKConstants.BONDORDER_SINGLE && atomContainer.getConnectedBondsCount(atom) <= 3) {
                        IAtomType type6;
                        if (this.isRingAtom(atom, atomContainer) && this.bothNeighborsAreSp2(atom, atomContainer) && this.isAcceptable(atom, atomContainer, type6 = this.getAtomType("C.minus.planar"))) {
                            return type6;
                        }
                        type6 = this.getAtomType("C.minus.sp3");
                        if (this.isAcceptable(atom, atomContainer, type6)) {
                            return type6;
                        }
                    } else if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE && atomContainer.getConnectedBondsCount(atom) <= 3) {
                        IAtomType type7 = this.getAtomType("C.minus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type7)) {
                            return type7;
                        }
                    } else if (maxBondOrder == CDKConstants.BONDORDER_TRIPLE && atomContainer.getConnectedBondsCount(atom) <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.minus.sp1"))) {
                        return type;
                    }
                }
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) > 4) {
                return null;
            }
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == IBond.Order.QUADRUPLE) {
                return null;
            }
            if (maxBondOrder == CDKConstants.BONDORDER_TRIPLE) {
                IAtomType type = this.getAtomType("C.sp");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                IAtomType type;
                int doubleBondCount = this.countAttachedDoubleBonds(atomContainer, atom);
                if (doubleBondCount == 2) {
                    IAtomType type8 = this.getAtomType("C.sp");
                    if (this.isAcceptable(atom, atomContainer, type8)) {
                        return type8;
                    }
                } else if (doubleBondCount == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.sp2"))) {
                    return type;
                }
            } else {
                IAtomType type;
                if (this.hasAromaticBond(atomContainer, atom) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("C.sp2"))) {
                    return type;
                }
                type = this.getAtomType("C.sp3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        }
        return null;
    }

    private boolean hasOneSingleElectron(IAtomContainer atomContainer, IAtom atom) {
        Iterator<ISingleElectron> singleElectrons = atomContainer.singleElectrons().iterator();
        while (singleElectrons.hasNext()) {
            if (!singleElectrons.next().contains(atom)) continue;
            return true;
        }
        return false;
    }

    private int countSingleElectrons(IAtomContainer atomContainer, IAtom atom) {
        Iterator<ISingleElectron> singleElectrons = atomContainer.singleElectrons().iterator();
        int count = 0;
        while (singleElectrons.hasNext()) {
            if (!singleElectrons.next().contains(atom)) continue;
            ++count;
        }
        return count;
    }

    private IAtomType perceiveOxygenRadicals(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atom.getFormalCharge() == 0) {
            IAtomType type;
            if (atomContainer.getConnectedBondsCount(atom) <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.sp3.radical"))) {
                return type;
            }
        } else if (atom.getFormalCharge() == 1) {
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type = this.getAtomType("O.plus.radical");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) <= 2) {
                IAtomType type;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == IBond.Order.SINGLE) {
                    IAtomType type2 = this.getAtomType("O.plus.radical");
                    if (this.isAcceptable(atom, atomContainer, type2)) {
                        return type2;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.plus.sp2.radical"))) {
                    return type;
                }
            }
        }
        return null;
    }

    private boolean isCharged(IAtom atom) {
        return atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0;
    }

    private boolean hasHybridization(IAtom atom) {
        return atom.getHybridization() != CDKConstants.UNSET;
    }

    private IAtomType perceiveOxygens(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return this.perceiveOxygenRadicals(atomContainer, atom);
        }
        if (this.hasHybridization(atom) && !this.isCharged(atom)) {
            IAtomType type;
            if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                IAtomType type2;
                int connectedAtomsCount = atomContainer.getConnectedAtomsCount(atom);
                if (connectedAtomsCount == 1) {
                    if (this.isCarboxylate(atom, atomContainer)) {
                        IAtomType type3 = this.getAtomType("O.sp2.co2");
                        if (this.isAcceptable(atom, atomContainer, type3)) {
                            return type3;
                        }
                    } else {
                        IAtomType type4 = this.getAtomType("O.sp2");
                        if (this.isAcceptable(atom, atomContainer, type4)) {
                            return type4;
                        }
                    }
                } else if (connectedAtomsCount == 2 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("O.planar3"))) {
                    return type2;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP3) {
                IAtomType type5 = this.getAtomType("O.sp3");
                if (this.isAcceptable(atom, atomContainer, type5)) {
                    return type5;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.PLANAR3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.planar3"))) {
                return type;
            }
        } else {
            if (this.isCharged(atom)) {
                if (atom.getFormalCharge() == -1 && atomContainer.getConnectedAtomsCount(atom) <= 1) {
                    if (this.isCarboxylate(atom, atomContainer)) {
                        IAtomType type = this.getAtomType("O.minus.co2");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("O.minus");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    }
                } else if (atom.getFormalCharge() == -2 && atomContainer.getConnectedAtomsCount(atom) == 0) {
                    IAtomType type = this.getAtomType("O.minus2");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else if (atom.getFormalCharge() == 1) {
                    IAtomType type;
                    if (atomContainer.getConnectedBondsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.plus"))) {
                        return type;
                    }
                    IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                    if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                        IAtomType type6 = this.getAtomType("O.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type6)) {
                            return type6;
                        }
                    } else if (maxBondOrder == CDKConstants.BONDORDER_TRIPLE) {
                        IAtomType type7 = this.getAtomType("O.plus.sp1");
                        if (this.isAcceptable(atom, atomContainer, type7)) {
                            return type7;
                        }
                    } else {
                        IAtomType type8 = this.getAtomType("O.plus");
                        if (this.isAcceptable(atom, atomContainer, type8)) {
                            return type8;
                        }
                    }
                }
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) > 2) {
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type = this.getAtomType("O.sp3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                    if (this.isCarboxylate(atom, atomContainer)) {
                        IAtomType type = this.getAtomType("O.sp2.co2");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("O.sp2");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_SINGLE) {
                    int explicitHydrogens = this.countExplicitHydrogens(atom, atomContainer);
                    int connectedHeavyAtoms = atomContainer.getConnectedBondsCount(atom) - explicitHydrogens;
                    if (connectedHeavyAtoms == 2) {
                        IAtomType type;
                        if (this.isRingAtom(atom, atomContainer) && this.bothNeighborsAreSp2(atom, atomContainer) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("O.planar3"))) {
                            return type;
                        }
                        type = this.getAtomType("O.sp3");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("O.sp3");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean isCarboxylate(IAtom atom, IAtomContainer container) {
        List<IAtom> neighbors = container.getConnectedAtomsList(atom);
        if (neighbors.size() != 1) {
            return false;
        }
        IAtom carbon = neighbors.get(0);
        if (!"C".equals(carbon.getSymbol())) {
            return false;
        }
        int oxygenCount = 0;
        int singleBondedNegativeOxygenCount = 0;
        int doubleBondedOxygenCount = 0;
        for (IBond cBond : container.getConnectedBondsList(carbon)) {
            IAtom neighbor = cBond.getConnectedAtom(carbon);
            if (!"O".equals(neighbor.getSymbol())) continue;
            ++oxygenCount;
            IBond.Order order = cBond.getOrder();
            Integer charge = neighbor.getFormalCharge();
            if (order == IBond.Order.SINGLE && charge != null && charge == -1) {
                ++singleBondedNegativeOxygenCount;
                continue;
            }
            if (order != IBond.Order.DOUBLE) continue;
            ++doubleBondedOxygenCount;
        }
        return oxygenCount == 2 && singleBondedNegativeOxygenCount == 1 && doubleBondedOxygenCount == 1;
    }

    private boolean atLeastTwoNeighborsAreSp2(IAtom atom, IAtomContainer atomContainer) {
        int count = 0;
        Iterator<IAtom> atoms = atomContainer.getConnectedAtomsList(atom).iterator();
        while (atoms.hasNext() && count < 2) {
            IAtom nextAtom = atoms.next();
            if (nextAtom.getSymbol().equals("H")) continue;
            if (nextAtom.getHybridization() != CDKConstants.UNSET && nextAtom.getHybridization() == IAtomType.Hybridization.SP2) {
                ++count;
                continue;
            }
            if (this.countAttachedDoubleBonds(atomContainer, nextAtom) <= 0) continue;
            ++count;
        }
        return count >= 2;
    }

    private boolean bothNeighborsAreSp2(IAtom atom, IAtomContainer atomContainer) {
        return this.atLeastTwoNeighborsAreSp2(atom, atomContainer);
    }

    private IAtomType perceiveNitrogenRadicals(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (atomContainer.getConnectedBondsCount(atom) >= 1 && atomContainer.getConnectedBondsCount(atom) <= 2) {
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                IAtomType type;
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type2 = this.getAtomType("N.plus.sp2.radical");
                    if (this.isAcceptable(atom, atomContainer, type2)) {
                        return type2;
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.plus.sp3.radical"))) {
                    return type;
                }
            } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                IAtomType type;
                if (maxBondOrder == IBond.Order.SINGLE) {
                    IAtomType type3 = this.getAtomType("N.sp3.radical");
                    if (this.isAcceptable(atom, atomContainer, type3)) {
                        return type3;
                    }
                } else if (maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp2.radical"))) {
                    return type;
                }
            }
        } else {
            IAtomType type;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.plus.sp3.radical"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveNitrogens(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return this.perceiveNitrogenRadicals(atomContainer, atom);
        }
        if (this.hasHybridization(atom) && !this.isCharged(atom)) {
            if (atom.getHybridization() == IAtomType.Hybridization.SP1) {
                int neighborCount = atomContainer.getConnectedAtomsCount(atom);
                if (neighborCount > 1) {
                    IAtomType type = this.getAtomType("N.sp1.2");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else {
                    IAtomType type = this.getAtomType("N.sp1");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP2) {
                IAtomType type;
                IAtomType type2;
                if (this.isAmide(atom, atomContainer) ? this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("N.amide")) : this.isThioAmide(atom, atomContainer) && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("N.thioamide"))) {
                    return type2;
                }
                int neighborCount = atomContainer.getConnectedAtomsCount(atom);
                if (neighborCount == 4 && IBond.Order.DOUBLE == atomContainer.getMaximumBondOrder(atom)) {
                    type = this.getAtomType("N.oxide");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else if (neighborCount > 1 && this.bothNeighborsAreSp2(atom, atomContainer)) {
                    int ringSize;
                    IRing ring = this.getRing(atom, atomContainer);
                    int n = ringSize = ring == null ? 0 : ring.getAtomCount();
                    if (ring != null && ring.getAtomCount() > 0) {
                        if (neighborCount == 3) {
                            IAtomType type3;
                            IBond.Order maxOrder = atomContainer.getMaximumBondOrder(atom);
                            if (maxOrder == IBond.Order.DOUBLE) {
                                IAtomType type4 = this.getAtomType("N.sp2.3");
                                if (this.isAcceptable(atom, atomContainer, type4)) {
                                    return type4;
                                }
                            } else if (maxOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("N.planar3"))) {
                                return type3;
                            }
                        } else if (neighborCount == 2) {
                            IAtomType type5;
                            IBond.Order maxOrder = atomContainer.getMaximumBondOrder(atom);
                            if (maxOrder == IBond.Order.SINGLE) {
                                if (atom.getImplicitHydrogenCount() != CDKConstants.UNSET && atom.getImplicitHydrogenCount() == 1) {
                                    IAtomType type6 = this.getAtomType("N.planar3");
                                    if (this.isAcceptable(atom, atomContainer, type6)) {
                                        return type6;
                                    }
                                } else {
                                    IAtomType type7 = this.getAtomType("N.sp2");
                                    if (this.isAcceptable(atom, atomContainer, type7)) {
                                        return type7;
                                    }
                                }
                            } else if (maxOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type5 = this.getAtomType("N.sp2"))) {
                                return type5;
                            }
                        }
                    }
                }
                if (this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp2"))) {
                    return type;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.SP3) {
                IAtomType type = this.getAtomType("N.sp3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atom.getHybridization() == IAtomType.Hybridization.PLANAR3) {
                IAtomType type;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (atomContainer.getConnectedAtomsCount(atom) == 3 && maxBondOrder == CDKConstants.BONDORDER_DOUBLE && this.countAttachedDoubleBonds(atomContainer, atom, "O") == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.nitro"))) {
                    return type;
                }
                type = this.getAtomType("N.planar3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        } else if (this.isCharged(atom)) {
            if (atom.getFormalCharge() == 1) {
                IAtomType type;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == CDKConstants.BONDORDER_SINGLE || atomContainer.getConnectedBondsCount(atom) == 0) {
                    IAtomType type8;
                    if (atom.getHybridization() == IAtomType.Hybridization.SP2 && this.isAcceptable(atom, atomContainer, type8 = this.getAtomType("N.plus.sp2"))) {
                        return type8;
                    }
                    type8 = this.getAtomType("N.plus");
                    if (this.isAcceptable(atom, atomContainer, type8)) {
                        return type8;
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                    IAtomType type9;
                    int doubleBonds = this.countAttachedDoubleBonds(atomContainer, atom);
                    if (doubleBonds == 1) {
                        IAtomType type10 = this.getAtomType("N.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type10)) {
                            return type10;
                        }
                    } else if (doubleBonds == 2 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("N.plus.sp1"))) {
                        return type9;
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_TRIPLE && atomContainer.getConnectedBondsCount(atom) == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.plus.sp1"))) {
                    return type;
                }
            } else if (atom.getFormalCharge() == -1) {
                IAtomType type;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == CDKConstants.BONDORDER_SINGLE) {
                    IAtomType type11;
                    if (atomContainer.getConnectedAtomsCount(atom) >= 2 && this.bothNeighborsAreSp2(atom, atomContainer) && this.isRingAtom(atom, atomContainer)) {
                        IAtomType type12 = this.getAtomType("N.minus.planar3");
                        if (this.isAcceptable(atom, atomContainer, type12)) {
                            return type12;
                        }
                    } else if (atomContainer.getConnectedBondsCount(atom) <= 2 && this.isAcceptable(atom, atomContainer, type11 = this.getAtomType("N.minus.sp3"))) {
                        return type11;
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE && atomContainer.getConnectedBondsCount(atom) <= 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.minus.sp2"))) {
                    return type;
                }
            }
        } else {
            if (atomContainer.getConnectedBondsCount(atom) > 3) {
                IAtomType type;
                if (atomContainer.getConnectedBondsCount(atom) == 4 && this.countAttachedDoubleBonds(atomContainer, atom) == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.oxide"))) {
                    return type;
                }
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type = this.getAtomType("N.sp3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == CDKConstants.BONDORDER_SINGLE) {
                    IAtomType type;
                    IAtomType type13;
                    if (this.isAmide(atom, atomContainer) ? this.isAcceptable(atom, atomContainer, type13 = this.getAtomType("N.amide")) : this.isThioAmide(atom, atomContainer) && this.isAcceptable(atom, atomContainer, type13 = this.getAtomType("N.thioamide"))) {
                        return type13;
                    }
                    int explicitHydrogens = this.countExplicitHydrogens(atom, atomContainer);
                    int connectedHeavyAtoms = atomContainer.getConnectedBondsCount(atom) - explicitHydrogens;
                    if (connectedHeavyAtoms == 2) {
                        List<IBond> bonds = atomContainer.getConnectedBondsList(atom);
                        if (bonds.get(0).getFlag(5) && bonds.get(1).getFlag(5)) {
                            IAtomType type14;
                            Integer hCount = atom.getImplicitHydrogenCount();
                            if (hCount == CDKConstants.UNSET || hCount == 0) {
                                IAtomType type15 = this.getAtomType("N.sp2");
                                if (this.isAcceptable(atom, atomContainer, type15)) {
                                    return type15;
                                }
                            } else if (hCount == 1 && this.isAcceptable(atom, atomContainer, type14 = this.getAtomType("N.planar3"))) {
                                return type14;
                            }
                        } else if (this.bothNeighborsAreSp2(atom, atomContainer) && this.isRingAtom(atom, atomContainer)) {
                            IAtomType type16 = this.getAtomType("N.planar3");
                            if (this.isAcceptable(atom, atomContainer, type16)) {
                                return type16;
                            }
                        } else {
                            IAtomType type17 = this.getAtomType("N.sp3");
                            if (this.isAcceptable(atom, atomContainer, type17)) {
                                return type17;
                            }
                        }
                    } else if (connectedHeavyAtoms == 3) {
                        IAtomType type18;
                        if (this.bothNeighborsAreSp2(atom, atomContainer) && this.isRingAtom(atom, atomContainer) && this.isAcceptable(atom, atomContainer, type18 = this.getAtomType("N.planar3"))) {
                            return type18;
                        }
                        type18 = this.getAtomType("N.sp3");
                        if (this.isAcceptable(atom, atomContainer, type18)) {
                            return type18;
                        }
                    } else if (connectedHeavyAtoms == 1) {
                        IAtomType type19 = this.getAtomType("N.sp3");
                        if (this.isAcceptable(atom, atomContainer, type19)) {
                            return type19;
                        }
                    } else if (connectedHeavyAtoms == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp3"))) {
                        return type;
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                    IAtomType type;
                    if (atomContainer.getConnectedAtomsCount(atom) == 3 && this.countAttachedDoubleBonds(atomContainer, atom, "O") == 2 ? this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.nitro")) : atomContainer.getConnectedAtomsCount(atom) == 3 && this.countAttachedDoubleBonds(atomContainer, atom) > 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("N.sp2.3"))) {
                        return type;
                    }
                    type = this.getAtomType("N.sp2");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_TRIPLE) {
                    int neighborCount = atomContainer.getConnectedAtomsCount(atom);
                    if (neighborCount > 1) {
                        IAtomType type = this.getAtomType("N.sp1.2");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    } else {
                        IAtomType type = this.getAtomType("N.sp1");
                        if (this.isAcceptable(atom, atomContainer, type)) {
                            return type;
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean isRingAtom(IAtom atom, IAtomContainer atomContainer) {
        SpanningTree st = new SpanningTree(atomContainer);
        return st.getCyclicFragmentsContainer().contains(atom);
    }

    private IRing getRing(IAtom atom, IAtomContainer atomContainer) {
        SpanningTree st = new SpanningTree(atomContainer);
        try {
            if (st.getCyclicFragmentsContainer().contains(atom)) {
                IRingSet set = st.getAllRings();
                for (int i = 0; i < set.getAtomContainerCount(); ++i) {
                    IRing ring = (IRing)set.getAtomContainer(i);
                    if (!ring.contains(atom)) continue;
                    return ring;
                }
            }
        }
        catch (NoSuchAtomException exception) {
            return null;
        }
        return null;
    }

    private boolean isAmide(IAtom atom, IAtomContainer atomContainer) {
        List<IAtom> neighbors = atomContainer.getConnectedAtomsList(atom);
        for (IAtom neighbor : neighbors) {
            if (!neighbor.getSymbol().equals("C") || this.countAttachedDoubleBonds(atomContainer, neighbor, "O") != 1) continue;
            return true;
        }
        return false;
    }

    private boolean isThioAmide(IAtom atom, IAtomContainer atomContainer) {
        List<IAtom> neighbors = atomContainer.getConnectedAtomsList(atom);
        for (IAtom neighbor : neighbors) {
            if (!neighbor.getSymbol().equals("C") || this.countAttachedDoubleBonds(atomContainer, neighbor, "S") != 1) continue;
            return true;
        }
        return false;
    }

    private int countExplicitHydrogens(IAtom atom, IAtomContainer atomContainer) {
        int count = 0;
        for (IAtom aAtom : atomContainer.getConnectedAtomsList(atom)) {
            if (!aAtom.getSymbol().equals("H")) continue;
            ++count;
        }
        return count;
    }

    private IAtomType perceiveSulphurs(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        List<IBond> neighbors = atomContainer.getConnectedBondsList(atom);
        int neighborcount = neighbors.size();
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getHybridization() != CDKConstants.UNSET && atom.getHybridization() == IAtomType.Hybridization.SP2 && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            if (neighborcount == 3) {
                IAtomType type = this.getAtomType("S.inyl.charged");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type = this.getAtomType("S.plus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0) {
            IAtomType type;
            if (atom.getFormalCharge() == -1 && neighborcount == 1) {
                IAtomType type2 = this.getAtomType("S.minus");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() == 1 && neighborcount == 2) {
                IAtomType type3 = this.getAtomType("S.plus");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atom.getFormalCharge() == 1 && neighborcount == 3) {
                IAtomType type4 = this.getAtomType("S.inyl.charged");
                if (this.isAcceptable(atom, atomContainer, type4)) {
                    return type4;
                }
            } else if (atom.getFormalCharge() == 2 && neighborcount == 4 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("S.onyl.charged"))) {
                return type;
            }
        } else if (neighborcount == 6) {
            IAtomType type;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == CDKConstants.BONDORDER_SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("S.octahedral"))) {
                return type;
            }
        } else if (neighborcount == 6) {
            IAtomType type;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == CDKConstants.BONDORDER_SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("S.octahedral"))) {
                return type;
            }
        } else if (neighborcount == 2) {
            if (this.isRingAtom(atom, atomContainer) && this.bothNeighborsAreSp2(atom, atomContainer)) {
                IAtomType type = this.getAtomType("S.planar3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (this.countAttachedDoubleBonds(atomContainer, atom, "O") == 2) {
                IAtomType type = this.getAtomType("S.oxide");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (this.countAttachedDoubleBonds(atomContainer, atom) == 2) {
                IAtomType type = this.getAtomType("S.inyl.2");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type = this.getAtomType("S.3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        } else if (neighborcount == 1) {
            if (atomContainer.getConnectedBondsList(atom).get(0).getOrder() == CDKConstants.BONDORDER_DOUBLE) {
                IAtomType type = this.getAtomType("S.2");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type = this.getAtomType("S.3");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            }
        } else if (neighborcount == 0) {
            IAtomType type = this.getAtomType("S.3");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (neighborcount == 3) {
            IAtomType type;
            int doubleBondedAtoms = this.countAttachedDoubleBonds(atomContainer, atom);
            if (doubleBondedAtoms == 1) {
                IAtomType type5 = this.getAtomType("S.inyl");
                if (this.isAcceptable(atom, atomContainer, type5)) {
                    return type5;
                }
            } else if (doubleBondedAtoms == 3) {
                IAtomType type6 = this.getAtomType("S.trioxide");
                if (this.isAcceptable(atom, atomContainer, type6)) {
                    return type6;
                }
            } else if (doubleBondedAtoms == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("S.anyl"))) {
                return type;
            }
        } else if (neighborcount == 4) {
            IAtomType type;
            IAtomType type7;
            IAtomType type8;
            int doubleBondedNitrogens;
            int doubleBondedOxygens = this.countAttachedDoubleBonds(atomContainer, atom, "O");
            if (doubleBondedOxygens + (doubleBondedNitrogens = this.countAttachedDoubleBonds(atomContainer, atom, "N")) == 2 && this.isAcceptable(atom, atomContainer, type8 = this.getAtomType("S.onyl"))) {
                return type8;
            }
            int doubleBondedSulphurs = this.countAttachedDoubleBonds(atomContainer, atom, "S");
            if (doubleBondedSulphurs == 1 && doubleBondedOxygens == 1 && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("S.thionyl"))) {
                return type7;
            }
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == CDKConstants.BONDORDER_SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("S.anyl"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceivePhosphors(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        List<IBond> neighbors = atomContainer.getConnectedBondsList(atom);
        int neighborcount = neighbors.size();
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        if (this.countSingleElectrons(atomContainer, atom) == 3) {
            IAtomType type = this.getAtomType("P.se.3");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (neighborcount == 0) {
                IAtomType type2;
                if ((atom.getFormalCharge() == null || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("P.ine"))) {
                    return type2;
                }
            } else if (neighborcount == 1) {
                IAtomType type3;
                if ((atom.getFormalCharge() == null || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("P.ide"))) {
                    return type3;
                }
            } else if (neighborcount == 3) {
                int doubleBonds = this.countAttachedDoubleBonds(atomContainer, atom);
                if (atom.getFormalCharge() != null & atom.getFormalCharge() == 1) {
                    IAtomType type4 = this.getAtomType("P.anium");
                    if (this.isAcceptable(atom, atomContainer, type4)) {
                        return type4;
                    }
                } else if (doubleBonds == 1) {
                    IAtomType type5 = this.getAtomType("P.ate");
                    if (this.isAcceptable(atom, atomContainer, type5)) {
                        return type5;
                    }
                } else {
                    IAtomType type6 = this.getAtomType("P.ine");
                    if (this.isAcceptable(atom, atomContainer, type6)) {
                        return type6;
                    }
                }
            } else if (neighborcount == 2) {
                IAtomType type7;
                if (maxBondOrder == CDKConstants.BONDORDER_DOUBLE) {
                    if (atom.getFormalCharge() != null & atom.getFormalCharge() == 1) {
                        IAtomType type8 = this.getAtomType("P.sp1.plus");
                        if (this.isAcceptable(atom, atomContainer, type8)) {
                            return type8;
                        }
                    } else {
                        IAtomType type9 = this.getAtomType("P.irane");
                        if (this.isAcceptable(atom, atomContainer, type9)) {
                            return type9;
                        }
                    }
                } else if (maxBondOrder == CDKConstants.BONDORDER_SINGLE && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("P.ine"))) {
                    return type7;
                }
            } else if (neighborcount == 4) {
                IAtomType type10;
                int doubleBonds = this.countAttachedDoubleBonds(atomContainer, atom);
                if (atom.getFormalCharge() == 1 && doubleBonds == 0) {
                    IAtomType type11 = this.getAtomType("P.ate.charged");
                    if (this.isAcceptable(atom, atomContainer, type11)) {
                        return type11;
                    }
                } else if (doubleBonds == 1 && this.isAcceptable(atom, atomContainer, type10 = this.getAtomType("P.ate"))) {
                    return type10;
                }
            } else if (neighborcount == 5 && (atom.getFormalCharge() == null || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("P.ane"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveHydrogens(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        int neighborcount = atomContainer.getConnectedBondsCount(atom);
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && neighborcount == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("H.radical"))) {
                return type;
            }
            return null;
        }
        if (neighborcount == 2) {
            return null;
        }
        if (neighborcount == 1) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("H"))) {
                return type;
            }
        } else if (neighborcount == 0) {
            IAtomType type;
            if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                IAtomType type2 = this.getAtomType("H");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() == 1) {
                IAtomType type3 = this.getAtomType("H.plus");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atom.getFormalCharge() == -1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("H.minus"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveLithium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        int neighborcount = atomContainer.getConnectedBondsCount(atom);
        if (neighborcount == 1) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Li"))) {
                return type;
            }
        } else if (neighborcount == 0) {
            IAtomType type;
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Li.neutral"))) {
                return type;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 1) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Li.plus"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveHalogens(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("Cl".equals(atom.getSymbol())) {
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                IAtomType type;
                IBond.Order maxBondOrder;
                if (atomContainer.getConnectedBondsCount(atom) == 0) {
                    IAtomType type2;
                    if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                        IAtomType type3 = this.getAtomType("Cl.plus.radical");
                        if (this.isAcceptable(atom, atomContainer, type3)) {
                            return type3;
                        }
                    } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Cl.radical"))) {
                        return type2;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) <= 1 && (maxBondOrder = atomContainer.getMaximumBondOrder(atom)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl.plus.radical"))) {
                    return type;
                }
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -1) {
                IAtomType type = this.getAtomType("Cl.minus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                IAtomType type;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type4 = this.getAtomType("Cl.plus.sp2");
                    if (this.isAcceptable(atom, atomContainer, type4)) {
                        return type4;
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl.plus.sp3"))) {
                    return type;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3 && atomContainer.getConnectedBondsCount(atom) == 4) {
                IAtomType type = this.getAtomType("Cl.perchlorate.charged");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) == 1 || atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type = this.getAtomType("Cl");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else {
                IAtomType type;
                int doubleBonds = this.countAttachedDoubleBonds(atomContainer, atom);
                if (atomContainer.getConnectedBondsCount(atom) == 3 && doubleBonds == 2) {
                    IAtomType type5 = this.getAtomType("Cl.chlorate");
                    if (this.isAcceptable(atom, atomContainer, type5)) {
                        return type5;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) == 4 && doubleBonds == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cl.perchlorate"))) {
                    return type;
                }
            }
        } else if ("Br".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                IAtomType type6;
                IBond.Order maxBondOrder;
                if (atomContainer.getConnectedBondsCount(atom) == 0) {
                    IAtomType type7;
                    if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                        IAtomType type8 = this.getAtomType("Br.plus.radical");
                        if (this.isAcceptable(atom, atomContainer, type8)) {
                            return type8;
                        }
                    } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("Br.radical"))) {
                        return type7;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) <= 1 && (maxBondOrder = atomContainer.getMaximumBondOrder(atom)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type6 = this.getAtomType("Br.plus.radical"))) {
                    return type6;
                }
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -1) {
                IAtomType type9 = this.getAtomType("Br.minus");
                if (this.isAcceptable(atom, atomContainer, type9)) {
                    return type9;
                }
            } else if (atom.getFormalCharge() == 1) {
                IAtomType type10;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type11 = this.getAtomType("Br.plus.sp2");
                    if (this.isAcceptable(atom, atomContainer, type11)) {
                        return type11;
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type10 = this.getAtomType("Br.plus.sp3"))) {
                    return type10;
                }
            } else if ((atomContainer.getConnectedBondsCount(atom) == 1 || atomContainer.getConnectedBondsCount(atom) == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Br"))) {
                return type;
            }
        } else if ("F".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                IAtomType type12;
                IBond.Order maxBondOrder;
                if (atomContainer.getConnectedBondsCount(atom) == 0) {
                    IAtomType type13;
                    if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                        IAtomType type14 = this.getAtomType("F.plus.radical");
                        if (this.isAcceptable(atom, atomContainer, type14)) {
                            return type14;
                        }
                    } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type13 = this.getAtomType("F.radical"))) {
                        return type13;
                    }
                } else if (atomContainer.getConnectedBondsCount(atom) <= 1 && (maxBondOrder = atomContainer.getMaximumBondOrder(atom)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type12 = this.getAtomType("F.plus.radical"))) {
                    return type12;
                }
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0) {
                if (atom.getFormalCharge() == -1) {
                    IAtomType type15 = this.getAtomType("F.minus");
                    if (this.isAcceptable(atom, atomContainer, type15)) {
                        return type15;
                    }
                } else if (atom.getFormalCharge() == 1) {
                    IAtomType type16;
                    IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                    if (maxBondOrder == IBond.Order.DOUBLE) {
                        IAtomType type17 = this.getAtomType("F.plus.sp2");
                        if (this.isAcceptable(atom, atomContainer, type17)) {
                            return type17;
                        }
                    } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type16 = this.getAtomType("F.plus.sp3"))) {
                        return type16;
                    }
                }
            } else if ((atomContainer.getConnectedBondsCount(atom) == 1 || atomContainer.getConnectedBondsCount(atom) == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("F"))) {
                return type;
            }
        } else if ("I".equals(atom.getSymbol())) {
            return this.perceiveIodine(atomContainer, atom);
        }
        return null;
    }

    private IAtomType perceiveArsenic(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1 && atomContainer.getConnectedBondsCount(atom) <= 4) {
            IAtomType type2 = this.getAtomType("As.plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type3;
            int neighbors = atomContainer.getConnectedAtomsCount(atom);
            if (neighbors == 4 && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("As.5"))) {
                return type3;
            }
            if (neighbors == 2 && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("As.2"))) {
                return type3;
            }
            type3 = this.getAtomType("As");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3) {
            IAtomType type4 = this.getAtomType("As.3plus");
            if (this.isAcceptable(atom, atomContainer, type4)) {
                return type4;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("As.minus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveCommonSalts(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("Ca".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ca.2plus"))) {
                return type;
            }
        } else if ("Mg".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Mg.2plus"))) {
                return type;
            }
        } else if ("Fe".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Fe.2plus"))) {
                return type;
            }
        } else if ("Co".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
                IAtomType type2 = this.getAtomType("Co.2plus");
                if (this.isAcceptable(atom, atomContainer, type2)) {
                    return type2;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3) {
                IAtomType type3 = this.getAtomType("Co.3plus");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Co.metallic"))) {
                return type;
            }
        } else if ("Cu".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cu.2plus"))) {
                return type;
            }
        } else if ("Pt".equals(atom.getSymbol())) {
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
                IAtomType type = this.getAtomType("Pt.2plus");
                if (this.isAcceptable(atom, atomContainer, type)) {
                    return type;
                }
            } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                IAtomType type;
                int neighbors = atomContainer.getConnectedAtomsCount(atom);
                if (neighbors == 4) {
                    IAtomType type4 = this.getAtomType("Pt.4");
                    if (this.isAcceptable(atom, atomContainer, type4)) {
                        return type4;
                    }
                } else if (neighbors == 6 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Pt.6"))) {
                    return type;
                }
            }
        } else if ("Ni".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 2) {
                IAtomType type5 = this.getAtomType("Ni.2plus");
                if (this.isAcceptable(atom, atomContainer, type5)) {
                    return type5;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedAtomsCount(atom) <= 2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ni"))) {
                return type;
            }
        } else if ("W".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("W.metallic"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveOrganometallicCenters(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if ("Hg".equals(atom.getSymbol())) {
            IAtomType type2;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -1 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Hg.minus"))) {
                return type2;
            }
        } else if ("Po".equals(atom.getSymbol())) {
            IAtomType type3;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) == 2 && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("Po"))) {
                return type3;
            }
        } else if ("Zn".equals(atom.getSymbol())) {
            IAtomType type4;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atomContainer.getConnectedBondsCount(atom) == 2 && (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0)) {
                IAtomType type5 = this.getAtomType("Zn");
                if (this.isAcceptable(atom, atomContainer, type5)) {
                    return type5;
                }
            } else if ((atom.getFormalCharge() != CDKConstants.UNSET || atom.getFormalCharge() == 2) && this.isAcceptable(atom, atomContainer, type4 = this.getAtomType("Zn.2plus"))) {
                return type4;
            }
        } else if ("Sn".equals(atom.getSymbol())) {
            IAtomType type6;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) <= 4 && this.isAcceptable(atom, atomContainer, type6 = this.getAtomType("Sn.sp3"))) {
                return type6;
            }
        } else if ("Ti".equals(atom.getSymbol())) {
            IAtomType type7;
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6) {
                IAtomType type8 = this.getAtomType("Ti.3minus");
                if (this.isAcceptable(atom, atomContainer, type8)) {
                    return type8;
                }
            } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && atomContainer.getConnectedBondsCount(atom) == 4 && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("Ti.sp3"))) {
                return type7;
            }
        } else if ("V".equals(atom.getSymbol())) {
            IAtomType type9;
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("V.3minus"))) {
                return type9;
            }
        } else if ("Al".equals(atom.getSymbol())) {
            IAtomType type10;
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 3 && atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type11 = this.getAtomType("Al.3plus");
                if (this.isAcceptable(atom, atomContainer, type11)) {
                    return type11;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 3 && this.isAcceptable(atom, atomContainer, type10 = this.getAtomType("Al"))) {
                return type10;
            }
        } else if ("Sc".equals(atom.getSymbol())) {
            IAtomType type12;
            if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -3 && atomContainer.getConnectedBondsCount(atom) == 6 && this.isAcceptable(atom, atomContainer, type12 = this.getAtomType("Sc.3minus"))) {
                return type12;
            }
        } else if ("Cr".equals(atom.getSymbol()) && atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedBondsCount(atom) == 6 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Cr"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveNobelGases(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if ("He".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("He"))) {
                return type;
            }
        } else if ("Ne".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ne"))) {
                return type;
            }
        } else if ("Ar".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Ar"))) {
                return type;
            }
        } else if ("Kr".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Kr"))) {
                return type;
            }
        } else if ("Xe".equals(atom.getSymbol())) {
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
                if (atomContainer.getConnectedBondsCount(atom) == 0) {
                    IAtomType type = this.getAtomType("Xe");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                } else {
                    IAtomType type = this.getAtomType("Xe.3");
                    if (this.isAcceptable(atom, atomContainer, type)) {
                        return type;
                    }
                }
            }
        } else if ("Rn".equals(atom.getSymbol())) {
            IAtomType type;
            if (this.hasOneSingleElectron(atomContainer, atom)) {
                return null;
            }
            if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Rn"))) {
                return type;
            }
        }
        return null;
    }

    private IAtomType perceiveSilicon(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0) {
            IAtomType type2;
            if (atomContainer.getConnectedBondsCount(atom) == 2) {
                IAtomType type3 = this.getAtomType("Si.2");
                if (this.isAcceptable(atom, atomContainer, type3)) {
                    return type3;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) == 3) {
                IAtomType type4 = this.getAtomType("Si.3");
                if (this.isAcceptable(atom, atomContainer, type4)) {
                    return type4;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) == 4 && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("Si.sp3"))) {
                return type2;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == -2 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Si.2minus.6"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveManganese(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() == 0) {
            IAtomType type03;
            int neighbors = atomContainer.getConnectedAtomsCount(atom);
            if (neighbors == 2) {
                IAtomType type02 = this.getAtomType("Mn.2");
                if (this.isAcceptable(atom, atomContainer, type02)) {
                    return type02;
                }
            } else if (neighbors == 0 && this.isAcceptable(atom, atomContainer, type03 = this.getAtomType("Mn.metallic"))) {
                return type03;
            }
        } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 2) {
            IAtomType type2 = this.getAtomType("Mn.2plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if (atom.getFormalCharge() != null && atom.getFormalCharge() == 3 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Mn.3plus"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveSodium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            IAtomType type2 = this.getAtomType("Na.plus");
            if (this.isAcceptable(atom, atomContainer, type2)) {
                return type2;
            }
        } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && atomContainer.getConnectedAtomsCount(atom) == 1) {
            IAtomType type3 = this.getAtomType("Na");
            if (this.isAcceptable(atom, atomContainer, type3)) {
                return type3;
            }
        } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && atomContainer.getConnectedAtomsCount(atom) == 0 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("Na.neutral"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceiveIodine(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType type;
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            IAtomType type2;
            IBond.Order maxBondOrder;
            if (atomContainer.getConnectedBondsCount(atom) == 0) {
                IAtomType type3;
                if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
                    IAtomType type4 = this.getAtomType("I.plus.radical");
                    if (this.isAcceptable(atom, atomContainer, type4)) {
                        return type4;
                    }
                } else if ((atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) && this.isAcceptable(atom, atomContainer, type3 = this.getAtomType("I.radical"))) {
                    return type3;
                }
            } else if (atomContainer.getConnectedBondsCount(atom) <= 1 && (maxBondOrder = atomContainer.getMaximumBondOrder(atom)) == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type2 = this.getAtomType("I.plus.radical"))) {
                return type2;
            }
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() != 0) {
            if (atom.getFormalCharge() == -1) {
                if (atomContainer.getConnectedAtomsCount(atom) == 0) {
                    IAtomType type5 = this.getAtomType("I.minus");
                    if (this.isAcceptable(atom, atomContainer, type5)) {
                        return type5;
                    }
                } else {
                    IAtomType type6 = this.getAtomType("I.minus.5");
                    if (this.isAcceptable(atom, atomContainer, type6)) {
                        return type6;
                    }
                }
            } else if (atom.getFormalCharge() == 1) {
                IAtomType type7;
                IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
                if (maxBondOrder == IBond.Order.DOUBLE) {
                    IAtomType type8 = this.getAtomType("I.plus.sp2");
                    if (this.isAcceptable(atom, atomContainer, type8)) {
                        return type8;
                    }
                } else if (maxBondOrder == IBond.Order.SINGLE && this.isAcceptable(atom, atomContainer, type7 = this.getAtomType("I.plus.sp3"))) {
                    return type7;
                }
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 3) {
            IAtomType type9;
            int doubleBondCount = this.countAttachedDoubleBonds(atomContainer, atom);
            if (doubleBondCount == 2) {
                IAtomType type10 = this.getAtomType("I.5");
                if (this.isAcceptable(atom, atomContainer, type10)) {
                    return type10;
                }
            } else if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 0 && this.isAcceptable(atom, atomContainer, type9 = this.getAtomType("I.sp3d2.3"))) {
                return type9;
            }
        } else if (atomContainer.getConnectedBondsCount(atom) == 2) {
            IAtomType type11;
            IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
            if (maxBondOrder == IBond.Order.DOUBLE && this.isAcceptable(atom, atomContainer, type11 = this.getAtomType("I.3"))) {
                return type11;
            }
        } else if ((atomContainer.getConnectedBondsCount(atom) == 1 || atomContainer.getConnectedBondsCount(atom) == 0) && this.isAcceptable(atom, atomContainer, type = this.getAtomType("I"))) {
            return type;
        }
        return null;
    }

    private IAtomType perceivePotassium(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        if (this.hasOneSingleElectron(atomContainer, atom)) {
            return null;
        }
        if (atom.getFormalCharge() != CDKConstants.UNSET && atom.getFormalCharge() == 1) {
            IAtomType type = this.getAtomType("K.plus");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        } else if (atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge() == 0) {
            IAtomType type;
            int neighbors = atomContainer.getConnectedAtomsCount(atom);
            if (neighbors == 1 && this.isAcceptable(atom, atomContainer, type = this.getAtomType("K.neutral"))) {
                return type;
            }
            type = this.getAtomType("K.metallic");
            if (this.isAcceptable(atom, atomContainer, type)) {
                return type;
            }
        }
        return null;
    }

    private int countAttachedDoubleBonds(IAtomContainer container, IAtom atom) {
        return this.countAttachedDoubleBonds(container, atom, null);
    }

    private boolean hasAromaticBond(IAtomContainer container, IAtom atom) {
        List<IBond> neighbors = container.getConnectedBondsList(atom);
        for (IBond bond : neighbors) {
            if (!bond.getFlag(5)) continue;
            return true;
        }
        return false;
    }

    private int countAttachedDoubleBonds(IAtomContainer container, IAtom atom, String symbol) {
        List<IBond> neighbors = container.getConnectedBondsList(atom);
        int neighborcount = neighbors.size();
        int doubleBondedAtoms = 0;
        for (int i = neighborcount - 1; i >= 0; --i) {
            IBond bond = neighbors.get(i);
            if (bond.getOrder() != CDKConstants.BONDORDER_DOUBLE || bond.getAtomCount() != 2 || !bond.contains(atom)) continue;
            if (symbol != null) {
                if ((bond.getAtom(0) == atom || !bond.getAtom(0).getSymbol().equals(symbol)) && (bond.getAtom(1) == atom || !bond.getAtom(1).getSymbol().equals(symbol))) continue;
                ++doubleBondedAtoms;
                continue;
            }
            ++doubleBondedAtoms;
        }
        return doubleBondedAtoms;
    }

    private IAtomType getAtomType(String identifier) throws CDKException {
        IAtomType type = this.factory.getAtomType(identifier);
        type.setValency((Integer)type.getProperty("cdk:Pi Bond Count") + type.getFormalNeighbourCount());
        return type;
    }

    private boolean isAcceptable(IAtom atom, IAtomContainer container, IAtomType type) {
        int requiredNeighbourCount;
        int hCount;
        int connectedAtoms;
        int actualNeighbourCount;
        int requiredContainerCount;
        int actualContainerCount;
        if (this.mode == 2 ? (actualContainerCount = container.getConnectedAtomsCount(atom)) != (requiredContainerCount = type.getFormalNeighbourCount().intValue()) : atom.getImplicitHydrogenCount() != CDKConstants.UNSET && (actualNeighbourCount = (connectedAtoms = container.getConnectedAtomsCount(atom)) + (hCount = atom.getImplicitHydrogenCount().intValue())) > (requiredNeighbourCount = type.getFormalNeighbourCount().intValue())) {
            return false;
        }
        if (type.getProperty("cdk:Pi Bond Count") != null && container.getMaximumBondOrder(atom).ordinal() + 1 > (Integer)type.getProperty("cdk:Pi Bond Count") + 1) {
            return false;
        }
        if (type.getValency() != CDKConstants.UNSET && container.getBondOrderSum(atom) > (double)type.getValency().intValue()) {
            return false;
        }
        return atom.getFormalCharge() == CDKConstants.UNSET || atom.getFormalCharge().equals(type.getFormalCharge());
    }

    private boolean isHueckelNumber(int electronCount) {
        return electronCount % 4 == 2 && electronCount >= 2;
    }
}

