/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.silent.ChemObject;
import org.openscience.cdk.silent.Mapping;
import org.openscience.cdk.silent.Molecule;
import org.openscience.cdk.silent.MoleculeSet;

public class Reaction
extends ChemObject
implements Serializable,
IReaction,
Cloneable {
    private static final long serialVersionUID = -554752558363533678L;
    protected int growArraySize = 3;
    protected IMoleculeSet reactants = new MoleculeSet();
    protected IMoleculeSet products = new MoleculeSet();
    protected IMoleculeSet agents = new MoleculeSet();
    protected IMapping[] map = new Mapping[this.growArraySize];
    protected int mappingCount = 0;
    private IReaction.Direction reactionDirection = IReaction.Direction.FORWARD;

    @Override
    public int getReactantCount() {
        return this.reactants.getAtomContainerCount();
    }

    @Override
    public int getProductCount() {
        return this.products.getAtomContainerCount();
    }

    @Override
    public IMoleculeSet getReactants() {
        return this.reactants;
    }

    @Override
    public void setReactants(IMoleculeSet setOfMolecules) {
        this.reactants = setOfMolecules;
    }

    @Override
    public IMoleculeSet getProducts() {
        return this.products;
    }

    @Override
    public void setProducts(IMoleculeSet setOfMolecules) {
        this.products = setOfMolecules;
    }

    @Override
    public IMoleculeSet getAgents() {
        return this.agents;
    }

    @Override
    public Iterable<IMapping> mappings() {
        return new Iterable<IMapping>(){

            @Override
            public Iterator<IMapping> iterator() {
                return new MappingIterator();
            }
        };
    }

    @Override
    public void addReactant(IMolecule reactant) {
        this.addReactant(reactant, 1.0);
    }

    @Override
    public void addAgent(IMolecule agent) {
        this.agents.addAtomContainer(agent);
    }

    @Override
    public void addReactant(IMolecule reactant, Double coefficient) {
        this.reactants.addAtomContainer(reactant, coefficient);
    }

    @Override
    public void addProduct(IMolecule product) {
        this.addProduct(product, 1.0);
    }

    @Override
    public void addProduct(IMolecule product, Double coefficient) {
        this.products.addAtomContainer(product, coefficient);
    }

    @Override
    public Double getReactantCoefficient(IMolecule reactant) {
        return this.reactants.getMultiplier(reactant);
    }

    @Override
    public Double getProductCoefficient(IMolecule product) {
        return this.products.getMultiplier(product);
    }

    @Override
    public boolean setReactantCoefficient(IMolecule reactant, Double coefficient) {
        boolean result = this.reactants.setMultiplier(reactant, coefficient);
        return result;
    }

    @Override
    public boolean setProductCoefficient(IMolecule product, Double coefficient) {
        boolean result = this.products.setMultiplier(product, coefficient);
        return result;
    }

    @Override
    public Double[] getReactantCoefficients() {
        return this.reactants.getMultipliers();
    }

    @Override
    public Double[] getProductCoefficients() {
        return this.products.getMultipliers();
    }

    @Override
    public boolean setReactantCoefficients(Double[] coefficients) {
        boolean result = this.reactants.setMultipliers(coefficients);
        return result;
    }

    @Override
    public boolean setProductCoefficients(Double[] coefficients) {
        boolean result = this.products.setMultipliers(coefficients);
        return result;
    }

    @Override
    public void setDirection(IReaction.Direction direction) {
        this.reactionDirection = direction;
    }

    @Override
    public IReaction.Direction getDirection() {
        return this.reactionDirection;
    }

    @Override
    public void addMapping(IMapping mapping) {
        if (this.mappingCount + 1 >= this.map.length) {
            this.growMappingArray();
        }
        this.map[this.mappingCount] = mapping;
        ++this.mappingCount;
    }

    @Override
    public void removeMapping(int pos) {
        for (int i = pos; i < this.mappingCount - 1; ++i) {
            this.map[i] = this.map[i + 1];
        }
        this.map[this.mappingCount - 1] = null;
        --this.mappingCount;
    }

    @Override
    public IMapping getMapping(int pos) {
        return this.map[pos];
    }

    @Override
    public int getMappingCount() {
        return this.mappingCount;
    }

    private void growMappingArray() {
        Mapping[] newMap = new Mapping[this.map.length + this.growArraySize];
        System.arraycopy(this.map, 0, newMap, 0, this.map.length);
        this.map = newMap;
    }

    @Override
    public String toString() {
        StringBuffer description = new StringBuffer(64);
        description.append("Reaction(");
        description.append(this.getID());
        description.append(", #M:").append(this.mappingCount);
        description.append(", reactants=").append(this.reactants.toString());
        description.append(", products=").append(this.products.toString());
        description.append(", agents=").append(this.agents.toString());
        description.append(')');
        return description.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Reaction clone = (Reaction)super.clone();
        clone.reactants = (MoleculeSet)((MoleculeSet)this.reactants).clone();
        clone.agents = (MoleculeSet)((MoleculeSet)this.agents).clone();
        clone.products = (MoleculeSet)((MoleculeSet)this.products).clone();
        Hashtable<IAtom, IAtom> atomatom = new Hashtable<IAtom, IAtom>();
        for (int i = 0; i < this.reactants.getMoleculeCount(); ++i) {
            Molecule mol = (Molecule)((MoleculeSet)this.reactants).getMolecule(i);
            Molecule mol2 = (Molecule)clone.reactants.getMolecule(i);
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                atomatom.put(mol.getAtom(j), mol2.getAtom(j));
            }
        }
        clone.map = new Mapping[this.map.length];
        for (int f = 0; f < this.mappingCount; ++f) {
            clone.map[f] = new Mapping((ChemObject)atomatom.get(this.map[f].getChemObject(0)), (ChemObject)atomatom.get(this.map[f].getChemObject(1)));
        }
        return clone;
    }

    private class MappingIterator
    implements Iterator<IMapping> {
        private int pointer = 0;

        private MappingIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < Reaction.this.mappingCount;
        }

        @Override
        public IMapping next() {
            return Reaction.this.map[this.pointer++];
        }

        @Override
        public void remove() {
            Reaction.this.removeMapping(--this.pointer);
        }
    }
}

