/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.io.IOException;
import java.util.Comparator;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.AtomContainerComparatorTest")
public class AtomContainerComparator
implements Comparator<IAtomContainer> {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomContainerComparator.class);

    @Override
    @TestMethod(value="testCompare_Object_Object")
    public int compare(IAtomContainer o1, IAtomContainer o2) {
        double bondOrderSum2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (!(o1 instanceof IAtomContainer) && !(o2 instanceof IAtomContainer)) {
            return 0;
        }
        if (!(o1 instanceof IAtomContainer)) {
            return -1;
        }
        if (!(o2 instanceof IAtomContainer)) {
            return 1;
        }
        IAtomContainer atomContainer1 = o1;
        IAtomContainer atomContainer2 = o2;
        if (atomContainer1.getAtomCount() > atomContainer2.getAtomCount()) {
            return 1;
        }
        if (atomContainer1.getAtomCount() < atomContainer2.getAtomCount()) {
            return -1;
        }
        double mw1 = 0.0;
        double mw2 = 0.0;
        try {
            mw1 = this.getMolecularWeight(atomContainer1);
            mw2 = this.getMolecularWeight(atomContainer2);
        }
        catch (CDKException e) {
            this.logger.warn("Exception in molecular mass calculation.");
            return 0;
        }
        if (mw1 > mw2) {
            return 1;
        }
        if (mw1 < mw2) {
            return -1;
        }
        if (atomContainer1.getBondCount() > atomContainer2.getBondCount()) {
            return 1;
        }
        if (atomContainer1.getBondCount() < atomContainer2.getBondCount()) {
            return -1;
        }
        double bondOrderSum1 = AtomContainerManipulator.getSingleBondEquivalentSum(atomContainer1);
        if (bondOrderSum1 > (bondOrderSum2 = (double)AtomContainerManipulator.getSingleBondEquivalentSum(atomContainer2))) {
            return 1;
        }
        if (bondOrderSum1 < bondOrderSum2) {
            return -1;
        }
        return 0;
    }

    private double getMolecularWeight(IAtomContainer atomContainer) throws CDKException {
        double mw = 0.0;
        try {
            IsotopeFactory isotopeFactory = IsotopeFactory.getInstance(atomContainer.getBuilder());
            for (IAtom atom : atomContainer.atoms()) {
                IIsotope majorIsotope;
                if (atom.getSymbol().equals("H") || (majorIsotope = isotopeFactory.getMajorIsotope(atom.getSymbol())) == null || majorIsotope.getExactMass() == null) continue;
                mw += majorIsotope.getExactMass().doubleValue();
            }
        }
        catch (IOException e) {
            throw new CDKException(e.getMessage(), e);
        }
        return mw;
    }
}

