/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.Atom;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.AtomTypeTools;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MMFF94AtomTypeMatcher
implements IAtomTypeMatcher {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MMFF94AtomTypeMatcher.class);
    IBond.Order maxBondOrder = IBond.Order.SINGLE;
    private AtomTypeFactory factory = null;
    AtomTypeTools atomTypeTools = null;
    String[] atomTypeIds = new String[]{"C", "Csp2", "C=", "Csp", "CO2M", "CNN+", "C%", "CIM+", "CR4R", "CR3R", "CE4R", "Car", "C5A", "C5B", "C5", "HC", "HO", "HN", "HOCO", "HN=C", "HN2", "HOCC", "HOH", "HOS", "HN+", "HO+", "HO=+", "HP", "O", "O=", "OX", "OM", "O+", "O=+", "OH2", "Oar", "N", "N=C", "NC=C", "NSP", "=N=", "NAZT", "N+", "N2OX", "N3OX", "NC#N", "NO3", "N=O", "NC=O", "NSO", "N+=", "NCN+", "NGD+", "NR%", "NM", "N5M", "NPYD", "NPYL", "NPD+", "N5A", "N5B", "NPOX", "N5OX", "N5+", "N5", "S", "S=C", ">SN", "SO2", "SX", "SO2M", "=SO", "Sthi", "PTET", "P", "-P=C", "F", "CL", "BR", "I", "SI", "CL04", "FE+2", "FE+3", "F-", "CL-", "BR-", "LI+", "NA+", "K+", "ZN+2", "CA+2", "CU+1", "CU+2", "MG+2", "DU"};

    public MMFF94AtomTypeMatcher() {
        this.atomTypeTools = new AtomTypeTools();
    }

    private String getSphericalMatcher(IAtomType type) throws CDKException {
        return (String)type.getProperty("cdk:HOSE code spherical matcher");
    }

    private String getSphericalMatcher(String type) throws CDKException {
        return this.getSphericalMatcher(this.factory.getAtomType(type));
    }

    @TestMethod(value="testFindMatchingAtomType_IAtomContainer")
    public IAtomType[] findMatchingAtomType(IAtomContainer atomContainer) throws CDKException {
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            types[typeCounter] = this.findMatchingAtomType(atomContainer, atom);
            ++typeCounter;
        }
        return types;
    }

    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atomInterface) throws CDKException {
        if (this.factory == null) {
            try {
                this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/mmff94_atomtypes.xml", atomContainer.getBuilder());
            }
            catch (Exception ex1) {
                logger.error(ex1.getMessage());
                logger.debug(ex1);
                throw new CDKException("Could not instantiate the AtomType list!", ex1);
            }
        }
        Atom atom = (Atom)atomInterface;
        logger.debug(" Symbol:" + atom.getSymbol() + " HoseCode>" + atom.getProperty("cdk:HOSE code spherical matcher") + " ");
        if (atom instanceof IPseudoAtom) {
            return this.factory.getAtomTypes("DU")[0];
        }
        Pattern p1 = null;
        Pattern p2 = null;
        String ID = "";
        boolean atomTypeFlag = false;
        Matcher mat1 = null;
        Matcher mat2 = null;
        this.maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        for (int j = 0; j < this.atomTypeIds.length; ++j) {
            IBond.Order tmpMaxBondOrder = this.factory.getAtomType(this.atomTypeIds[j]).getMaxBondOrder();
            String atomSphericalMatcher = (String)this.factory.getAtomType(this.atomTypeIds[j]).getProperty("cdk:HOSE code spherical matcher");
            logger.debug(j + " ATOM TYPE " + (Object)((Object)tmpMaxBondOrder) + " " + atomSphericalMatcher);
            p1 = Pattern.compile(atomSphericalMatcher);
            mat1 = p1.matcher((String)atom.getProperty("cdk:HOSE code spherical matcher"));
            if (!mat1.matches()) continue;
            ID = this.atomTypeIds[j];
            Object property = atom.getProperty("cdk:Chemical Group");
            int atomChemGroupConstant = (Integer)property;
            Object ringSize = atom.getProperty("cdk:Part of ring of size");
            int atomRingSize = -1;
            if (ringSize != null) {
                atomRingSize = (Integer)ringSize;
            }
            if (this.atomTypeIds[j].equals("C")) {
                if (atomChemGroupConstant != -1) {
                    if (ringSize != null && this.maxBondOrder == IBond.Order.SINGLE) {
                        if (atomRingSize == 3) {
                            ID = this.atomTypeIds[9];
                        } else if (atomRingSize == 4) {
                            ID = this.atomTypeIds[8];
                        }
                    } else {
                        String type13Matcher = this.getSphericalMatcher(this.atomTypeIds[13]);
                        p1 = Pattern.compile(type13Matcher);
                        mat1 = p1.matcher(atomSphericalMatcher);
                        String type12Matcher = this.getSphericalMatcher(this.atomTypeIds[12]);
                        p2 = Pattern.compile(type12Matcher);
                        mat2 = p2.matcher(atomSphericalMatcher);
                        if (mat1.matches() && atomChemGroupConstant % 2 == 0 && atom.getFlag(32) && atomRingSize == 5) {
                            ID = this.atomTypeIds[13];
                        } else if (mat2.matches() && atomChemGroupConstant % 2 == 0 && atom.getFlag(32) && atomRingSize == 5) {
                            ID = this.atomTypeIds[12];
                        } else if (atomChemGroupConstant % 2 == 0 && atom.getFlag(32) && atomRingSize == 5) {
                            ID = this.atomTypeIds[14];
                        } else if (atom.getFlag(32)) {
                            ID = this.atomTypeIds[11];
                        }
                    }
                } else {
                    p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[66]));
                    mat1 = p1.matcher(atomSphericalMatcher);
                    if (mat1.matches()) {
                        ID = this.atomTypeIds[66];
                    }
                }
            } else if (this.atomTypeIds[j].equals("Csp2")) {
                if (atomChemGroupConstant % 2 == 0 & atomRingSize == 4 & !atom.getFlag(32)) {
                    ID = this.atomTypeIds[10];
                }
            } else if (this.atomTypeIds[j].equals("C=")) {
                if (atomChemGroupConstant % 2 == 0 && atom.getFlag(32)) {
                    ID = this.atomTypeIds[12];
                }
            } else if (this.atomTypeIds[j].equals("N")) {
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[48]));
                mat1 = p1.matcher(atomSphericalMatcher);
                if (mat1.matches() & atomChemGroupConstant == -1) {
                    ID = this.atomTypeIds[48];
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[44]))).matcher(atomSphericalMatcher)).matches() && this.maxBondOrder == tmpMaxBondOrder) {
                    ID = this.atomTypeIds[44];
                }
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[56]));
                mat1 = p1.matcher(atomSphericalMatcher);
                if (atomChemGroupConstant == 10) {
                    ID = this.atomTypeIds[56];
                } else if (atomChemGroupConstant == 4) {
                    ID = this.atomTypeIds[57];
                } else if (atomChemGroupConstant % 2 == 0 & atomRingSize == 5 & atom.getFlag(32)) {
                    ID = this.atomTypeIds[64];
                }
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[61]));
                mat1 = p1.matcher(atomSphericalMatcher);
                if (mat1.matches() && this.maxBondOrder == tmpMaxBondOrder) {
                    ID = this.atomTypeIds[43];
                }
                if (atom.getFlag(32)) {
                    if (mat1.matches() && atomChemGroupConstant == 12) {
                        ID = this.atomTypeIds[61];
                    } else if (mat1.matches() && atomRingSize == 5) {
                        ID = this.atomTypeIds[62];
                    }
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[45]))).matcher(this.getSphericalMatcher(atom))).matches()) {
                    ID = this.atomTypeIds[45];
                }
            } else if (this.atomTypeIds[j].equals("N=C")) {
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[59]));
                mat1 = p1.matcher(this.getSphericalMatcher(atom));
                if (atomChemGroupConstant != -1) {
                    if (mat1.matches() && atomChemGroupConstant % 2 == 0 && atom.getFlag(32) && atomRingSize == 5) {
                        ID = this.atomTypeIds[59];
                    } else if (atomChemGroupConstant == 10) {
                        ID = this.atomTypeIds[56];
                    } else if (atomChemGroupConstant == 4) {
                        ID = this.atomTypeIds[57];
                    }
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[43]))).matcher(this.getSphericalMatcher(atom))).matches()) {
                    ID = atomChemGroupConstant == 10 ? this.atomTypeIds[61] : (atom.getFlag(32) && atomRingSize == 5 ? this.atomTypeIds[62] : this.atomTypeIds[43]);
                }
            } else if (this.atomTypeIds[j].equals("N2OX")) {
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[46]));
                mat1 = p1.matcher(this.getSphericalMatcher(atom));
                if (mat1.matches() && atomChemGroupConstant == -1) {
                    ID = this.atomTypeIds[46];
                }
                if (atomChemGroupConstant == 12) {
                    ID = this.atomTypeIds[61];
                } else if (atomChemGroupConstant != -1 && atom.getFlag(32) && atomRingSize == 5) {
                    ID = this.atomTypeIds[62];
                }
            } else if (this.atomTypeIds[j].equals("=N=") || this.atomTypeIds[j].equals("NAZT")) {
                if (atomChemGroupConstant != -1 && atom.getFlag(32) && atomRingSize == 5) {
                    ID = this.atomTypeIds[59];
                }
            } else if (this.atomTypeIds[j].equals("N+=")) {
                if (atomChemGroupConstant != -1 && atom.getFlag(32) && atomRingSize == 5) {
                    ID = this.atomTypeIds[63];
                } else if (atomChemGroupConstant == 12) {
                    ID = this.atomTypeIds[58];
                }
            } else if (this.atomTypeIds[j].equals("O")) {
                if (atomChemGroupConstant == 6) {
                    ID = this.atomTypeIds[35];
                }
            } else if (this.atomTypeIds[j].equals("HO")) {
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[21]));
                mat1 = p1.matcher(atomSphericalMatcher);
                if (mat1.matches()) {
                    ID = this.atomTypeIds[21];
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[18]))).matcher(atomSphericalMatcher)).matches()) {
                    ID = this.atomTypeIds[18];
                }
            } else if (this.atomTypeIds[j].equals("P")) {
                p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[75]));
                mat1 = p1.matcher(atomSphericalMatcher);
                if (mat1.matches()) {
                    ID = this.atomTypeIds[75];
                }
            } else if (this.atomTypeIds[j].equals("S")) {
                if (atomRingSize == 5 && atom.getFlag(32)) {
                    ID = this.atomTypeIds[72];
                }
            } else if (this.atomTypeIds[j].equals("HC") && (mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("HP"))).matcher((String)atom.getProperty("cdk:HOSE code spherical matcher"))).matches()) {
                ID = "HP";
            }
            atomTypeFlag = true;
            logger.debug(" MATCH AtomTypeID:" + j + " " + ID);
            break;
        }
        if (atomTypeFlag) {
            atomTypeFlag = false;
            return this.factory.getAtomType(ID);
        }
        return this.factory.getAtomType("DU");
    }
}

