/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.ReactionSceneGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.renderer.generators.ProductsBoxGeneratorTest")
public class ProductsBoxGenerator
implements IGenerator<IReaction> {
    @Override
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        if (!((Boolean)model.getParameter(ReactionSceneGenerator.ShowReactionBoxes.class).getValue()).booleanValue()) {
            return null;
        }
        if (reaction.getProductCount() == 0) {
            return new ElementGroup();
        }
        double distance = (Double)model.getParameter(BasicBondGenerator.BondLength.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue() / 2.0;
        Rectangle2D totalBounds = null;
        for (IAtomContainer molecule : reaction.getProducts().atomContainers()) {
            Rectangle2D bounds = BoundsCalculator.calculateBounds(molecule);
            if (totalBounds == null) {
                totalBounds = bounds;
                continue;
            }
            totalBounds = totalBounds.createUnion(bounds);
        }
        if (totalBounds == null) {
            return null;
        }
        ElementGroup diagram = new ElementGroup();
        Color foregroundColor = (Color)model.getParameter(BasicSceneGenerator.ForegroundColor.class).getValue();
        diagram.add(new RectangleElement(totalBounds.getMinX() - distance, totalBounds.getMinY() - distance, totalBounds.getMaxX() + distance, totalBounds.getMaxY() + distance, foregroundColor));
        diagram.add(new TextElement((totalBounds.getMinX() + totalBounds.getMaxX()) / 2.0, totalBounds.getMinY() - distance, "Products", foregroundColor));
        return diagram;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

