/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SMILESFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.SMILESWriterTest")
public class SMILESWriter
extends DefaultChemObjectWriter {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMILESWriter.class);
    private BufferedWriter writer;
    private BooleanIOSetting useAromaticityFlag;

    public SMILESWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initIOSettings();
    }

    public SMILESWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public SMILESWriter() {
        this(new StringWriter());
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return SMILESFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public SMILESWriter(FileOutputStream out) {
        this(new OutputStreamWriter(out));
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtomContainerSet.class.equals(interfaces[i])) {
                return true;
            }
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainerSet) {
            this.writeAtomContainerSet((IAtomContainerSet)object);
        } else if (object instanceof IAtomContainer) {
            this.writeAtomContainer((IAtomContainer)object);
        } else {
            throw new CDKException("Only supported is writing of ChemFile and Molecule objects.");
        }
    }

    public void writeAtomContainerSet(IAtomContainerSet som) {
        this.writeAtomContainer(som.getAtomContainer(0));
        for (int i = 1; i <= som.getAtomContainerCount() - 1; ++i) {
            try {
                this.writeAtomContainer(som.getAtomContainer(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeAtomContainer(IAtomContainer molecule) {
        SmilesGenerator sg = new SmilesGenerator();
        sg.setUseAromaticityFlag(this.useAromaticityFlag.isSet());
        String smiles = "";
        try {
            smiles = sg.createSMILES(molecule);
            logger.debug("Generated SMILES: " + smiles);
            this.writer.write(smiles);
            this.writer.newLine();
            this.writer.flush();
            logger.debug("file flushed...");
        }
        catch (Exception exc) {
            logger.error("Error while writing Molecule: ", exc.getMessage());
            logger.debug(exc);
        }
    }

    private void initIOSettings() {
        this.useAromaticityFlag = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("UseAromaticity", IOSetting.Importance.LOW, "Should aromaticity information be stored in the SMILES?", "false"));
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.useAromaticityFlag);
    }
}

