/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openscience.cdk.controller.IMouseEventRelay;

public class SwingMouseEventRelay
implements MouseMotionListener,
MouseListener {
    private IMouseEventRelay relay;
    private int dragFromX = 0;
    private int dragFromY = 0;

    public SwingMouseEventRelay(IMouseEventRelay relay) {
        this.relay = relay;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.relay.mouseMove(event.getX(), event.getY());
    }

    public void updateView() {
        System.out.println("updating View now in SwingMouseEventRelay");
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.relay.mouseDrag(this.dragFromX, this.dragFromY, event.getX(), event.getY());
        this.dragFromX = event.getX();
        this.dragFromY = event.getY();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 1) {
            this.relay.mouseClickedDouble(event.getX(), event.getY());
        }
        System.out.println("mouseClicked at: " + event.getX() + "/" + event.getY() + " event.getClickCount(): " + event.getClickCount());
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.relay.mouseEnter(event.getX(), event.getY());
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.relay.mouseExit(event.getX(), event.getY());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.relay.mouseClickedDown(event.getX(), event.getY());
        System.out.println("mousePressed at: " + event.getX() + "/" + event.getY());
        this.dragFromX = event.getX();
        this.dragFromY = event.getY();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.relay.mouseClickedUp(event.getX(), event.getY());
    }
}

