/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.group.AbstractDiscretePartitionRefiner;
import org.openscience.cdk.group.BondEquitablePartitionRefiner;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Permutation;
import org.openscience.cdk.group.PermutationGroup;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class BondDiscretePartitionRefiner
extends AbstractDiscretePartitionRefiner {
    private int[][] connectionTable;
    private boolean ignoreBondOrders;

    public BondDiscretePartitionRefiner() {
        this(false);
    }

    public BondDiscretePartitionRefiner(boolean ignoreBondOrders) {
        this.ignoreBondOrders = ignoreBondOrders;
    }

    @Override
    public int getVertexCount() {
        return this.connectionTable.length;
    }

    @Override
    public int getConnectivity(int i, int j) {
        int maxRowIndex = this.connectionTable[i].length;
        for (int indexInRow = 0; indexInRow < maxRowIndex; ++indexInRow) {
            if (this.connectionTable[i][indexInRow] != j) continue;
            return 1;
        }
        return 0;
    }

    public int[] getConnectedIndices(int bondIndex) {
        return this.connectionTable[bondIndex];
    }

    public Partition getBondPartition(IAtomContainer atomContainer) {
        int bondCount = atomContainer.getBondCount();
        HashMap cellMap = new HashMap();
        for (int bondIndex = 0; bondIndex < bondCount; ++bondIndex) {
            SortedSet<Integer> cell;
            String boS;
            IBond bond = atomContainer.getBond(bondIndex);
            String el0 = bond.getAtom(0).getSymbol();
            String el1 = bond.getAtom(1).getSymbol();
            if (this.ignoreBondOrders) {
                boS = "1";
            } else {
                boolean isArom = bond.getFlag(32);
                int orderNumber = isArom ? 5 : bond.getOrder().numeric();
                boS = String.valueOf(orderNumber);
            }
            String bondString = el0.compareTo(el1) < 0 ? el0 + boS + el1 : el1 + boS + el0;
            if (cellMap.containsKey(bondString)) {
                cell = (SortedSet)cellMap.get(bondString);
            } else {
                cell = new TreeSet();
                cellMap.put(bondString, cell);
            }
            cell.add(bondIndex);
        }
        ArrayList bondStrings = new ArrayList(cellMap.keySet());
        Collections.sort(bondStrings);
        Partition bondPartition = new Partition();
        for (String key : bondStrings) {
            SortedSet cell = (SortedSet)cellMap.get(key);
            bondPartition.addCell(cell);
        }
        bondPartition.order();
        return bondPartition;
    }

    public void reset() {
        this.connectionTable = null;
    }

    public void refine(IAtomContainer atomContainer) {
        this.refine(atomContainer, this.getBondPartition(atomContainer));
    }

    public void refine(IAtomContainer atomContainer, Partition partition) {
        this.setup(atomContainer);
        super.refine(partition);
    }

    public boolean isCanonical(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.getBondPartition(atomContainer));
        return this.isCanonical();
    }

    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.getBondPartition(atomContainer));
        return super.getAutomorphismGroup();
    }

    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer, PermutationGroup group) {
        this.setup(atomContainer, group);
        super.refine(this.getBondPartition(atomContainer));
        return this.getAutomorphismGroup();
    }

    public PermutationGroup getAutomorphismGroup(IAtomContainer atomContainer, Partition initialPartition) {
        this.setup(atomContainer);
        super.refine(initialPartition);
        return super.getAutomorphismGroup();
    }

    public Partition getAutomorphismPartition(IAtomContainer atomContainer) {
        this.setup(atomContainer);
        super.refine(this.getBondPartition(atomContainer));
        return super.getAutomorphismPartition();
    }

    private void setup(IAtomContainer atomContainer) {
        if (this.connectionTable == null) {
            this.setupConnectionTable(atomContainer);
        }
        int size = this.getVertexCount();
        PermutationGroup group = new PermutationGroup(new Permutation(size));
        super.setup(group, new BondEquitablePartitionRefiner(this));
    }

    private void setup(IAtomContainer atomContainer, PermutationGroup group) {
        this.setupConnectionTable(atomContainer);
        super.setup(group, new BondEquitablePartitionRefiner(this));
    }

    private void setupConnectionTable(IAtomContainer atomContainer) {
        int bondCount = atomContainer.getBondCount();
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        HashMap<String, Object> bondMap = new HashMap<String, Object>();
        for (int bondIndexI = 0; bondIndexI < bondCount; ++bondIndexI) {
            String boS;
            IBond bond = atomContainer.getBond(bondIndexI);
            bonds.add(bond);
            int a0 = atomContainer.getAtomNumber(bond.getAtom(0));
            int a1 = atomContainer.getAtomNumber(bond.getAtom(1));
            if (this.ignoreBondOrders) {
                boS = "1";
            } else {
                boolean isArom = bond.getFlag(32);
                int orderNumber = isArom ? 5 : bond.getOrder().numeric();
                boS = String.valueOf(orderNumber);
            }
            String bondString = a0 < a1 ? a0 + "," + boS + "," + a1 : a1 + "," + boS + "," + a0;
            bondMap.put(bondString, bond);
        }
        ArrayList keys = new ArrayList(bondMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            bonds.add((IBond)bondMap.get(key));
        }
        this.connectionTable = new int[bondCount][];
        for (int bondIndexI = 0; bondIndexI < bondCount; ++bondIndexI) {
            IBond bondI = (IBond)bonds.get(bondIndexI);
            ArrayList<Integer> connectedBondIndices = new ArrayList<Integer>();
            for (int bondIndexJ = 0; bondIndexJ < bondCount; ++bondIndexJ) {
                IBond bondJ;
                if (bondIndexI == bondIndexJ || !bondI.isConnectedTo(bondJ = (IBond)bonds.get(bondIndexJ))) continue;
                connectedBondIndices.add(bondIndexJ);
            }
            int connBondCount = connectedBondIndices.size();
            this.connectionTable[bondIndexI] = new int[connBondCount];
            for (int index = 0; index < connBondCount; ++index) {
                this.connectionTable[bondIndexI][index] = (Integer)connectedBondIndices.get(index);
            }
        }
    }
}

