/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import java.util.Iterator;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.AtomMatcher;
import org.openscience.cdk.isomorphism.BondMatcher;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.StateStream;
import org.openscience.cdk.isomorphism.UllmannState;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;

public final class Ullmann
extends Pattern {
    private final IAtomContainer query;
    private final int[][] g1;
    private final GraphUtil.EdgeToBondMap bonds1;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;
    private final boolean queryMatching;

    private Ullmann(IAtomContainer query2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        this.query = query2;
        this.atomMatcher = atomMatcher;
        this.bondMatcher = bondMatcher;
        this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query2);
        this.g1 = GraphUtil.toAdjList(query2, this.bonds1);
        this.queryMatching = query2 instanceof IQueryAtomContainer;
    }

    @Override
    public int[] match(IAtomContainer target) {
        return this.matchAll(target).stereochemistry().first();
    }

    @Override
    public Mappings matchAll(IAtomContainer target) {
        GraphUtil.EdgeToBondMap bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
        int[][] g2 = GraphUtil.toAdjList(target, bonds2);
        UllmannIterable iterable = new UllmannIterable(this.query, target, this.g1, g2, this.bonds1, bonds2, this.atomMatcher, this.bondMatcher);
        return new Mappings(this.query, target, iterable);
    }

    public static Pattern findSubstructure(IAtomContainer query2) {
        boolean isQuery = query2 instanceof IQueryAtomContainer;
        return new Ullmann(query2, isQuery ? AtomMatcher.forQuery() : AtomMatcher.forElement(), isQuery ? BondMatcher.forQuery() : BondMatcher.forOrder());
    }

    private static final class UllmannIterable
    implements Iterable<int[]> {
        private final IAtomContainer container1;
        private final IAtomContainer container2;
        private final int[][] g1;
        private final int[][] g2;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;
        private final AtomMatcher atomMatcher;
        private final BondMatcher bondMatcher;

        private UllmannIterable(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
            this.container1 = container1;
            this.container2 = container2;
            this.g1 = g1;
            this.g2 = g2;
            this.bonds1 = bonds1;
            this.bonds2 = bonds2;
            this.atomMatcher = atomMatcher;
            this.bondMatcher = bondMatcher;
        }

        @Override
        public Iterator<int[]> iterator() {
            return new StateStream(new UllmannState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher));
        }
    }
}

