/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class RotatableBondsCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean includeTerminals = false;
    private boolean excludeAmides = false;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#rotatableBondsCount", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 2) {
            throw new CDKException("RotatableBondsCount expects two parameters");
        }
        if (!(params[0] instanceof Boolean) || !(params[1] instanceof Boolean)) {
            throw new CDKException("The parameters must be of type Boolean");
        }
        this.includeTerminals = (Boolean)params[0];
        this.excludeAmides = (Boolean)params[1];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.includeTerminals, this.excludeAmides};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{this.includeTerminals ? "nRotBt" : "nRotB"};
    }

    @Override
    public DescriptorValue calculate(IAtomContainer ac) {
        IRingSet ringSet;
        int rotatableBondsCount = 0;
        try {
            ringSet = new SpanningTree(ac).getBasicRings();
        }
        catch (NoSuchAtomException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
        }
        for (IBond bond : ac.bonds()) {
            if (ringSet.getRings(bond).getAtomContainerCount() <= 0) continue;
            bond.setFlag(2, true);
        }
        for (IBond bond : ac.bonds()) {
            IAtom atom0 = bond.getAtom(0);
            IAtom atom1 = bond.getAtom(1);
            if (atom0.getSymbol().equals("H") || atom1.getSymbol().equals("H") || bond.getOrder() != IBond.Order.SINGLE || !BondManipulator.isLowerOrder(ac.getMaximumBondOrder(atom0), IBond.Order.TRIPLE) || !BondManipulator.isLowerOrder(ac.getMaximumBondOrder(atom1), IBond.Order.TRIPLE) || bond.getFlag(2) || this.excludeAmides && (this.isAmide(atom0, atom1, ac) || this.isAmide(atom1, atom0, ac))) continue;
            int degree0 = ac.getConnectedBondsCount(atom0) - this.getConnectedHCount(ac, atom0);
            int degree1 = ac.getConnectedBondsCount(atom1) - this.getConnectedHCount(ac, atom1);
            if (degree0 == 1 || degree1 == 1) {
                if (!this.includeTerminals) continue;
                ++rotatableBondsCount;
                continue;
            }
            ++rotatableBondsCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(rotatableBondsCount), this.getDescriptorNames());
    }

    private boolean isAmide(IAtom atom0, IAtom atom1, IAtomContainer ac) {
        if (atom0.getSymbol().equals("C") && atom1.getSymbol().equals("N")) {
            for (IAtom neighbor : ac.getConnectedAtomsList(atom0)) {
                if (!neighbor.getSymbol().equals("O") || ac.getBond(atom0, neighbor).getOrder() != IBond.Order.DOUBLE) continue;
                return true;
            }
        }
        return false;
    }

    private int getConnectedHCount(IAtomContainer atomContainer, IAtom atom) {
        List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
        int n = 0;
        for (IAtom anAtom : connectedAtoms) {
            if (!anAtom.getSymbol().equals("H")) continue;
            ++n;
        }
        return n;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"includeTerminals", "excludeAmides"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }
}

